/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.Operands;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class DecodeCSV
extends PrimitiveOp
implements Iterable<Operand<Object>> {
    private List<Output<?>> output;

    public static DecodeCSV create(Scope scope, Operand<String> records, Iterable<Operand<?>> recordDefaults, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("DecodeCSV", scope.makeOpName("DecodeCSV"));
        opBuilder.addInput(records.asOutput());
        opBuilder.addInputList(Operands.asOutputs(recordDefaults));
        if (options != null) {
            for (Options opts : options) {
                if (opts.fieldDelim != null) {
                    opBuilder.setAttr("field_delim", opts.fieldDelim);
                }
                if (opts.useQuoteDelim != null) {
                    opBuilder.setAttr("use_quote_delim", opts.useQuoteDelim);
                }
                if (opts.naValue != null) {
                    opBuilder.setAttr("na_value", opts.naValue);
                }
                if (opts.selectCols == null) continue;
                long[] selectColsArray = new long[opts.selectCols.size()];
                for (int i = 0; i < selectColsArray.length; ++i) {
                    selectColsArray[i] = (Long)opts.selectCols.get(i);
                }
                opBuilder.setAttr("select_cols", selectColsArray);
            }
        }
        return new DecodeCSV(opBuilder.build());
    }

    public static Options fieldDelim(String fieldDelim) {
        return new Options().fieldDelim(fieldDelim);
    }

    public static Options useQuoteDelim(Boolean useQuoteDelim) {
        return new Options().useQuoteDelim(useQuoteDelim);
    }

    public static Options naValue(String naValue) {
        return new Options().naValue(naValue);
    }

    public static Options selectCols(List<Long> selectCols) {
        return new Options().selectCols(selectCols);
    }

    public List<Output<?>> output() {
        return this.output;
    }

    @Override
    public Iterator<Operand<Object>> iterator() {
        return this.output.iterator();
    }

    private DecodeCSV(Operation operation) {
        super(operation);
        int outputIdx = 0;
        int outputLength = operation.outputListLength("output");
        this.output = Arrays.asList(operation.outputList(outputIdx, outputLength));
        outputIdx += outputLength;
    }

    public static class Options {
        private String fieldDelim;
        private Boolean useQuoteDelim;
        private String naValue;
        private List<Long> selectCols;

        public Options fieldDelim(String fieldDelim) {
            this.fieldDelim = fieldDelim;
            return this;
        }

        public Options useQuoteDelim(Boolean useQuoteDelim) {
            this.useQuoteDelim = useQuoteDelim;
            return this;
        }

        public Options naValue(String naValue) {
            this.naValue = naValue;
            return this;
        }

        public Options selectCols(List<Long> selectCols) {
            this.selectCols = selectCols;
            return this;
        }

        private Options() {
        }
    }
}

