/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow.op.core;

import org.tensorflow.DataType;
import org.tensorflow.Operand;
import org.tensorflow.Operation;
import org.tensorflow.OperationBuilder;
import org.tensorflow.Output;
import org.tensorflow.op.PrimitiveOp;
import org.tensorflow.op.Scope;

public final class CropAndResizeGradImage<T extends Number>
extends PrimitiveOp
implements Operand<T> {
    private Output<T> output;

    public static <T extends Number> CropAndResizeGradImage<T> create(Scope scope, Operand<Float> grads, Operand<Float> boxes, Operand<Integer> boxInd, Operand<Integer> imageSize, Class<T> T, Options ... options) {
        OperationBuilder opBuilder = scope.graph().opBuilder("CropAndResizeGradImage", scope.makeOpName("CropAndResizeGradImage"));
        opBuilder.addInput(grads.asOutput());
        opBuilder.addInput(boxes.asOutput());
        opBuilder.addInput(boxInd.asOutput());
        opBuilder.addInput(imageSize.asOutput());
        opBuilder.setAttr("T", DataType.fromClass(T));
        if (options != null) {
            for (Options opts : options) {
                if (opts.method == null) continue;
                opBuilder.setAttr("method", opts.method);
            }
        }
        return new CropAndResizeGradImage<T>(opBuilder.build());
    }

    public static Options method(String method) {
        return new Options().method(method);
    }

    public Output<T> output() {
        return this.output;
    }

    @Override
    public Output<T> asOutput() {
        return this.output;
    }

    private CropAndResizeGradImage(Operation operation) {
        super(operation);
        int outputIdx = 0;
        this.output = operation.output(outputIdx++);
    }

    public static class Options {
        private String method;

        public Options method(String method) {
            this.method = method;
            return this;
        }

        private Options() {
        }
    }
}

