/*
 * Decompiled with CFR 0.152.
 */
package org.tensorflow;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.tensorflow.TensorFlow;

final class NativeLibrary {
    private static final boolean DEBUG = System.getProperty("org.tensorflow.NativeLibrary.DEBUG") != null;
    private static final String LIBNAME = "tensorflow_jni";

    NativeLibrary() {
    }

    public static void load() {
        if (NativeLibrary.isLoaded() || NativeLibrary.tryLoadLibrary()) {
            return;
        }
        String resourceName = NativeLibrary.makeResourceName();
        NativeLibrary.log("resourceName: " + resourceName);
        InputStream resource = NativeLibrary.class.getClassLoader().getResourceAsStream(resourceName);
        if (resource == null) {
            throw new UnsatisfiedLinkError(String.format("Cannot find TensorFlow native library for OS: %s, architecture: %s. See https://github.com/tensorflow/tensorflow/tree/master/java/README.md for possible solutions (such as building the library from source).", NativeLibrary.os(), NativeLibrary.architecture()));
        }
        try {
            System.load(NativeLibrary.extractResource(resource));
        }
        catch (IOException e) {
            throw new UnsatisfiedLinkError(String.format("Unable to extract native library into a temporary file (%s)", e.toString()));
        }
    }

    private static boolean tryLoadLibrary() {
        try {
            System.loadLibrary(LIBNAME);
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            NativeLibrary.log("tryLoadLibraryFailed: " + e.getMessage());
            return false;
        }
    }

    private static boolean isLoaded() {
        try {
            TensorFlow.version();
            NativeLibrary.log("isLoaded: true");
            return true;
        }
        catch (UnsatisfiedLinkError e) {
            return false;
        }
    }

    private static String extractResource(InputStream resource) throws IOException {
        String sampleFilename = System.mapLibraryName(LIBNAME);
        int dot = sampleFilename.indexOf(".");
        String prefix = dot < 0 ? sampleFilename : sampleFilename.substring(0, dot);
        String suffix = dot < 0 ? null : sampleFilename.substring(dot);
        File dst = File.createTempFile(prefix, suffix);
        String dstPath = dst.getAbsolutePath();
        dst.deleteOnExit();
        NativeLibrary.log("extracting native library to: " + dstPath);
        long nbytes = NativeLibrary.copy(resource, dst);
        NativeLibrary.log(String.format("copied %d bytes to %s", nbytes, dstPath));
        return dstPath;
    }

    private static String os() {
        String p = System.getProperty("os.name").toLowerCase();
        if (p.contains("linux")) {
            return "linux";
        }
        if (p.contains("os x") || p.contains("darwin")) {
            return "darwin";
        }
        if (p.contains("windows")) {
            return "windows";
        }
        return p.replaceAll("\\s", "");
    }

    private static String architecture() {
        String arch = System.getProperty("os.arch").toLowerCase();
        return arch.equals("amd64") ? "x86_64" : arch;
    }

    private static void log(String msg) {
        if (DEBUG) {
            System.err.println("org.tensorflow.NativeLibrary: " + msg);
        }
    }

    private static String makeResourceName() {
        String separator = System.getProperty("file.separator");
        return "org" + separator + "tensorflow" + separator + "native" + separator + String.format("%s-%s", NativeLibrary.os(), NativeLibrary.architecture()) + separator + System.mapLibraryName(LIBNAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long copy(InputStream src, File dstFile) throws IOException {
        FileOutputStream dst = new FileOutputStream(dstFile);
        try {
            byte[] buffer = new byte[0x100000];
            long ret = 0L;
            int n = 0;
            while ((n = src.read(buffer)) >= 0) {
                dst.write(buffer, 0, n);
                ret += (long)n;
            }
            long l = ret;
            return l;
        }
        finally {
            dst.close();
            src.close();
        }
    }
}

