/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.bot.services;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import org.telegram.bot.services.BotLogger;

public class NotificationsService {
    private static final String LOGTAG = "NOTIFICATIONSSERVICE";
    private static NotificationsService instance;
    private static int notificationsCounter;
    public static final int updatesInvalidated;
    public static final int needGetUpdates;
    private final NotificationsThread thread;
    private final ConcurrentLinkedDeque<Notification> notificationsQueue = new ConcurrentLinkedDeque();
    private final ConcurrentHashMap<Integer, ConcurrentLinkedDeque<NotificationObserver>> observers = new ConcurrentHashMap();

    private NotificationsService() {
        this.thread = new NotificationsThread();
        this.thread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NotificationsService getInstance() {
        if (instance != null) return instance;
        Class<NotificationsService> clazz = NotificationsService.class;
        synchronized (NotificationsService.class) {
            if (instance != null) return instance;
            instance = new NotificationsService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addObserver(NotificationObserver observer, int notificationId) {
        ConcurrentHashMap<Integer, ConcurrentLinkedDeque<NotificationObserver>> concurrentHashMap = this.observers;
        synchronized (concurrentHashMap) {
            if (this.observers.containsKey(notificationId)) {
                if (!this.observers.get(notificationId).contains(observer)) {
                    this.observers.get(notificationId).add(observer);
                }
            } else {
                ConcurrentLinkedDeque<NotificationObserver> newObservers = new ConcurrentLinkedDeque<NotificationObserver>();
                newObservers.add(observer);
                this.observers.put(notificationId, newObservers);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeObserver(NotificationObserver observer, int notificationId) {
        ConcurrentHashMap<Integer, ConcurrentLinkedDeque<NotificationObserver>> concurrentHashMap = this.observers;
        synchronized (concurrentHashMap) {
            if (this.observers.containsKey(notificationId)) {
                this.observers.get(notificationId).remove(observer);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postNotification(int notificationId, Object ... args) {
        Notification notification = new Notification(notificationId, args);
        this.notificationsQueue.addLast(notification);
        ConcurrentLinkedDeque<Notification> concurrentLinkedDeque = this.notificationsQueue;
        synchronized (concurrentLinkedDeque) {
            this.notificationsQueue.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleNotification(Notification notification) {
        ConcurrentLinkedDeque<NotificationObserver> notificationObservers = null;
        ConcurrentHashMap<Integer, ConcurrentLinkedDeque<NotificationObserver>> concurrentHashMap = this.observers;
        synchronized (concurrentHashMap) {
            if (this.observers.containsKey(notification.notificationId)) {
                notificationObservers = this.observers.get(notification.notificationId);
            }
        }
        if (notificationObservers != null) {
            for (NotificationObserver observer : notificationObservers) {
                observer.onNotificationReceived(notification.notificationId, notification.args);
            }
        }
    }

    static {
        updatesInvalidated = notificationsCounter++;
        needGetUpdates = notificationsCounter++;
    }

    private class NotificationsThread
    extends Thread {
        public NotificationsThread() {
            this.setName("NotificationsThread#" + this.getId());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                Notification currentNotification;
                if ((currentNotification = (Notification)NotificationsService.this.notificationsQueue.pollFirst()) == null) {
                    try {
                        ConcurrentLinkedDeque concurrentLinkedDeque = NotificationsService.this.notificationsQueue;
                        synchronized (concurrentLinkedDeque) {
                            NotificationsService.this.notificationsQueue.wait();
                        }
                    }
                    catch (InterruptedException e) {
                        BotLogger.error(NotificationsService.LOGTAG, e);
                    }
                    continue;
                }
                NotificationsService.this.handleNotification(currentNotification);
            }
        }
    }

    private static class Notification {
        public int notificationId;
        public Object[] args;

        public Notification(int notificationId, Object ... args) {
            this.notificationId = notificationId;
            this.args = args;
        }
    }

    public static interface NotificationObserver {
        public void onNotificationReceived(int var1, Object ... var2);
    }
}

