/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.bot.kernel;

import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.telegram.bot.kernel.CustomTimerTask;
import org.telegram.bot.services.BotLogger;

public class TimerExecutor {
    private static final String LOGTAG = "TIMEREXECUTOR";
    private static volatile TimerExecutor instance;
    private static final ScheduledExecutorService executorService;

    private TimerExecutor() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TimerExecutor getInstance() {
        TimerExecutor currentInstance;
        if (instance == null) {
            Class<TimerExecutor> clazz = TimerExecutor.class;
            synchronized (TimerExecutor.class) {
                if (instance == null) {
                    instance = new TimerExecutor();
                }
                currentInstance = instance;
                // ** MonitorExit[var1] (shouldn't be in output)
            }
        } else {
            currentInstance = instance;
        }
        return currentInstance;
    }

    public void startExecutionEveryDayAt(CustomTimerTask task, int targetHour, int targetMin, int targetSec) {
        BotLogger.warning(LOGTAG, "Posting new task" + task.getTaskName());
        Runnable taskWrapper = () -> {
            try {
                task.execute();
                task.reduceTimes();
                this.startExecutionEveryDayAt(task, targetHour, targetMin, targetSec);
            }
            catch (Exception e) {
                BotLogger.severe(LOGTAG, "Bot threw an unexpected exception at TimerExecutor", e);
            }
        };
        if (task.getTimes() != 0) {
            long delay = this.computNextDilay(targetHour, targetMin, targetSec);
            executorService.schedule(taskWrapper, delay, TimeUnit.SECONDS);
        }
    }

    public void startExecutionEach(CustomTimerTask task, int targetHour, int targetMin, int targetSec) {
        BotLogger.warning(LOGTAG, "Posting new task" + task.getTaskName());
        Runnable taskWrapper = () -> {
            try {
                task.execute();
                task.reduceTimes();
                this.startExecutionEach(task, targetHour, targetMin, targetSec);
            }
            catch (Exception e) {
                BotLogger.severe(LOGTAG, "Bot threw an unexpected exception at TimerExecutor", e);
            }
        };
        if (task.getTimes() != 0) {
            long delay = this.computNextTime(targetHour, targetMin, targetSec);
            if (delay < 10L) {
                delay = 10L;
            }
            executorService.schedule(taskWrapper, delay, TimeUnit.SECONDS);
        }
    }

    private long computNextDilay(int targetHour, int targetMin, int targetSec) {
        LocalDateTime localNow = LocalDateTime.now();
        ZoneId currentZone = ZoneId.systemDefault();
        ZonedDateTime zonedNow = ZonedDateTime.of(localNow, currentZone);
        ZonedDateTime zonedNextTarget = zonedNow.withHour(targetHour).withMinute(targetMin).withSecond(targetSec);
        while (zonedNow.compareTo(zonedNextTarget) > 0) {
            zonedNextTarget = zonedNextTarget.plusDays(1L);
        }
        Duration duration = Duration.between(zonedNow, zonedNextTarget);
        return duration.getSeconds();
    }

    private long computNextTime(int hourOffset, int minOffset, int secOffset) {
        LocalDateTime localNow = LocalDateTime.now();
        ZoneId currentZone = ZoneId.systemDefault();
        ZonedDateTime zonedNow = ZonedDateTime.of(localNow, currentZone);
        ZonedDateTime zonedNextTarget = zonedNow.plusHours(hourOffset).plusMinutes(minOffset).plusSeconds(secOffset);
        while (zonedNow.compareTo(zonedNextTarget) > 0) {
            zonedNextTarget = zonedNextTarget.plusSeconds(5L);
        }
        Duration duration = Duration.between(zonedNow, zonedNextTarget);
        return duration.getSeconds();
    }

    public void finalize() {
        this.stop();
    }

    public void stop() {
        executorService.shutdown();
        try {
            executorService.awaitTermination(1L, TimeUnit.DAYS);
        }
        catch (InterruptedException ex) {
            BotLogger.severe(LOGTAG, ex);
        }
        catch (Exception e) {
            BotLogger.severe(LOGTAG, "Bot threw an unexpected exception at TimerExecutor", e);
        }
    }

    static {
        executorService = Executors.newScheduledThreadPool(1);
    }
}

