/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.bot.kernel;

import java.util.List;
import java.util.PriorityQueue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.telegram.api.engine.RpcException;
import org.telegram.api.functions.updates.TLRequestUpdatesGetState;
import org.telegram.api.updates.TLAbsUpdates;
import org.telegram.api.updates.TLUpdateShort;
import org.telegram.api.updates.TLUpdateShortChatMessage;
import org.telegram.api.updates.TLUpdateShortMessage;
import org.telegram.api.updates.TLUpdateShortSentMessage;
import org.telegram.api.updates.TLUpdates;
import org.telegram.api.updates.TLUpdatesCombined;
import org.telegram.api.updates.TLUpdatesState;
import org.telegram.api.updates.TLUpdatesTooLong;
import org.telegram.bot.handlers.UpdatesHandlerBase;
import org.telegram.bot.handlers.interfaces.IUpdatesHandler;
import org.telegram.bot.kernel.IKernelComm;
import org.telegram.bot.kernel.UpdateWrapper;
import org.telegram.bot.services.BotLogger;
import org.telegram.bot.services.NotificationsService;
import org.telegram.tl.TLObject;

public class MainHandler
implements NotificationsService.NotificationObserver {
    private static final String LOGTAG = "KERNELHANDLER";
    private final IKernelComm kernelComm;
    private boolean running;
    private final AtomicBoolean gettingDifferences = new AtomicBoolean(false);
    private final AtomicBoolean needGetUpdateState = new AtomicBoolean(true);
    private final ConcurrentLinkedDeque<TLAbsUpdates> updatesQueue = new ConcurrentLinkedDeque();
    private final IUpdatesHandler updatesHandler;
    private final UpdateHandlerThread updateHandlerThread;

    MainHandler(IKernelComm kernelComm, UpdatesHandlerBase updatesHandler) {
        NotificationsService.getInstance().addObserver(this, NotificationsService.needGetUpdates);
        this.kernelComm = kernelComm;
        this.updatesHandler = updatesHandler;
        this.running = false;
        new UpdatesHandlerThread().start();
        this.updateHandlerThread = new UpdateHandlerThread();
        this.updateHandlerThread.start();
        kernelComm.setMainHandler(this);
    }

    public void start() {
        this.updatesQueue.clear();
        this.running = true;
    }

    void stop() {
        this.running = false;
    }

    public boolean isRunning() {
        return this.running;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onUpdate(@NotNull TLAbsUpdates updates) {
        if (this.running) {
            this.updatesQueue.addLast(updates);
            ConcurrentLinkedDeque<TLAbsUpdates> concurrentLinkedDeque = this.updatesQueue;
            synchronized (concurrentLinkedDeque) {
                this.updatesQueue.notifyAll();
            }
        }
    }

    private void onTLAbsUpdates(@NotNull TLAbsUpdates updates) {
        BotLogger.debug(LOGTAG, "Received:" + updates.toString());
        if (updates instanceof TLUpdateShortMessage) {
            TLUpdateShortMessage updateShortMessage = (TLUpdateShortMessage)updates;
            UpdateWrapper wrapper = new UpdateWrapper(updateShortMessage);
            wrapper.setParams(updateShortMessage.getPts(), updateShortMessage.getPtsCount(), updateShortMessage.getDate(), 0, 0);
            this.updateHandlerThread.addUpdate(wrapper);
        } else if (updates instanceof TLUpdateShortChatMessage) {
            TLUpdateShortChatMessage updateShortChatMessage = (TLUpdateShortChatMessage)updates;
            UpdateWrapper wrapper = new UpdateWrapper(updateShortChatMessage);
            wrapper.setParams(updateShortChatMessage.getPts(), updateShortChatMessage.getPtsCount(), updateShortChatMessage.getDate(), 0, 0);
            this.updateHandlerThread.addUpdate(wrapper);
        } else if (updates instanceof TLUpdateShort) {
            TLUpdateShort updateShort = (TLUpdateShort)updates;
            UpdateWrapper wrapper = new UpdateWrapper(updateShort.getUpdate());
            wrapper.setParams(updateShort.getUpdate().getPts(), updateShort.getUpdate().getPtsCount(), updateShort.getDate(), 0, 0);
            this.updateHandlerThread.addUpdate(wrapper);
        } else if (updates instanceof TLUpdates) {
            TLUpdates tlUpdates = (TLUpdates)updates;
            boolean disablePtsCheck = tlUpdates.getSeq() != 0;
            boolean correctSeq = true;
            if (disablePtsCheck) {
                correctSeq = this.updatesHandler.checkSeq(tlUpdates.getSeq(), 0, tlUpdates.getDate());
            }
            if (correctSeq) {
                this.updatesHandler.onChats(tlUpdates.getChats());
                this.updatesHandler.onUsers(tlUpdates.getUsers());
                tlUpdates.getUpdates().forEach(x -> {
                    UpdateWrapper wrapper = new UpdateWrapper((TLObject)x);
                    wrapper.setParams(x.getPts(), x.getPtsCount(), tlUpdates.getDate(), tlUpdates.getSeq(), 0);
                    if (disablePtsCheck) {
                        wrapper.disablePtsCheck();
                    }
                    this.updateHandlerThread.addUpdate(wrapper);
                });
            } else {
                this.updatesHandler.getDifferences();
            }
        } else if (updates instanceof TLUpdatesCombined) {
            TLUpdatesCombined updatesCombined = (TLUpdatesCombined)updates;
            boolean disablePtsCheck = updatesCombined.getSeq() != 0;
            boolean correctSeq = true;
            if (disablePtsCheck) {
                correctSeq = this.updatesHandler.checkSeq(updatesCombined.getSeq(), updatesCombined.getSeqStart(), updatesCombined.getDate());
            }
            if (correctSeq) {
                this.updatesHandler.onChats(updatesCombined.getChats());
                this.updatesHandler.onUsers(updatesCombined.getUsers());
                updatesCombined.getUpdates().forEach(x -> {
                    UpdateWrapper wrapper = new UpdateWrapper((TLObject)x);
                    wrapper.setParams(x.getPts(), x.getPtsCount(), updatesCombined.getDate(), updatesCombined.getSeq(), updatesCombined.getSeqStart());
                    if (disablePtsCheck) {
                        wrapper.disablePtsCheck();
                    }
                    this.updateHandlerThread.addUpdate(wrapper);
                });
            } else {
                this.updatesHandler.getDifferences();
            }
        } else if (updates instanceof TLUpdateShortSentMessage) {
            TLUpdateShortSentMessage updateShortSentMessage = (TLUpdateShortSentMessage)updates;
            UpdateWrapper wrapper = new UpdateWrapper(updateShortSentMessage);
            wrapper.setParams(updateShortSentMessage.getPts(), updateShortSentMessage.getPtsCount(), updateShortSentMessage.getDate(), 0, 0);
            this.updateHandlerThread.addUpdate(wrapper);
        } else if (updates instanceof TLUpdatesTooLong) {
            this.updatesHandler.onTLUpdatesTooLong();
        } else {
            BotLogger.debug(LOGTAG, "Unsupported TLAbsUpdates: " + updates.toString());
        }
    }

    public void processUpdates(@NotNull List<UpdateWrapper> updates) {
        this.updateHandlerThread.addUpdates(updates);
    }

    private void getUpdatesState() {
        try {
            TLUpdatesState state = this.kernelComm.doRpcCallSync(new TLRequestUpdatesGetState());
            if (state != null) {
                BotLogger.error(LOGTAG, "Received updates state");
                this.updatesHandler.updateStateModification(state);
                this.needGetUpdateState.set(false);
            } else {
                BotLogger.error(LOGTAG, "Error getting updates state");
            }
        }
        catch (ExecutionException | RpcException e) {
            BotLogger.error(LOGTAG, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void needGetUpdates() {
        this.needGetUpdateState.set(true);
        ConcurrentLinkedDeque<TLAbsUpdates> concurrentLinkedDeque = this.updatesQueue;
        synchronized (concurrentLinkedDeque) {
            this.updatesQueue.notifyAll();
        }
    }

    public IUpdatesHandler getUpdatesHandler() {
        return this.updatesHandler;
    }

    @Override
    public void onNotificationReceived(int notificationId, Object ... args) {
        if (notificationId == NotificationsService.needGetUpdates) {
            this.needGetUpdates();
        }
    }

    protected void finalize() throws Throwable {
        NotificationsService.getInstance().removeObserver(this, NotificationsService.needGetUpdates);
        super.finalize();
    }

    private class UpdateHandlerThread
    extends Thread {
        private boolean isAlive = true;
        private final PriorityQueue<UpdateWrapper> updates = new PriorityQueue<UpdateWrapper>(new UpdateWrapper.UpdateWrapperComparator());

        private UpdateHandlerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addUpdate(UpdateWrapper newUpdate) {
            PriorityQueue<UpdateWrapper> priorityQueue = this.updates;
            synchronized (priorityQueue) {
                this.updates.offer(newUpdate);
                this.updates.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void addUpdates(List<UpdateWrapper> newUpdates) {
            PriorityQueue<UpdateWrapper> priorityQueue = this.updates;
            synchronized (priorityQueue) {
                this.updates.addAll(newUpdates);
                this.updates.notifyAll();
            }
        }

        @Override
        public void interrupt() {
            this.isAlive = false;
            super.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.isAlive) {
                while (this.isAlive) {
                    try {
                        UpdateWrapper update;
                        PriorityQueue<UpdateWrapper> priorityQueue = this.updates;
                        synchronized (priorityQueue) {
                            update = this.updates.poll();
                        }
                        if (update == null) {
                            priorityQueue = this.updates;
                            synchronized (priorityQueue) {
                                try {
                                    this.updates.wait();
                                }
                                catch (InterruptedException e) {
                                    BotLogger.error(MainHandler.LOGTAG, e);
                                }
                                continue;
                            }
                        }
                        MainHandler.this.updatesHandler.processUpdate(update);
                    }
                    catch (Exception e) {
                        BotLogger.error(MainHandler.LOGTAG, e);
                    }
                }
            }
        }
    }

    private class UpdatesHandlerThread
    extends Thread {
        boolean isAlive = true;

        private UpdatesHandlerThread() {
        }

        @Override
        public void interrupt() {
            this.isAlive = false;
            super.interrupt();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (this.isAlive) {
                try {
                    TLAbsUpdates updates;
                    if (MainHandler.this.needGetUpdateState.get() && !MainHandler.this.gettingDifferences.get()) {
                        MainHandler.this.getUpdatesState();
                    }
                    if ((updates = (TLAbsUpdates)MainHandler.this.updatesQueue.pollFirst()) == null) {
                        ConcurrentLinkedDeque concurrentLinkedDeque = MainHandler.this.updatesQueue;
                        synchronized (concurrentLinkedDeque) {
                            try {
                                MainHandler.this.updatesQueue.wait();
                            }
                            catch (InterruptedException e) {
                                BotLogger.error(MainHandler.LOGTAG, e);
                            }
                            continue;
                        }
                    }
                    MainHandler.this.onTLAbsUpdates(updates);
                }
                catch (Exception e) {
                    BotLogger.error(MainHandler.LOGTAG, e);
                }
            }
        }
    }
}

