/*
 * Decompiled with CFR 0.152.
 */
package org.telegram.api.paymentapi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.telegram.api.paymentapi.TLPostAddress;
import org.telegram.tl.StreamingUtils;
import org.telegram.tl.TLContext;
import org.telegram.tl.TLObject;

public class TLPaymentRequestedInfo
extends TLObject {
    public static final int CLASS_ID = -1868808300;
    private static final int FLAG_NAME = 1;
    private static final int FLAG_PHONE = 2;
    private static final int FLAG_EMIAL = 4;
    private static final int FLAG_SHIPPING_ADDRESS = 8;
    private int flags;
    private String name;
    private String phone;
    private String email;
    private TLPostAddress shippingAddress;

    @Override
    public int getClassId() {
        return -1868808300;
    }

    public String getName() {
        return this.name;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getEmail() {
        return this.email;
    }

    public TLPostAddress getShippingAddress() {
        return this.shippingAddress;
    }

    public boolean hasName() {
        return (this.flags & 1) != 0;
    }

    public boolean hasPhone() {
        return (this.flags & 2) != 0;
    }

    public boolean hasEmail() {
        return (this.flags & 4) != 0;
    }

    public boolean hasShippingAddress() {
        return (this.flags & 8) != 0;
    }

    @Override
    public void serializeBody(OutputStream stream) throws IOException {
        StreamingUtils.writeInt(this.flags, stream);
        if (this.hasName()) {
            StreamingUtils.writeTLString(this.name, stream);
        }
        if (this.hasPhone()) {
            StreamingUtils.writeTLString(this.phone, stream);
        }
        if (this.hasEmail()) {
            StreamingUtils.writeTLString(this.email, stream);
        }
        if (this.hasShippingAddress()) {
            StreamingUtils.writeTLObject(this.shippingAddress, stream);
        }
    }

    @Override
    public void deserializeBody(InputStream stream, TLContext context) throws IOException {
        this.flags = StreamingUtils.readInt(stream);
        if (this.hasName()) {
            this.name = StreamingUtils.readTLString(stream);
        }
        if (this.hasPhone()) {
            this.phone = StreamingUtils.readTLString(stream);
        }
        if (this.hasEmail()) {
            this.email = StreamingUtils.readTLString(stream);
        }
        if (this.hasShippingAddress()) {
            this.shippingAddress = StreamingUtils.readTLObject(stream, context, TLPostAddress.class);
        }
    }

    @Override
    public String toString() {
        return "paymentRequestedInfo#909c3f94";
    }
}

