/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.geo;

import java.io.IOException;
import java.sql.Clob;
import java.sql.SQLException;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.types.AbstractGeospatialType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.GeometryType;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.function.GeometryUtils;
import org.teiid.query.function.TeiidFunction;
import org.wololo.geojson.Geometry;
import org.wololo.jts2geojson.GeoJSONReader;
import org.wololo.jts2geojson.GeoJSONWriter;

public class GeometryJsonUtils {
    @TeiidFunction(name="st_asgeojson", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static ClobType asGeoJson(GeometryType geometry) throws FunctionExecutionException {
        return GeometryJsonUtils.geometryToGeoJson(geometry);
    }

    @TeiidFunction(name="st_geomfromgeojson", category="Geometry", pushdown=FunctionMethod.PushDown.CAN_PUSHDOWN, nullOnNull=true)
    public static GeometryType geomFromGeoJson(ClobType clob, int srid) throws FunctionExecutionException {
        return GeometryJsonUtils.geometryFromGeoJson(clob, srid);
    }

    @TeiidFunction(name="st_geomfromgeojson", category="Geometry", nullOnNull=true)
    public static GeometryType geomFromGeoJson(ClobType clob) throws FunctionExecutionException {
        return GeometryJsonUtils.geometryFromGeoJson(clob, 0);
    }

    public static ClobType geometryToGeoJson(GeometryType geometry) throws FunctionExecutionException {
        org.locationtech.jts.geom.Geometry jtsGeometry = GeometryUtils.getGeometry((AbstractGeospatialType)geometry);
        GeoJSONWriter writer = new GeoJSONWriter();
        try {
            Geometry geoJson = writer.write(jtsGeometry);
            ClobType result = new ClobType((Clob)new ClobImpl(geoJson.toString()));
            result.setType(ClobType.Type.JSON);
            return result;
        }
        catch (Exception e) {
            throw new FunctionExecutionException((Throwable)e);
        }
    }

    public static GeometryType geometryFromGeoJson(ClobType json, int srid) throws FunctionExecutionException {
        try {
            GeoJSONReader reader = new GeoJSONReader();
            String jsonText = ClobType.getString((Clob)json);
            org.locationtech.jts.geom.Geometry jtsGeometry = reader.read(jsonText);
            return GeometryUtils.getGeometryType((org.locationtech.jts.geom.Geometry)jtsGeometry, (int)srid);
        }
        catch (SQLException e) {
            throw new FunctionExecutionException((Throwable)e);
        }
        catch (IOException e) {
            throw new FunctionExecutionException((Throwable)e);
        }
    }
}

