/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.visitor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.metadata.QueryMetadataInterface;
import org.teiid.query.resolver.util.ResolverUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.navigator.PreOrPostOrderNavigator;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.GroupSymbol;
import org.teiid.query.sql.symbol.Reference;

public class CorrelatedReferenceCollectorVisitor
extends LanguageVisitor {
    private List<Reference> references;
    private ArrayList<Map<GroupSymbol, GroupSymbol>> outerGroups = new ArrayList(2);
    private QueryMetadataInterface metadata;
    private boolean queryRoot;

    CorrelatedReferenceCollectorVisitor(Collection<GroupSymbol> groupSymbols, List<Reference> correlatedReferences) {
        HashMap<GroupSymbol, GroupSymbol> groupMap = new HashMap<GroupSymbol, GroupSymbol>();
        for (GroupSymbol g : groupSymbols) {
            groupMap.put(g, g);
        }
        this.outerGroups.add(groupMap);
        this.references = correlatedReferences;
    }

    public List<Reference> getReferences() {
        return this.references;
    }

    @Override
    public void visit(Reference obj) {
        ElementSymbol e = obj.getExpression();
        if (e == null || !e.isExternalReference()) {
            return;
        }
        GroupSymbol g = e.getGroupSymbol();
        for (int i = this.outerGroups.size() - (this.queryRoot ? 2 : 1); i >= 0; --i) {
            GroupSymbol outer = this.outerGroups.get(i).get(g);
            if (outer == null) continue;
            try {
                if (!ResolverUtil.resolveElementsInGroup(outer, this.metadata).contains(e)) continue;
                if (i == 0) {
                    this.references.add(obj);
                }
                return;
            }
            catch (TeiidComponentException e1) {
                throw new TeiidRuntimeException((Throwable)e1);
            }
        }
    }

    public static final void collectReferences(LanguageObject obj, Collection<GroupSymbol> groupSymbols, List<Reference> correlatedReferences, QueryMetadataInterface metadata) {
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>(groupSymbols);
        final CorrelatedReferenceCollectorVisitor visitor = new CorrelatedReferenceCollectorVisitor(groups, correlatedReferences);
        visitor.metadata = metadata;
        visitor.queryRoot = obj instanceof Command;
        obj.acceptVisitor(new PreOrPostOrderNavigator(visitor, true, true){

            @Override
            public void visit(Query query) {
                List<GroupSymbol> fromGroups = null;
                if (query.getFrom() != null) {
                    fromGroups = query.getFrom().getGroups();
                    HashMap<GroupSymbol, GroupSymbol> groupMap = new HashMap<GroupSymbol, GroupSymbol>();
                    for (GroupSymbol g : fromGroups) {
                        groupMap.put(g, g);
                    }
                    visitor.outerGroups.add(groupMap);
                } else {
                    visitor.outerGroups.add(Collections.emptyMap());
                }
                super.visit(query);
                visitor.outerGroups.remove(visitor.outerGroups.size() - 1);
            }
        });
    }
}

