/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.symbol;

import java.math.BigDecimal;
import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.ClobType;
import org.teiid.core.types.DataTypeManager;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.FunctionMethods;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class Constant
implements Expression,
Comparable<Constant> {
    public static final Constant NULL_CONSTANT = new Constant(null);
    private Object value;
    private Class<?> type;
    private boolean multiValued;
    private boolean bindEligible;
    public static final Comparator<Object> COMPARATOR = Constant.getComparator(DataTypeManager.COLLATION_LOCALE, DataTypeManager.PAD_SPACE);

    static Comparator<Object> getComparator(String localeString, final boolean padSpace) {
        if (localeString == null) {
            return Constant.getComparator(padSpace);
        }
        String[] parts = localeString.split("_");
        Locale locale = null;
        if (parts.length == 1) {
            locale = new Locale(parts[0]);
        } else if (parts.length == 2) {
            locale = new Locale(parts[0], parts[1]);
        } else if (parts.length == 3) {
            locale = new Locale(parts[0], parts[1], parts[2]);
        } else {
            LogManager.logError((String)"org.teiid.PROCESSOR", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30564, new Object[]{localeString}));
            return Constant.getComparator(padSpace);
        }
        final Collator c = Collator.getInstance(locale);
        LogManager.logError((String)"org.teiid.PROCESSOR", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30565, new Object[]{locale}));
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Class<?> clazz = o1.getClass();
                if (clazz == String.class) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    if (padSpace) {
                        s1 = FunctionMethods.rightTrim(s1, ' ', false);
                        s2 = FunctionMethods.rightTrim(s2, ' ', false);
                    }
                    return c.compare(s1, s2);
                }
                return ((Comparable)o1).compareTo(o2);
            }
        };
    }

    static Comparator<Object> getComparator(boolean padSpace) {
        if (!padSpace) {
            return new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return ((Comparable)o1).compareTo(o2);
                }
            };
        }
        return new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                Class<?> clazz = o1.getClass();
                if (clazz == String.class) {
                    CharSequence s1 = (CharSequence)o1;
                    CharSequence s2 = (CharSequence)o2;
                    return Constant.comparePadded(s1, s2);
                }
                if (clazz == ClobType.class) {
                    CharSequence s1 = ((ClobType)o1).getCharSequence();
                    CharSequence s2 = ((ClobType)o2).getCharSequence();
                    return Constant.comparePadded(s1, s2);
                }
                return ((Comparable)o1).compareTo(o2);
            }
        };
    }

    public Constant(Object value, Class<?> type) {
        this.value = value;
        if (type == null) {
            throw new IllegalArgumentException(QueryPlugin.Util.getString("ERR.015.010.0014"));
        }
        this.type = type;
    }

    public Constant(Object value) {
        this.value = value;
        this.type = this.value == null ? DataTypeManager.DefaultDataClasses.NULL : DataTypeManager.getRuntimeType(value.getClass());
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isNull() {
        return this.value == null;
    }

    public void setMultiValued(List<?> value) {
        this.multiValued = true;
        this.value = value;
    }

    public boolean isMultiValued() {
        return this.multiValued;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Constant)) {
            return false;
        }
        Constant other = (Constant)obj;
        if (other.isNull()) {
            return this.isNull();
        }
        if (this.isNull()) {
            return false;
        }
        if (this.value instanceof BigDecimal) {
            if (this.value == other.value) {
                return true;
            }
            if (!(other.value instanceof BigDecimal)) {
                return false;
            }
            return ((BigDecimal)this.value).compareTo((BigDecimal)other.value) == 0;
        }
        return this.multiValued == other.multiValued && other.getValue().equals(this.getValue());
    }

    public int hashCode() {
        if (this.value != null && !this.isMultiValued()) {
            if (this.value instanceof BigDecimal) {
                BigDecimal bd = (BigDecimal)this.value;
                int xsign = bd.signum();
                if (xsign == 0) {
                    return 0;
                }
                bd = bd.stripTrailingZeros();
                return bd.hashCode();
            }
            return this.value.hashCode();
        }
        return 0;
    }

    @Override
    public Object clone() {
        Constant copy = new Constant(this.getValue(), this.getType());
        copy.multiValued = this.multiValued;
        copy.bindEligible = this.bindEligible;
        return copy;
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    @Override
    public int compareTo(Constant o) {
        if (this.isNull()) {
            if (o.isNull()) {
                return 0;
            }
            return -1;
        }
        if (o.isNull()) {
            return 1;
        }
        return COMPARATOR.compare(this.value, o.getValue());
    }

    static final int comparePadded(CharSequence s1, CharSequence s2) {
        int j;
        int len1 = s1.length();
        int len2 = s2.length();
        int n = Math.min(len1, len2);
        int result = 0;
        for (int i = 0; i < n; ++i) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 == (c2 = s2.charAt(i))) continue;
            return c1 - c2;
        }
        result = len1 - len2;
        for (j = i; j < len1; ++j) {
            if (s1.charAt(j) == ' ') continue;
            return result;
        }
        for (j = i; j < len2; ++j) {
            if (s2.charAt(j) == ' ') continue;
            return result;
        }
        return 0;
    }

    public boolean isBindEligible() {
        return this.bindEligible;
    }

    public void setBindEligible(boolean bindEligible) {
        this.bindEligible = bindEligible;
    }
}

