/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.proc;

import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;
import org.teiid.query.sql.proc.ExpressionStatement;
import org.teiid.query.sql.proc.Statement;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.symbol.ScalarSubquery;

public class AssignmentStatement
extends Statement
implements ExpressionStatement {
    private ElementSymbol variable;
    private Expression value;
    private Command command;

    public AssignmentStatement() {
    }

    public AssignmentStatement(ElementSymbol variable, QueryCommand value) {
        this.variable = variable;
        this.value = new ScalarSubquery(value);
    }

    @Deprecated
    public AssignmentStatement(ElementSymbol variable, Command value) {
        this.variable = variable;
        if (value instanceof QueryCommand) {
            this.value = new ScalarSubquery((QueryCommand)value);
        } else {
            this.command = value;
        }
    }

    public AssignmentStatement(ElementSymbol variable, Expression value) {
        this.variable = variable;
        this.value = value;
    }

    @Deprecated
    public Command getCommand() {
        Query query;
        if (this.command != null) {
            return this.command;
        }
        if (this.value instanceof ScalarSubquery && ((ScalarSubquery)this.value).getCommand() instanceof Query && (query = (Query)((ScalarSubquery)this.value).getCommand()).getInto() != null) {
            return query;
        }
        return null;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    @Override
    public Expression getExpression() {
        return this.value;
    }

    @Override
    public void setExpression(Expression expression) {
        this.value = expression;
    }

    public ElementSymbol getVariable() {
        return this.variable;
    }

    public void setVariable(ElementSymbol variable) {
        this.variable = variable;
    }

    @Override
    public int getType() {
        return 5;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public Object clone() {
        AssignmentStatement clone = new AssignmentStatement(this.variable.clone(), (Expression)this.value.clone());
        return clone;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AssignmentStatement)) {
            return false;
        }
        AssignmentStatement other = (AssignmentStatement)obj;
        return EquivalenceUtil.areEqual((Object)this.getVariable(), (Object)other.getVariable()) && EquivalenceUtil.areEqual((Object)this.getExpression(), (Object)other.getExpression());
    }

    public int hashCode() {
        int myHash = 0;
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.getVariable()});
        myHash = HashCodeUtil.hashCode((int)myHash, (Object[])new Object[]{this.getExpression()});
        return myHash;
    }

    @Override
    public Class<?> getExpectedType() {
        if (this.variable == null) {
            return null;
        }
        return this.variable.getType();
    }
}

