/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.metadata;

import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.query.metadata.VirtualFile;

public class NioVirtualFile
implements VirtualFile {
    private Path path;
    private long size = -1L;

    public NioVirtualFile(Path path) {
        this.path = path;
    }

    @Override
    public InputStream openStream() throws IOException {
        FileChannel channel = FileChannel.open(this.path, new OpenOption[0]);
        return Channels.newInputStream(channel);
    }

    @Override
    public long getSize() {
        if (this.size == -1L) {
            try (FileChannel channel = FileChannel.open(this.path, new OpenOption[0]);){
                this.size = channel.size();
            }
            catch (IOException e) {
                this.size = 0L;
            }
        }
        return this.size;
    }

    @Override
    public String getName() {
        return this.path.getFileName().toString();
    }

    @Override
    public List<VirtualFile> getFileChildrenRecursively() throws IOException {
        if (!Files.isDirectory(this.path, new LinkOption[0])) {
            return Collections.emptyList();
        }
        final ArrayList<VirtualFile> children = new ArrayList<VirtualFile>();
        Files.walkFileTree(this.path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                children.add(new NioVirtualFile(file));
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                return FileVisitResult.CONTINUE;
            }
        });
        return children;
    }

    @Override
    public boolean isFile() {
        return Files.isRegularFile(this.path, new LinkOption[0]);
    }

    @Override
    public String getPathName() {
        return this.path.toString();
    }

    @Override
    public VirtualFile getChild(String child) {
        return new NioVirtualFile(this.path.resolve("/" + child));
    }

    @Override
    public boolean exists() {
        return Files.exists(this.path, new LinkOption[0]);
    }

    public String toString() {
        return this.getPathName();
    }
}

