/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.function;

import java.util.Map;
import org.teiid.adminapi.impl.SessionMetadata;
import org.teiid.api.exception.query.FunctionExecutionException;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.DataTypeManager;
import org.teiid.core.types.TransformationException;
import org.teiid.metadata.FunctionMethod;
import org.teiid.query.QueryPlugin;
import org.teiid.query.function.TeiidFunction;
import org.teiid.query.util.CommandContext;
import org.teiid.query.util.GeneratedKeysImpl;

public class SystemFunctionMethods {
    private static final int MAX_VARIABLES = 512;

    @TeiidFunction(category="System", nullOnNull=true, determinism=FunctionMethod.Determinism.COMMAND_DETERMINISTIC, pushdown=FunctionMethod.PushDown.CANNOT_PUSHDOWN)
    public static Object teiid_session_get(CommandContext context, String key) {
        return context.getSessionVariable(key);
    }

    @TeiidFunction(category="System", determinism=FunctionMethod.Determinism.COMMAND_DETERMINISTIC, pushdown=FunctionMethod.PushDown.CANNOT_PUSHDOWN)
    public static Object teiid_session_set(CommandContext context, String key, Object value) throws FunctionExecutionException {
        SessionMetadata session = context.getSession();
        Map variables = session.getSessionVariables();
        if (variables.size() > 512 && !variables.containsKey(key)) {
            throw new FunctionExecutionException((BundleUtil.Event)QueryPlugin.Event.TEIID31136, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID31136, new Object[]{512}));
        }
        return context.setSessionVariable(key, value);
    }

    @TeiidFunction(category="System", pushdown=FunctionMethod.PushDown.CANNOT_PUSHDOWN, nullOnNull=true, determinism=FunctionMethod.Determinism.COMMAND_DETERMINISTIC)
    public static Object generated_key(CommandContext context, String column) {
        GeneratedKeysImpl keys = SystemFunctionMethods.getLastGeneratedKeys(context);
        if (keys == null || keys.getKeys().isEmpty()) {
            return null;
        }
        for (int i = 0; i < keys.getColumnNames().length; ++i) {
            String col = keys.getColumnNames()[i];
            if (!col.equalsIgnoreCase(column)) continue;
            return keys.getKeys().get(0).get(i);
        }
        return null;
    }

    private static GeneratedKeysImpl getLastGeneratedKeys(CommandContext context) {
        Object o = context.getSessionVariable("last_generated_key");
        if (o instanceof GeneratedKeysImpl) {
            return (GeneratedKeysImpl)o;
        }
        return null;
    }

    @TeiidFunction(category="System", pushdown=FunctionMethod.PushDown.CANNOT_PUSHDOWN, nullOnNull=true, determinism=FunctionMethod.Determinism.COMMAND_DETERMINISTIC)
    public static Long generated_key(CommandContext context) throws TransformationException {
        GeneratedKeysImpl keys = SystemFunctionMethods.getLastGeneratedKeys(context);
        if (keys == null || keys.getKeys().isEmpty()) {
            return null;
        }
        Object value = keys.getKeys().get(0).get(0);
        if (value != null) {
            return (Long)DataTypeManager.transformValue(value, (Class)DataTypeManager.DefaultDataClasses.LONG);
        }
        return null;
    }
}

