/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.teiid.adminapi.impl.WorkerPoolStatisticsMetadata;
import org.teiid.core.BundleUtil;
import org.teiid.core.util.NamedThreadFactory;
import org.teiid.dqp.internal.process.DQPWorkContext;
import org.teiid.dqp.internal.process.TeiidExecutor;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;

public class ThreadReuseExecutor
implements TeiidExecutor {
    private static AtomicLong ID_GEN = new AtomicLong();
    private final ThreadPoolExecutor tpe;
    private volatile int activeCount;
    private volatile int highestActiveCount;
    private volatile int highestQueueSize;
    private volatile boolean terminated;
    private volatile int submittedCount;
    private volatile int completedCount;
    private Object poolLock = new Object();
    private AtomicInteger threadCounter = new AtomicInteger();
    private Set<Thread> threads = Collections.newSetFromMap(new ConcurrentHashMap());
    private String poolName;
    private int maximumPoolSize;
    private Queue<RunnableWrapper> queue = new PriorityBlockingQueue<RunnableWrapper>(11);
    private long warnWaitTime = 500L;

    public ThreadReuseExecutor(String name, int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
        this.poolName = name;
        this.tpe = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 2L, TimeUnit.MINUTES, new SynchronousQueue(), (ThreadFactory)new NamedThreadFactory("Worker")){

            @Override
            protected void afterExecute(Runnable r, Throwable t) {
                if (t != null) {
                    LogManager.logError((String)"org.teiid.RUNTIME", (Throwable)t, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30021, new Object[0]));
                }
            }
        };
    }

    @Override
    public void execute(Runnable command) {
        this.executeDirect(new RunnableWrapper(command));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeDirect(final RunnableWrapper command) {
        this.checkForTermination();
        Object object = this.poolLock;
        synchronized (object) {
            boolean atMaxThreads;
            ++this.submittedCount;
            boolean bl = atMaxThreads = this.activeCount == this.maximumPoolSize;
            if (atMaxThreads) {
                this.queue.add(command);
                int queueSize = this.queue.size();
                if (queueSize > this.highestQueueSize) {
                    this.highestQueueSize = queueSize;
                }
                return;
            }
            ++this.activeCount;
            this.highestActiveCount = Math.max(this.activeCount, this.highestActiveCount);
        }
        this.tpe.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Thread t = Thread.currentThread();
                ThreadReuseExecutor.this.threads.add(t);
                String name = t.getName();
                t.setName(name + "_" + ThreadReuseExecutor.this.poolName + ThreadReuseExecutor.this.threadCounter.getAndIncrement());
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.RUNTIME", (int)6)) {
                    LogManager.logTrace((String)"org.teiid.RUNTIME", (Object)"Beginning work with virtual worker", (Object)t.getName());
                }
                PrioritizedRunnable r = command;
                while (r != null) {
                    boolean success = false;
                    try {
                        r.run();
                        success = true;
                    }
                    finally {
                        Object object = ThreadReuseExecutor.this.poolLock;
                        synchronized (object) {
                            if (success) {
                                ThreadReuseExecutor.this.completedCount++;
                                r = (PrioritizedRunnable)ThreadReuseExecutor.this.queue.poll();
                            }
                            if (!success || r == null) {
                                ThreadReuseExecutor.this.threads.remove(t);
                                ThreadReuseExecutor.this.activeCount--;
                                if (ThreadReuseExecutor.this.activeCount == 0 && ThreadReuseExecutor.this.terminated) {
                                    ThreadReuseExecutor.this.poolLock.notifyAll();
                                }
                            }
                        }
                        if (success) {
                            long warnTime = ThreadReuseExecutor.this.warnWaitTime;
                            if (r != null && System.currentTimeMillis() - r.getCreationTime() > warnTime) {
                                ThreadReuseExecutor.this.logWaitMessage(warnTime, ThreadReuseExecutor.this.maximumPoolSize, ThreadReuseExecutor.this.poolName, ThreadReuseExecutor.this.highestQueueSize);
                                ThreadReuseExecutor.this.warnWaitTime *= 2L;
                            }
                        }
                        t.setName(name);
                    }
                }
            }
        });
    }

    protected void logWaitMessage(long warnTime, int maximumPoolSize, String poolName, int highestQueueSize) {
        LogManager.logWarning((String)"org.teiid.RUNTIME", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30009, new Object[]{maximumPoolSize, poolName, highestQueueSize, warnTime}));
    }

    private void checkForTermination() {
        if (this.terminated) {
            throw new RejectedExecutionException();
        }
    }

    @Override
    public int getActiveCount() {
        return this.activeCount;
    }

    public long getSubmittedCount() {
        return this.submittedCount;
    }

    public long getCompletedCount() {
        return this.completedCount;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public void shutdown() {
        this.terminated = true;
    }

    public int getLargestPoolSize() {
        return this.highestActiveCount;
    }

    @Override
    public int getQueued() {
        return this.queue.size();
    }

    @Override
    public WorkerPoolStatisticsMetadata getStats() {
        WorkerPoolStatisticsMetadata stats = new WorkerPoolStatisticsMetadata();
        stats.setName(this.poolName);
        stats.setQueued(this.queue.size());
        stats.setHighestQueued(this.highestQueueSize);
        stats.setActiveThreads(this.getActiveCount());
        stats.setMaxThreads(this.maximumPoolSize);
        stats.setTotalSubmitted(this.getSubmittedCount());
        stats.setHighestActiveThreads(this.getLargestPoolSize());
        stats.setTotalCompleted(this.getCompletedCount());
        return stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        Object object = this.poolLock;
        synchronized (object) {
            for (Thread t : this.threads) {
                t.interrupt();
            }
            ArrayList<Runnable> result = new ArrayList<Runnable>(this.queue);
            this.queue.clear();
            result.addAll(this.tpe.shutdownNow());
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long timeoutMillis = unit.toMillis(timeout);
        long finalMillis = System.currentTimeMillis() + timeoutMillis;
        Object object = this.poolLock;
        synchronized (object) {
            while (this.activeCount > 0 || !this.terminated) {
                if (timeoutMillis < 1L) {
                    return false;
                }
                this.poolLock.wait(timeoutMillis);
                timeoutMillis = finalMillis - System.currentTimeMillis();
            }
        }
        return true;
    }

    static /* synthetic */ AtomicLong access$000() {
        return ID_GEN;
    }

    public static class RunnableWrapper
    implements PrioritizedRunnable,
    Comparable<RunnableWrapper> {
        Runnable r;
        DQPWorkContext workContext = DQPWorkContext.getWorkContext();
        long creationTime;
        int priority;
        long id = ThreadReuseExecutor.access$000().getAndIncrement();

        public RunnableWrapper(Runnable r) {
            if (r instanceof PrioritizedRunnable) {
                PrioritizedRunnable pr = (PrioritizedRunnable)r;
                this.creationTime = pr.getCreationTime();
                this.priority = pr.getPriority();
                this.workContext = pr.getDqpWorkContext();
            } else {
                this.creationTime = System.currentTimeMillis();
                this.priority = Integer.MAX_VALUE;
            }
            this.r = r;
        }

        @Override
        public long getCreationTime() {
            return this.creationTime;
        }

        @Override
        public int getPriority() {
            return this.priority;
        }

        @Override
        public void run() {
            if (this.workContext.getSecurityHelper() != null) {
                this.workContext.getSecurityHelper().clearSecurityContext();
            }
            this.workContext.runInContext(this.r);
        }

        @Override
        public DQPWorkContext getDqpWorkContext() {
            return this.workContext;
        }

        @Override
        public int compareTo(RunnableWrapper o) {
            int comp = Integer.compare(this.priority, o.priority);
            if (comp != 0) {
                return comp;
            }
            return Long.compare(this.id, o.id);
        }
    }

    public static interface PrioritizedRunnable
    extends Runnable {
        public static final int NO_WAIT_PRIORITY = 0;

        public int getPriority();

        public long getCreationTime();

        public DQPWorkContext getDqpWorkContext();
    }
}

