/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.dqp.internal.process;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.teiid.CommandContext;
import org.teiid.PolicyDecider;
import org.teiid.adminapi.DataPolicy;
import org.teiid.adminapi.impl.DataPolicyMetadata;
import org.teiid.core.util.Assertion;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.metadata.AbstractMetadataRecord;
import org.teiid.metadata.Column;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.Procedure;
import org.teiid.metadata.Schema;
import org.teiid.metadata.Table;

public class DataRolePolicyDecider
implements PolicyDecider {
    private boolean allowCreateTemporaryTablesByDefault = (Boolean)PropertiesUtils.getHierarchicalProperty((String)"org.teiid.allowCreateTemporaryTablesByDefault", (Object)false, Boolean.class);
    private boolean allowFunctionCallsByDefault = (Boolean)PropertiesUtils.getHierarchicalProperty((String)"org.teiid.allowFunctionCallsByDefault", (Object)false, Boolean.class);

    public Set<AbstractMetadataRecord> getInaccessibleResources(DataPolicy.PermissionType action, Set<AbstractMetadataRecord> resources, DataPolicy.Context context, CommandContext commandContext) {
        if ((action == DataPolicy.PermissionType.EXECUTE || action == null) && context == DataPolicy.Context.FUNCTION && this.allowFunctionCallsByDefault) {
            return Collections.emptySet();
        }
        Collection policies = commandContext.getAllowedDataPolicies().values();
        int policyCount = policies.size();
        boolean[] exclude = new boolean[policyCount];
        Boolean[] results = null;
        List<DataPolicy.PermissionType> metadataPermissions = null;
        if (context == DataPolicy.Context.METADATA) {
            Assertion.assertTrue((resources.size() == 1 ? 1 : 0) != 0);
            if (action == DataPolicy.PermissionType.READ) {
                results = new Boolean[5];
                metadataPermissions = Arrays.asList(DataPolicy.PermissionType.ALTER, DataPolicy.PermissionType.CREATE, DataPolicy.PermissionType.UPDATE, DataPolicy.PermissionType.READ, DataPolicy.PermissionType.DELETE);
            } else {
                results = new Boolean[2];
                metadataPermissions = Arrays.asList(DataPolicy.PermissionType.ALTER, action);
            }
        }
        Iterator<AbstractMetadataRecord> iter = resources.iterator();
        block0: while (iter.hasNext()) {
            Arrays.fill(exclude, false);
            for (AbstractMetadataRecord resource = iter.next(); resource != null; resource = resource.getParent()) {
                Iterator policyIter = policies.iterator();
                for (int j = 0; j < policyCount; ++j) {
                    Boolean allows;
                    DataPolicyMetadata policy = (DataPolicyMetadata)policyIter.next();
                    if (exclude[j]) continue;
                    if (policy.isGrantAll()) {
                        if (policy.getSchemas() == null) {
                            resources.clear();
                            return resources;
                        }
                        if (!(resource instanceof Schema) || !policy.getSchemas().contains(resource.getName())) continue;
                        iter.remove();
                        continue block0;
                    }
                    if (context == DataPolicy.Context.METADATA) {
                        for (int i = 0; i < results.length; ++i) {
                            Boolean allows2 = policy.allows(resource.getFullName(), this.getResourceType(resource), metadataPermissions.get(i));
                            if (allows2 != null && allows2.booleanValue() && results[i] == null) {
                                resources.clear();
                                return resources;
                            }
                            if (results[i] != null) continue;
                            results[i] = allows2;
                        }
                    }
                    if ((allows = policy.allows(resource.getFullName(), this.getResourceType(resource), action)) == null) continue;
                    if (allows.booleanValue()) {
                        iter.remove();
                        continue block0;
                    }
                    exclude[j] = true;
                }
            }
        }
        return resources;
    }

    public boolean isLanguageAllowed(String language, CommandContext commandContext) {
        Collection policies = commandContext.getAllowedDataPolicies().values();
        for (DataPolicy policy : policies) {
            if (policy.isGrantAll()) {
                return true;
            }
            Boolean allows = ((DataPolicyMetadata)policy).allows(language, DataPolicy.ResourceType.LANGUAGE, DataPolicy.PermissionType.LANGUAGE);
            if (allows == null || !allows.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean hasRole(String roleName, CommandContext context) {
        return context.getAllowedDataPolicies().containsKey(roleName);
    }

    public boolean isTempAccessible(DataPolicy.PermissionType action, AbstractMetadataRecord resource, DataPolicy.Context context, CommandContext commandContext) {
        if (resource != null) {
            return this.getInaccessibleResources(action, new HashSet<AbstractMetadataRecord>(Arrays.asList(resource)), context, commandContext).isEmpty();
        }
        Boolean result = null;
        for (DataPolicy p : commandContext.getAllowedDataPolicies().values()) {
            DataPolicyMetadata policy = (DataPolicyMetadata)p;
            if (policy.isGrantAll()) {
                return true;
            }
            if (policy.isAllowCreateTemporaryTables() == null) continue;
            if (policy.isAllowCreateTemporaryTables().booleanValue()) {
                return true;
            }
            result = policy.isAllowCreateTemporaryTables();
        }
        if (result != null) {
            return result;
        }
        return this.allowCreateTemporaryTablesByDefault;
    }

    public void setAllowCreateTemporaryTablesByDefault(boolean allowCreateTemporaryTablesByDefault) {
        this.allowCreateTemporaryTablesByDefault = allowCreateTemporaryTablesByDefault;
    }

    public void setAllowFunctionCallsByDefault(boolean allowFunctionCallsDefault) {
        this.allowFunctionCallsByDefault = allowFunctionCallsDefault;
    }

    public boolean validateCommand(CommandContext commandContext) {
        return !commandContext.getVdb().getDataPolicies().isEmpty();
    }

    public DataPolicy.ResourceType getResourceType(AbstractMetadataRecord record) {
        if (record instanceof Table) {
            return DataPolicy.ResourceType.TABLE;
        }
        if (record instanceof Procedure) {
            Procedure p = (Procedure)record;
            if (p.isFunction()) {
                return DataPolicy.ResourceType.FUNCTION;
            }
            return DataPolicy.ResourceType.PROCEDURE;
        }
        if (record instanceof Column) {
            return DataPolicy.ResourceType.COLUMN;
        }
        if (record instanceof FunctionMethod) {
            return DataPolicy.ResourceType.FUNCTION;
        }
        if (record instanceof Schema) {
            return DataPolicy.ResourceType.SCHEMA;
        }
        return DataPolicy.ResourceType.DATABASE;
    }
}

