/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.teiid.common.buffer.AutoCleanupUtil;
import org.teiid.common.buffer.Cache;
import org.teiid.common.buffer.CacheEntry;
import org.teiid.common.buffer.CacheKey;
import org.teiid.common.buffer.ExtensibleBufferedInputStream;
import org.teiid.common.buffer.FileStore;
import org.teiid.common.buffer.Serializer;
import org.teiid.common.buffer.StorageManager;
import org.teiid.common.buffer.impl.BlockByteBuffer;
import org.teiid.common.buffer.impl.BlockInputStream;
import org.teiid.common.buffer.impl.BlockManager;
import org.teiid.common.buffer.impl.BlockOutputStream;
import org.teiid.common.buffer.impl.BlockStore;
import org.teiid.common.buffer.impl.BufferManagerImpl;
import org.teiid.common.buffer.impl.ConcurrentBitSet;
import org.teiid.common.buffer.impl.LrfuEvictionQueue;
import org.teiid.common.buffer.impl.OutOfDiskException;
import org.teiid.common.buffer.impl.PhysicalInfo;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.core.util.ExecutorUtils;
import org.teiid.core.util.PropertiesUtils;
import org.teiid.logging.LogManager;
import org.teiid.query.QueryPlugin;

public class BufferFrontedFileStoreCache
implements Cache<PhysicalInfo> {
    private static final int FULL_DEFRAG_TRUNCATE_TIMEOUT = 10000;
    private static final long TIMEOUT_NANOS = TimeUnit.SECONDS.toNanos(120L);
    private static final int DEFAULT_MIN_DEFRAG = 0x4000000;
    private static final int HEADER_BYTES = 16;
    private static final int EVICTION_SCANS = 2;
    public static final int DEFAULT_MAX_OBJECT_SIZE = 0x800000;
    static final int ADDRESS_BITS = 31;
    static final int SYSTEM_MASK = Integer.MIN_VALUE;
    static final int BYTES_PER_BLOCK_ADDRESS = 4;
    static final int INODE_BYTES = 64;
    static final int LOG_INODE_SIZE = 6;
    static final int DIRECT_POINTERS = 14;
    static final int EMPTY_ADDRESS = -1;
    static final int FREED = -2;
    static final int LOG_BLOCK_SIZE = 13;
    public static final long MAX_ADDRESSABLE_MEMORY = 0x100000000000L;
    static final int BLOCK_SIZE = 8192;
    static final int BLOCK_MASK = 8191;
    static final int ADDRESSES_PER_BLOCK = 2048;
    static final int MAX_INDIRECT = 2062;
    static final int MAX_DOUBLE_INDIRECT = 4196366;
    private StorageManager storageManager;
    private int maxStorageObjectSize = 0x800000;
    private long memoryBufferSpace = 0x4000000L;
    private boolean direct;
    private int maxMemoryBlocks;
    private AtomicLong readAttempts = new AtomicLong();
    LrfuEvictionQueue<PhysicalInfo> memoryBufferEntries = new LrfuEvictionQueue(this.readAttempts);
    private Semaphore memoryWritePermits;
    private ReentrantReadWriteLock memoryEvictionLock = new ReentrantReadWriteLock(true);
    private ReentrantLock freedLock = new ReentrantLock();
    private Condition blocksFreed = this.freedLock.newCondition();
    private int blocks;
    private ConcurrentBitSet blocksInuse;
    private BlockByteBuffer blockByteBuffer;
    private ConcurrentBitSet inodesInuse;
    private BlockByteBuffer inodeByteBuffer;
    private ConcurrentHashMap<Long, Map<Long, PhysicalInfo>> physicalMapping = new ConcurrentHashMap(16, 0.75f, 32);
    private BlockStore[] sizeBasedStores;
    private ExecutorService asynchPool = ExecutorUtils.newFixedThreadPool((int)2, (String)"FileStore Worker");
    private AtomicBoolean defragRunning = new AtomicBoolean();
    private AtomicInteger freedCounter = new AtomicInteger();
    private boolean compactBufferFiles = (Boolean)PropertiesUtils.getHierarchicalProperty((String)"org.teiid.compactBufferFiles", (Object)false, Boolean.class);
    private int truncateInterval = 4;
    final DefragTask defragTask = new DefragTask();
    private long lastFullRun;
    AtomicBoolean cleanerRunning = new AtomicBoolean();
    private final Runnable cleaningTask = new Runnable(){

        @Override
        public void run() {
            try {
                while (BufferFrontedFileStoreCache.this.lowBlocks(false) && BufferFrontedFileStoreCache.this.evictFromMemoryBuffer(false) != -1) {
                }
            }
            finally {
                BufferFrontedFileStoreCache.this.cleanerRunning.set(false);
            }
        }
    };
    private int cleaningThreshold;
    private int criticalCleaningThreshold;
    private AtomicLong storageWrites = new AtomicLong();
    private AtomicLong storageReads = new AtomicLong();
    private long minDefrag = 0x4000000L;
    private BufferManagerImpl bufferManager;

    @Override
    public void initialize() throws TeiidComponentException {
        this.storageManager.initialize();
        this.memoryBufferSpace = Math.max(this.memoryBufferSpace, (long)this.maxStorageObjectSize);
        this.blocks = (int)Math.min(Integer.MAX_VALUE, (this.memoryBufferSpace >> 13) * 2048L / 2049L);
        LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object)this.blocks, (Object)"max blocks");
        this.inodesInuse = new ConcurrentBitSet(this.blocks + 1, 32);
        this.blocksInuse = new ConcurrentBitSet(this.blocks, 32);
        int allocationBits = 30;
        if (!this.direct) {
            allocationBits = Math.min(30, Math.max(25, 61 - Long.numberOfLeadingZeros(this.memoryBufferSpace)));
        }
        this.blockByteBuffer = new BlockByteBuffer(allocationBits, this.blocks, 13, this.direct);
        this.inodeByteBuffer = new BlockByteBuffer(allocationBits, this.blocks + 1, 6, this.direct);
        this.memoryWritePermits = new Semaphore(this.blocks);
        this.maxMemoryBlocks = Math.min(4196366, this.blocks);
        this.maxMemoryBlocks = Math.min(this.maxMemoryBlocks, (this.maxStorageObjectSize >> 13) + ((this.maxStorageObjectSize & 0x1FFF) > 0 ? 1 : 0));
        this.cleaningThreshold = Math.min(this.maxMemoryBlocks << 4, this.blocks >> 1);
        this.criticalCleaningThreshold = Math.min(this.maxMemoryBlocks << 2, this.blocks >> 2);
        if (this.maxMemoryBlocks > 14) {
            --this.maxMemoryBlocks;
        }
        if (this.maxMemoryBlocks > 2062) {
            int indirect = this.maxMemoryBlocks - 2062;
            this.maxMemoryBlocks -= indirect / 2048 + (indirect % 2048 > 0 ? 1 : 0) + 1;
        }
        ArrayList<BlockStore> stores = new ArrayList<BlockStore>();
        long size = 8192L;
        int files = 32;
        do {
            stores.add(new BlockStore(this.storageManager, (int)size, 30, files));
            size <<= 1;
            if (files <= 1) continue;
            files >>= 1;
        } while (size >> 1 < (long)this.maxStorageObjectSize);
        this.sizeBasedStores = stores.toArray(new BlockStore[stores.size()]);
        this.truncateInterval = this.compactBufferFiles ? 1 : 8;
    }

    boolean lowBlocks(boolean critical) {
        int bitsSet = this.blocksInuse.getBitsSet();
        return bitsSet > 0 && this.blocks - bitsSet < (critical ? this.criticalCleaningThreshold : this.cleaningThreshold) && this.memoryBufferEntries.firstEntry(false) != null;
    }

    InodeBlockManager getBlockManager(long gid, long oid, int inode) {
        return new InodeBlockManager(gid, oid, inode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public boolean add(CacheEntry entry, Serializer s) {
        block60: {
            block61: {
                block58: {
                    block59: {
                        block56: {
                            block57: {
                                block54: {
                                    block55: {
                                        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                                            LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object)"adding object", (Object)s.getId(), (Object)entry.getId());
                                        }
                                        newEntry = false;
                                        blockManager = null;
                                        hasPermit = false;
                                        info = null;
                                        success = false;
                                        memoryBlocks = this.maxMemoryBlocks;
                                        map = this.physicalMapping.get(s.getId());
                                        if (map != null) break block54;
                                        var10_12 = true;
                                        if (hasPermit) {
                                            this.memoryWritePermits.release(memoryBlocks);
                                        }
                                        if (info == null) break block55;
                                        var11_14 = info;
                                        // MONITORENTER : var11_14
                                        info.adding = false;
                                        if (!success && blockManager != null) {
                                            info.inode = -1;
                                        }
                                        // MONITOREXIT : var11_14
                                    }
                                    if (success != false) return var10_12;
                                    if (blockManager == null) return var10_12;
                                    blockManager.free(false);
                                    return var10_12;
                                }
                                info = map.get(entry.getId());
                                if (info != null) ** GOTO lbl62
                                var10_13 = map;
                                // MONITORENTER : var10_13
                                info = map.get(entry.getId());
                                if (info != null) ** GOTO lbl61
                                newEntry = true;
                                if (map.containsKey(entry.getId())) break block56;
                                var11_15 = true;
                                // MONITOREXIT : var10_13
                                if (hasPermit) {
                                    this.memoryWritePermits.release(memoryBlocks);
                                }
                                if (info == null) break block57;
                                var12_21 = info;
                                // MONITORENTER : var12_21
                                info.adding = false;
                                if (!success && blockManager != null) {
                                    info.inode = -1;
                                }
                                // MONITOREXIT : var12_21
                            }
                            if (success != false) return var11_15;
                            if (blockManager == null) return var11_15;
                            blockManager.free(false);
                            return var11_15;
                        }
                        info = new PhysicalInfo(s.getId(), entry.getId(), -1, this.readAttempts.get(), entry.getSizeEstimate());
                        info.adding = true;
                        map.put((Long)entry.getId(), (PhysicalInfo)info);
lbl61:
                        // 2 sources

                        // MONITOREXIT : var10_13
lbl62:
                        // 2 sources

                        if (newEntry) ** GOTO lbl130
                        var10_13 = info;
                        // MONITORENTER : var10_13
                        if (!info.adding) break block58;
                        info = null;
                        var11_16 = false;
                        // MONITOREXIT : var10_13
                        if (hasPermit) {
                            this.memoryWritePermits.release(memoryBlocks);
                        }
                        if (info == null) break block59;
                        var12_22 = info;
                        // MONITORENTER : var12_22
                        info.adding = false;
                        if (!success && blockManager != null) {
                            info.inode = -1;
                        }
                        // MONITOREXIT : var12_22
                    }
                    if (success != false) return var11_16;
                    if (blockManager == null) return var11_16;
                    blockManager.free(false);
                    return var11_16;
                }
                try {
                    if (this.shouldPlaceInMemoryBuffer(info)) break block60;
                    info = null;
                    var11_17 = true;
                    // MONITOREXIT : var10_13
                    if (hasPermit) {
                        this.memoryWritePermits.release(memoryBlocks);
                    }
                    if (info == null) break block61;
                    var12_23 = info;
                }
                catch (Throwable e) {
                    if (e == PhysicalInfo.sizeChanged) {
                        LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object)"Object ", (Object)entry.getId(), (Object)" changed size since first persistence, keeping the original.");
                        return true;
                    }
                    if (e != BlockOutputStream.exceededMax) {
                        LogManager.logError((String)"org.teiid.BUFFER_MGR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30002, new Object[]{s.getId(), entry.getId()}));
                        return true;
                    }
                    size = new long[1];
                    try {
                        dos = new ObjectOutputStream(new OutputStream(){

                            @Override
                            public void write(int b) throws IOException {
                                size[0] = size[0] + 1L;
                            }
                        });
                        s.serialize(entry.getObject(), dos);
                    }
                    catch (IOException var11_20) {
                        // empty catch block
                    }
                    if (!newEntry && memoryBlocks < this.maxMemoryBlocks) {
                        LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object)"Object ", (Object)entry.getId(), (Object)" changed size since first persistence, keeping the original.");
                        return true;
                    }
                    LogManager.logError((String)"org.teiid.BUFFER_MGR", (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30001, new Object[]{entry.getId(), s.getId(), entry.getSizeEstimate(), size[0], s.describe(entry.getObject())}));
                    return true;
                }
                info.adding = false;
                if (!success && blockManager != null) {
                    info.inode = -1;
                }
                // MONITOREXIT : var12_23
            }
            if (success != false) return var11_17;
            if (blockManager == null) return var11_17;
            blockManager.free(false);
            return var11_17;
        }
        try {
            info.adding = true;
            if (info.memoryBlockCount != 0) {
                memoryBlocks = info.memoryBlockCount;
            }
            // MONITOREXIT : var10_13
lbl130:
            // 2 sources

            this.checkForLowMemory();
            this.memoryWritePermits.acquire(memoryBlocks);
            hasPermit = true;
            blockManager = this.getBlockManager(s.getId(), entry.getId(), -1);
            bos = new BlockOutputStream(blockManager, memoryBlocks);
            bos.writeLong(s.getId());
            bos.writeLong(entry.getId());
            dos = new ObjectOutputStream(bos);
            s.serialize(entry.getObject(), dos);
            dos.close();
            var12_24 = map;
            // MONITORENTER : var12_24
            if (this.physicalMapping.containsKey(s.getId()) && map.containsKey(entry.getId())) {
                var13_25 = info;
                // MONITORENTER : var13_25
                if (info.inode != -1) {
                    throw new AssertionError((Object)"The object already has an inode failing this add attempt");
                }
                info.setSize(bos.getBytesWritten());
                info.inode = blockManager.getInode();
                this.memoryBufferEntries.add(info);
                // MONITOREXIT : var13_25
                success = true;
                return true;
            }
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object)"removed during add", (Object)s.getId(), (Object)entry.getId());
            }
            // MONITOREXIT : var12_24
            return true;
        }
        catch (Throwable var22_26) {
            throw var22_26;
        }
        finally {
            if (hasPermit) {
                this.memoryWritePermits.release(memoryBlocks);
            }
            if (info != null) {
                map = info;
            }
            if (!success && blockManager != null) {
                blockManager.free(false);
            }
        }
    }

    private void checkForLowMemory() {
        if (!this.cleanerRunning.get() && this.lowBlocks(false) && this.cleanerRunning.compareAndSet(false, true)) {
            LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object)"Starting memory buffer cleaner");
            this.asynchPool.execute(this.cleaningTask);
        }
        if (this.lowBlocks(true)) {
            this.evictFromMemoryBuffer(false);
        }
    }

    @Override
    public PhysicalInfo lockForLoad(Long oid, Serializer<?> serializer) {
        Map<Long, PhysicalInfo> map = this.physicalMapping.get(serializer.getId());
        if (map == null) {
            return null;
        }
        PhysicalInfo info = map.get(oid);
        if (info == null) {
            return null;
        }
        info.lockForLoad();
        return info;
    }

    @Override
    public void unlockForLoad(PhysicalInfo info) {
        if (info == null) {
            return;
        }
        info.unlockForLoad();
    }

    @Override
    public int getCacheGroupCount() {
        return this.physicalMapping.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public CacheEntry get(PhysicalInfo info, Long oid, WeakReference<? extends Serializer<?>> ref) throws TeiidComponentException {
        CacheEntry cacheEntry;
        int memoryBlocks;
        ExtensibleBufferedInputStream eis;
        ReentrantReadWriteLock.WriteLock lock;
        Serializer serializer;
        block26: {
            if (info == null) {
                return null;
            }
            serializer = (Serializer)ref.get();
            if (serializer == null) {
                return null;
            }
            this.readAttempts.incrementAndGet();
            Object var5_5 = null;
            lock = null;
            eis = null;
            memoryBlocks = 0;
            PhysicalInfo physicalInfo = info;
            // MONITORENTER : physicalInfo
            if (!$assertionsDisabled) {
                if (info.pinned) throw new AssertionError();
                if (!info.loading) {
                    throw new AssertionError();
                }
            }
            info.await(true, false);
            if (info.inode != -1) {
                info.pinned = true;
                this.memoryBufferEntries.touch(info);
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Getting object at inode", info.inode, serializer.getId(), oid});
                }
                InodeBlockManager manager = this.getBlockManager(serializer.getId(), oid, info.inode);
                BlockInputStream blockInputStream = new BlockInputStream(manager, info.memoryBlockCount);
                break block26;
            }
            if (info.block != -1) {
                info.pinned = true;
                this.memoryBufferEntries.recordAccess(info);
                this.storageReads.incrementAndGet();
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                    LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Getting object at block", info.block, info.sizeIndex, serializer.getId(), oid});
                }
                BlockStore blockStore = this.sizeBasedStores[info.sizeIndex];
                int segment = info.block / blockStore.blocksInUse.getBitsPerSegment();
                FileStore fs = blockStore.stores[segment];
                long blockOffset = (long)(info.block % blockStore.blocksInUse.getBitsPerSegment()) * blockStore.blockSize;
                eis = fs.createInputStream(blockOffset, info.memoryBlockCount << 13);
                lock = blockStore.locks[segment].writeLock();
                memoryBlocks = info.memoryBlockCount;
                break block26;
            }
            CacheEntry blockStore = null;
            // MONITOREXIT : physicalInfo
            PhysicalInfo physicalInfo2 = info;
            // MONITORENTER : physicalInfo2
            info.pinned = false;
            info.notifyAll();
            // MONITOREXIT : physicalInfo2
            return blockStore;
        }
        try {
            CacheEntry ce;
            void var5_9;
            // MONITOREXIT : physicalInfo
            if (lock != null) {
                InputStream inputStream = this.readIntoMemory(info, eis, lock, memoryBlocks);
            }
            for (int i = 0; i < 16; ++i) {
                var5_9.read();
            }
            ObjectInputStream dis = new ObjectInputStream((InputStream)var5_9);
            cacheEntry = ce = new CacheEntry(new CacheKey(oid, 1L, 1L), info.sizeEstimate, serializer.deserialize(dis), ref, true);
            PhysicalInfo physicalInfo = info;
        }
        catch (IOException e) {
            try {
                throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30048, (Throwable)e, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30048, new Object[]{info.gid, oid}));
                catch (ClassNotFoundException e2) {
                    throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30048, (Throwable)e2, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30048, new Object[]{info.gid, oid}));
                }
                catch (InterruptedException e3) {
                    throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30049, (Throwable)e3);
                }
            }
            catch (Throwable throwable) {
                PhysicalInfo physicalInfo = info;
                // MONITORENTER : physicalInfo
                info.pinned = false;
                info.notifyAll();
                // MONITOREXIT : physicalInfo
                throw throwable;
            }
        }
        // MONITORENTER : physicalInfo
        info.pinned = false;
        info.notifyAll();
        // MONITOREXIT : physicalInfo
        return cacheEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream readIntoMemory(PhysicalInfo info, ExtensibleBufferedInputStream is, Lock fileLock, int memoryBlocks) throws InterruptedException, IOException {
        this.checkForLowMemory();
        this.memoryWritePermits.acquire(memoryBlocks);
        InodeBlockManager manager = null;
        boolean success = false;
        boolean locked = false;
        try {
            manager = this.getBlockManager(info.gid, info.getId(), -1);
            for (int i = 0; i < memoryBlocks; ++i) {
                manager.allocateBlock(i);
            }
            fileLock.lock();
            locked = true;
            BlockOutputStream os = new BlockOutputStream(manager, -1);
            ByteBuffer bb = null;
            while ((bb = is.getBuffer()) != null) {
                byte[] array = bb.array();
                os.write(array, bb.position() + bb.arrayOffset(), bb.remaining());
                bb.position(bb.position() + bb.remaining());
            }
            fileLock.unlock();
            os.close();
            locked = false;
            PhysicalInfo physicalInfo = info;
            synchronized (physicalInfo) {
                info.inode = manager.getInode();
                this.memoryBufferEntries.add(info);
                is = new BlockInputStream(manager, info.memoryBlockCount);
            }
            success = true;
        }
        finally {
            try {
                if (locked) {
                    fileLock.unlock();
                }
                if (!success && manager != null) {
                    manager.free(false);
                }
            }
            finally {
                this.memoryWritePermits.release(memoryBlocks);
            }
        }
        return is;
    }

    private boolean shouldPlaceInMemoryBuffer(PhysicalInfo info) {
        if (info.evicting || info.inode != -1) {
            return false;
        }
        if (info.block == -1) {
            return true;
        }
        PhysicalInfo lowest = this.memoryBufferEntries.firstEntry(false);
        CacheKey key = info.getKey();
        return this.blocksInuse.getTotalBits() - this.blocksInuse.getBitsSet() > this.cleaningThreshold + info.memoryBlockCount || lowest != null && lowest.block != -1 && lowest.getKey().getOrderingValue() < key.getOrderingValue();
    }

    @Override
    public FileStore createFileStore(String name) {
        return this.storageManager.createFileStore(name);
    }

    public void setDirect(boolean direct) {
        this.direct = direct;
    }

    @Override
    public boolean addToCacheGroup(Long gid, Long oid) {
        Map<Long, PhysicalInfo> map = this.physicalMapping.get(gid);
        if (map == null) {
            return false;
        }
        if (map.put(oid, null) != null) {
            throw new AssertionError((Object)"already added");
        }
        return true;
    }

    @Override
    public void createCacheGroup(Long gid) {
        this.physicalMapping.put(gid, Collections.synchronizedMap(new HashMap()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Integer remove(Long gid, Long id) {
        Map<Long, PhysicalInfo> map = this.physicalMapping.get(gid);
        if (map == null) {
            return null;
        }
        PhysicalInfo info = null;
        Integer result = null;
        Map<Long, PhysicalInfo> map2 = map;
        synchronized (map2) {
            info = map.remove(id);
            if (info != null) {
                result = info.sizeEstimate;
            }
        }
        if (info != null) {
            this.free(info, false, false);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<Long> removeCacheGroup(Long gid) {
        Map<Long, PhysicalInfo> map = this.physicalMapping.remove(gid);
        if (map == null) {
            return Collections.emptySet();
        }
        Map<Long, PhysicalInfo> map2 = map;
        synchronized (map2) {
            for (Map.Entry<Long, PhysicalInfo> entry : map.entrySet()) {
                this.free(entry.getValue(), false, false);
            }
            return map.keySet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int free(PhysicalInfo info, boolean demote, boolean acquireDataBlock) {
        BlockStore blockStore;
        Object is;
        byte sizeIndex;
        int memoryBlockCount;
        if (info == null) {
            return -1;
        }
        Long oid = info.getId();
        int result = -2;
        InodeBlockManager bm = null;
        int block = -1;
        PhysicalInfo physicalInfo = info;
        synchronized (physicalInfo) {
            if (!demote) {
                info.await(true, true);
                info.evicting = true;
            } else assert (info.evicting);
            block = info.block;
            memoryBlockCount = info.memoryBlockCount;
            sizeIndex = info.sizeIndex;
            if (info.inode != -1) {
                bm = this.getBlockManager(info.gid, oid, info.inode);
            } else if (demote) {
                info.evicting = false;
                info.notifyAll();
                return -1;
            }
        }
        try {
            block85: {
                if (!demote || block != -1) break block85;
                is = new BlockInputStream(bm, memoryBlockCount);
                blockStore = this.sizeBasedStores[sizeIndex];
                block39: for (int i = 0; i < 3; ++i) {
                    try {
                        block = blockStore.writeToStorageBlock(info, (InputStream)is);
                        this.storageWrites.getAndIncrement();
                        break;
                    }
                    catch (OutOfDiskException e) {
                        switch (i) {
                            case 0: {
                                this.defragTask.truncate(true);
                                break;
                            }
                            case 1: {
                                Object object;
                                try {
                                    object = info;
                                    synchronized (object) {
                                        info.evicting = false;
                                        info.notifyAll();
                                    }
                                    this.bufferManager.killLargestConsumer();
                                }
                                finally {
                                    object = info;
                                    synchronized (object) {
                                        info.await(true, true);
                                        info.evicting = true;
                                        block = info.block;
                                        memoryBlockCount = info.memoryBlockCount;
                                        sizeIndex = info.sizeIndex;
                                        if (block != -1) {
                                            break block39;
                                        }
                                        if (info.inode != -1) {
                                        }
                                        bm = null;
                                        break block39;
                                    }
                                }
                                object = this;
                                synchronized (object) {
                                    if (System.currentTimeMillis() - this.lastFullRun > 10000L) {
                                        this.defragTask.defrag(true);
                                        this.defragTask.truncate(true);
                                        this.lastFullRun = System.currentTimeMillis();
                                    }
                                    break;
                                }
                            }
                            case 2: {
                                throw e;
                            }
                        }
                        continue;
                    }
                }
            }
            is = info;
        }
        catch (IOException e) {
            PhysicalInfo physicalInfo2;
            try {
                if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                    LogManager.logError((String)"org.teiid.BUFFER_MGR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30016, new Object[]{oid, info.gid}));
                } else {
                    LogManager.logError((String)"org.teiid.BUFFER_MGR", (Object)(QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30016, new Object[]{oid, info.gid}) + " " + e.getMessage()));
                }
                physicalInfo2 = info;
            }
            catch (Throwable throwable) {
                PhysicalInfo physicalInfo3 = info;
                synchronized (physicalInfo3) {
                    assert (info.evicting);
                    info.await(true, false);
                    info.evicting = false;
                    info.notifyAll();
                    assert (bm == null || info.inode != -1);
                    if (info.inode != -1) {
                        info.inode = -1;
                        this.memoryBufferEntries.remove(info);
                    }
                    if (block != -1) {
                        if (demote) {
                            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Assigning storage data block", block, "of size", this.sizeBasedStores[info.sizeIndex].blockSize});
                            }
                            info.block = block;
                        } else {
                            BlockStore blockStore2 = this.sizeBasedStores[info.sizeIndex];
                            blockStore2.blocksInUse.clear(info.block);
                            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Freed storage data block", info.block, "of size", blockStore2.blockSize});
                            }
                            if (!this.defragRunning.get() && (this.freedCounter.getAndIncrement() & 0x3FFF) == 16383 && this.defragRunning.compareAndSet(false, true)) {
                                this.asynchPool.execute(this.defragTask);
                            }
                            info.block = -1;
                        }
                    }
                    if (bm != null) {
                        result = bm.free(acquireDataBlock);
                        this.freedLock.lock();
                        try {
                            this.blocksFreed.signalAll();
                        }
                        finally {
                            this.freedLock.unlock();
                        }
                    }
                    if (block != -1) throw throwable;
                    if (!demote) throw throwable;
                    if (this.bufferManager == null) throw throwable;
                    this.bufferManager.invalidCacheGroup(info.gid);
                    throw throwable;
                }
            }
            synchronized (physicalInfo2) {
                assert (info.evicting);
                info.await(true, false);
                info.evicting = false;
                info.notifyAll();
                assert (bm == null || info.inode != -1);
                if (info.inode != -1) {
                    info.inode = -1;
                    this.memoryBufferEntries.remove(info);
                }
                if (block != -1) {
                    if (demote) {
                        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                            LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Assigning storage data block", block, "of size", this.sizeBasedStores[info.sizeIndex].blockSize});
                        }
                        info.block = block;
                    } else {
                        BlockStore blockStore3 = this.sizeBasedStores[info.sizeIndex];
                        blockStore3.blocksInUse.clear(info.block);
                        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                            LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Freed storage data block", info.block, "of size", blockStore3.blockSize});
                        }
                        if (!this.defragRunning.get() && (this.freedCounter.getAndIncrement() & 0x3FFF) == 16383 && this.defragRunning.compareAndSet(false, true)) {
                            this.asynchPool.execute(this.defragTask);
                        }
                        info.block = -1;
                    }
                }
                if (bm != null) {
                    result = bm.free(acquireDataBlock);
                    this.freedLock.lock();
                    try {
                        this.blocksFreed.signalAll();
                    }
                    finally {
                        this.freedLock.unlock();
                    }
                }
                if (block != -1) return result;
                if (!demote) return result;
                if (this.bufferManager == null) return result;
                this.bufferManager.invalidCacheGroup(info.gid);
                return result;
            }
        }
        synchronized (is) {
            assert (info.evicting);
            info.await(true, false);
            info.evicting = false;
            info.notifyAll();
            assert (bm == null || info.inode != -1);
            if (info.inode != -1) {
                info.inode = -1;
                this.memoryBufferEntries.remove(info);
            }
            if (block != -1) {
                if (demote) {
                    if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                        LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Assigning storage data block", block, "of size", this.sizeBasedStores[info.sizeIndex].blockSize});
                    }
                    info.block = block;
                } else {
                    blockStore = this.sizeBasedStores[info.sizeIndex];
                    blockStore.blocksInUse.clear(info.block);
                    if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                        LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Freed storage data block", info.block, "of size", blockStore.blockSize});
                    }
                    if (!this.defragRunning.get() && (this.freedCounter.getAndIncrement() & 0x3FFF) == 16383 && this.defragRunning.compareAndSet(false, true)) {
                        this.asynchPool.execute(this.defragTask);
                    }
                    info.block = -1;
                }
            }
            if (bm != null) {
                result = bm.free(acquireDataBlock);
                this.freedLock.lock();
                try {
                    this.blocksFreed.signalAll();
                }
                finally {
                    this.freedLock.unlock();
                }
            }
            if (block != -1) return result;
            if (!demote) return result;
            if (this.bufferManager == null) return result;
            this.bufferManager.invalidCacheGroup(info.gid);
            return result;
        }
    }

    boolean shouldDefrag(BlockStore blockStore, int segment, boolean all) {
        int highestBitSet = blockStore.blocksInUse.getHighestBitSet(segment);
        int bitsSet = blockStore.blocksInUse.getBitsSet(segment);
        highestBitSet = Math.max(bitsSet, Math.max(0, highestBitSet));
        if (highestBitSet == 0) {
            return false;
        }
        int freeBlocks = highestBitSet - bitsSet;
        return freeBlocks > highestBitSet >> (all ? 3 : 1) && (long)freeBlocks * blockStore.blockSize > this.minDefrag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int evictFromMemoryBuffer(boolean acquire) {
        int next;
        block24: {
            boolean writeLocked = false;
            next = -1;
            try {
                block13: for (int i = 0; i < 2 && next == -1; ++i) {
                    AutoCleanupUtil.doCleanup(true);
                    Iterator<PhysicalInfo> iter = this.memoryBufferEntries.getEvictionQueue().iterator();
                    while ((!acquire && this.lowBlocks(false) || acquire && (next = this.blocksInuse.getAndSetNextClearBit()) == -1) && iter.hasNext()) {
                        PhysicalInfo info;
                        PhysicalInfo physicalInfo = info = iter.next();
                        synchronized (physicalInfo) {
                            if (info.inode == -1) {
                                continue;
                            }
                            if (info.pinned || info.evicting) {
                                if (!acquire || i != 1) {
                                    continue;
                                }
                                if (acquire && !writeLocked) {
                                    this.memoryEvictionLock.writeLock().lock();
                                    writeLocked = true;
                                }
                                info.await(true, true);
                                if (info.inode == -1) {
                                    continue;
                                }
                            }
                            info.evicting = true;
                        }
                        next = this.free(info, true, acquire);
                        continue block13;
                    }
                }
                if (!acquire || next != -1) break block24;
                if (!writeLocked) {
                    this.memoryEvictionLock.writeLock().lock();
                    writeLocked = true;
                }
                this.freedLock.lock();
                try {
                    long waitTime = TIMEOUT_NANOS;
                    do {
                        if ((next = this.blocksInuse.getAndSetNextClearBit()) == -1) continue;
                        int n = next;
                        return n;
                    } while ((waitTime = this.blocksFreed.awaitNanos(waitTime)) > 0L);
                }
                finally {
                    this.freedLock.unlock();
                }
                next = this.blocksInuse.getAndSetNextClearBit();
                if (next == -1) {
                    throw new AssertionError((Object)"Could not free space for pending write");
                }
            }
            catch (InterruptedException e) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30050, (Throwable)e);
            }
            finally {
                if (writeLocked) {
                    this.memoryEvictionLock.writeLock().unlock();
                }
            }
        }
        return next;
    }

    public void setStorageManager(StorageManager storageManager) {
        this.storageManager = storageManager;
    }

    public StorageManager getStorageManager() {
        return this.storageManager;
    }

    public void setMemoryBufferSpace(long maxBufferSpace) {
        this.memoryBufferSpace = Math.min(maxBufferSpace, 0x100000000000L);
    }

    public int getInodesInUse() {
        return this.inodesInuse.getBitsSet();
    }

    public int getDataBlocksInUse() {
        return this.blocksInuse.getBitsSet();
    }

    public void setMaxStorageObjectSize(int maxStorageBlockSize) {
        if (maxStorageBlockSize > 0x40000000) {
            throw new TeiidRuntimeException("max storage block size cannot exceed 1 GB");
        }
        this.maxStorageObjectSize = maxStorageBlockSize;
    }

    public long getStorageReads() {
        return this.storageReads.get();
    }

    public long getStorageWrites() {
        return this.storageWrites.get();
    }

    @Override
    public long getMemoryBufferSpace() {
        return this.memoryBufferSpace;
    }

    public void setMinDefrag(long minDefrag) {
        this.minDefrag = minDefrag;
    }

    public int getMaxMemoryBlocks() {
        return this.maxMemoryBlocks;
    }

    public long getMemoryInUseBytes() {
        return this.blocksInuse.getBitsSet() * 8192 + this.inodesInuse.getBitsSet() * 64;
    }

    public void setBufferManager(BufferManagerImpl bufferManager) {
        this.bufferManager = bufferManager;
    }

    public void setTruncateInterval(int truncateInterval) {
        this.truncateInterval = truncateInterval;
    }

    public long getDiskUsage() {
        long result = 0L;
        for (int i = 0; i < this.sizeBasedStores.length; ++i) {
            BlockStore blockStore = this.sizeBasedStores[i];
            for (int segment = 0; segment < blockStore.stores.length; ++segment) {
                result += blockStore.stores[segment].getLength();
            }
        }
        return result;
    }

    @Override
    public void shutdown() {
        this.asynchPool.shutdownNow();
    }

    public void setCompactBufferFiles(boolean compactBufferFiles) {
        this.compactBufferFiles = compactBufferFiles;
    }

    @Override
    public long getMaxStorageSpace() {
        return this.storageManager.getMaxStorageSpace();
    }

    final class DefragTask
    implements Runnable {
        private AtomicInteger runs = new AtomicInteger();

        DefragTask() {
        }

        @Override
        public void run() {
            int count = this.runs.incrementAndGet();
            try {
                this.defrag(false);
                if (count % BufferFrontedFileStoreCache.this.truncateInterval == 0) {
                    this.truncate(false);
                }
            }
            catch (Throwable t) {
                LogManager.logWarning((String)"org.teiid.BUFFER_MGR", (Throwable)t, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30022, new Object[0]));
            }
            finally {
                BufferFrontedFileStoreCache.this.defragRunning.set(false);
            }
        }

        private long truncate(boolean anySpace) {
            anySpace |= BufferFrontedFileStoreCache.this.compactBufferFiles;
            long freed = 0L;
            for (int i = 0; i < BufferFrontedFileStoreCache.this.sizeBasedStores.length; ++i) {
                BlockStore blockStore = BufferFrontedFileStoreCache.this.sizeBasedStores[i];
                for (int segment = 0; segment < blockStore.stores.length; ++segment) {
                    freed += this.truncate(blockStore, segment, anySpace);
                }
            }
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object)"Finished truncate reclaimed", (Object)freed);
            }
            return freed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void defrag(boolean all) {
            all |= BufferFrontedFileStoreCache.this.compactBufferFiles;
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object)"Running defrag");
            }
            for (int i = 0; i < BufferFrontedFileStoreCache.this.sizeBasedStores.length; ++i) {
                BlockStore blockStore = BufferFrontedFileStoreCache.this.sizeBasedStores[i];
                block11: for (int segment = 0; segment < blockStore.stores.length; ++segment) {
                    if (!BufferFrontedFileStoreCache.this.shouldDefrag(blockStore, segment, all)) continue;
                    if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                        LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Defraging store", i, "segment", segment, "length", blockStore.stores[segment].getLength()});
                    }
                    try {
                        for (int retries = 0; retries < 10; ++retries) {
                            PhysicalInfo info;
                            int relativeBlockToMove = blockStore.blocksInUse.compactHighestBitSet(segment);
                            if (!BufferFrontedFileStoreCache.this.shouldDefrag(blockStore, segment, all) || relativeBlockToMove == -1) continue block11;
                            ExtensibleBufferedInputStream is = blockStore.stores[segment].createInputStream((long)relativeBlockToMove * blockStore.blockSize, blockStore.blockSize);
                            Long gid = null;
                            Long oid = null;
                            try {
                                gid = this.readLong(is);
                                oid = this.readLong(is);
                            }
                            catch (IOException e) {
                                continue;
                            }
                            ((InputStream)is).reset();
                            Map map = (Map)BufferFrontedFileStoreCache.this.physicalMapping.get(gid);
                            if (map == null || (info = (PhysicalInfo)map.get(oid)) == null) continue;
                            int bitIndex = relativeBlockToMove + segment * blockStore.blocksInUse.getBitsPerSegment();
                            PhysicalInfo physicalInfo = info;
                            synchronized (physicalInfo) {
                                info.await(true, false);
                                if (info.block == -1) {
                                    continue;
                                }
                                if (info.block != bitIndex) {
                                    continue;
                                }
                            }
                            int newBlock = blockStore.writeToStorageBlock(info, is);
                            PhysicalInfo physicalInfo2 = info;
                            synchronized (physicalInfo2) {
                                info.await(true, true);
                                if (info.block == -1) {
                                    if (newBlock != -1) {
                                        blockStore.blocksInUse.clear(newBlock);
                                    }
                                    continue;
                                }
                                info.block = newBlock;
                                blockStore.blocksInUse.clear(bitIndex);
                                continue;
                            }
                        }
                        continue;
                    }
                    catch (IOException e) {
                        LogManager.logWarning((String)"org.teiid.BUFFER_MGR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30022, new Object[0]));
                    }
                }
            }
        }

        private long readLong(InputStream is) throws IOException {
            long val = 0L;
            for (int k = 0; k < 8; ++k) {
                val += (long)(is.read() & 0xFF) << 56 - k * 8;
            }
            return val;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long truncate(BlockStore blockStore, int segment, boolean anySpace) {
            block11: {
                blockStore.locks[segment].writeLock().lock();
                try {
                    int endBlock = blockStore.blocksInUse.compactHighestBitSet(segment);
                    long newLength = (long)(endBlock + 1) * blockStore.blockSize;
                    long oldLength = blockStore.stores[segment].getLength();
                    if (anySpace) {
                        if (newLength < oldLength) {
                            blockStore.stores[segment].setLength(newLength);
                            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Truncating segment", segment, "to", newLength});
                            }
                            long l = oldLength - newLength;
                            return l;
                        }
                        break block11;
                    }
                    long desiredLength = oldLength / blockStore.blockSize / 2L * blockStore.blockSize;
                    if (newLength < oldLength && newLength <= desiredLength && oldLength - desiredLength >= 2L * BufferFrontedFileStoreCache.this.minDefrag) {
                        blockStore.stores[segment].setLength(desiredLength);
                        if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                            LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Truncating segment", segment, "to", desiredLength});
                        }
                    }
                    long l = oldLength - desiredLength;
                    return l;
                }
                catch (IOException e) {
                    LogManager.logWarning((String)"org.teiid.BUFFER_MGR", (Throwable)e, (Object)QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30023, new Object[0]));
                }
                finally {
                    blockStore.locks[segment].writeLock().unlock();
                }
            }
            return 0L;
        }
    }

    private final class InodeBlockManager
    implements BlockManager {
        private int inode;
        private ByteBuffer inodeBuffer;
        private final long gid;
        private final long oid;
        private int blockSegment;
        private BlockByteBuffer blockByteBufferCopy;
        private BlockByteBuffer inodeByteBufferCopy;

        InodeBlockManager(long gid, long oid, int inode) {
            this.blockByteBufferCopy = BufferFrontedFileStoreCache.this.blockByteBuffer.duplicate();
            this.inodeByteBufferCopy = BufferFrontedFileStoreCache.this.inodeByteBuffer.duplicate();
            this.inode = inode;
            this.gid = gid;
            this.oid = oid;
            this.blockSegment = BufferFrontedFileStoreCache.this.blocksInuse.getNextSegment();
        }

        @Override
        public int getInode() {
            return this.inode;
        }

        @Override
        public ByteBuffer getBlock(int index) {
            int dataBlock = this.getOrUpdateDataBlockIndex(index, -1, Mode.GET);
            return this.blockByteBufferCopy.getByteBuffer(dataBlock);
        }

        private int getOrUpdateDataBlockIndex(int index, int value, Mode mode) {
            if (index >= 4196366) {
                throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30045, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30045, new Object[0]));
            }
            int dataBlock = 0;
            int position = 0;
            ByteBuffer info = this.getInodeBlock();
            if (index >= 2062) {
                position = 60;
                ByteBuffer next = this.updateIndirectBlockInfo(info, index, position, 2062, value, mode);
                if (next != null) {
                    info = next;
                    int indirectAddressBlock = (index - 2062) / 2048;
                    position = info.position() + indirectAddressBlock * 4;
                    if (mode == Mode.ALLOCATE && position + 4 < info.limit()) {
                        info.putInt(position + 4, -1);
                    }
                    if ((next = this.updateIndirectBlockInfo(info, index, position, 2062 + indirectAddressBlock * 2048, value, mode)) != null) {
                        info = next;
                        position = info.position() + (index - 2062) % 2048 * 4;
                    }
                }
            } else if (index >= 14) {
                position = 56;
                ByteBuffer next = this.updateIndirectBlockInfo(info, index, position, 14, value, mode);
                if (next != null) {
                    info = next;
                    position = next.position() + (index - 14) * 4;
                }
            } else {
                position = 4 * index;
            }
            if (mode == Mode.ALLOCATE) {
                dataBlock = this.nextBlock(info, true);
                info.putInt(position, dataBlock);
                if (mode == Mode.ALLOCATE && position + 4 < info.limit()) {
                    info.putInt(position + 4, -1);
                }
            } else {
                dataBlock = info.getInt(position);
                if (mode == Mode.UPDATE) {
                    info.putInt(position, value);
                }
            }
            return dataBlock;
        }

        private ByteBuffer updateIndirectBlockInfo(ByteBuffer buf, int index, int position, int cutOff, int value, Mode mode) {
            int sib_index = buf.getInt(position);
            if (index == cutOff) {
                if (mode == Mode.ALLOCATE) {
                    sib_index = this.nextBlock(buf, false);
                    buf.putInt(position, sib_index);
                } else if (mode == Mode.UPDATE && value == -1) {
                    this.freeDataBlock(sib_index);
                    return null;
                }
            }
            return this.blockByteBufferCopy.getByteBuffer(sib_index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int nextBlock(ByteBuffer reading, boolean data) {
            int limit = reading.limit();
            int position = reading.position();
            int next = -1;
            BufferFrontedFileStoreCache.this.memoryEvictionLock.readLock().lock();
            boolean readLocked = true;
            try {
                next = BufferFrontedFileStoreCache.this.blocksInuse.getAndSetNextClearBit(this.blockSegment);
                if (next == -1) {
                    BufferFrontedFileStoreCache.this.memoryEvictionLock.readLock().unlock();
                    readLocked = false;
                    next = BufferFrontedFileStoreCache.this.evictFromMemoryBuffer(true);
                }
            }
            finally {
                if (readLocked) {
                    BufferFrontedFileStoreCache.this.memoryEvictionLock.readLock().unlock();
                }
            }
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
                LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Allocating", data ? "data" : "index", "block", next, "to", this.gid, this.oid});
            }
            if (reading.limit() != limit) {
                reading.rewind();
                reading.limit(limit);
                reading.position(position);
            }
            return next;
        }

        @Override
        public void freeBlock(int index) {
            int dataBlock = this.getOrUpdateDataBlockIndex(index, -1, Mode.UPDATE);
            this.freeDataBlock(dataBlock);
        }

        private void freeDataBlock(int dataBlock) {
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)6)) {
                LogManager.logTrace((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"freeing data block", dataBlock, "for", this.gid, this.oid});
            }
            BufferFrontedFileStoreCache.this.blocksInuse.clear(dataBlock);
        }

        private ByteBuffer getInodeBlock() {
            if (this.inodeBuffer == null) {
                if (this.inode == -1) {
                    this.inode = BufferFrontedFileStoreCache.this.inodesInuse.getAndSetNextClearBit();
                    if (this.inode == -1) {
                        throw new AssertionError((Object)"Out of inodes");
                    }
                    if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                        LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"Allocating inode", this.inode, "to", this.gid, this.oid, "; total inodes", BufferFrontedFileStoreCache.this.getInodesInUse()});
                    }
                    ByteBuffer bb = this.getInodeBlock();
                    bb.putInt(-1);
                }
                this.inodeBuffer = this.inodeByteBufferCopy.getByteBuffer(this.inode).slice();
            }
            return this.inodeBuffer;
        }

        @Override
        public int free(boolean acquire) {
            if (this.inode == -1) {
                return -1;
            }
            ByteBuffer bb = this.getInodeBlock();
            int dataBlockToAcquire = bb.getInt(0);
            int indirectIndexBlock = bb.getInt(56);
            int doublyIndirectIndexBlock = bb.getInt(60);
            boolean freedAll = this.freeBlock(acquire ? 4 : 0, bb, 14 - (acquire ? 1 : 0), true);
            if (LogManager.isMessageToBeRecorded((String)"org.teiid.BUFFER_MGR", (int)5)) {
                LogManager.logDetail((String)"org.teiid.BUFFER_MGR", (Object[])new Object[]{"freeing inode", this.inode, "for", this.gid, this.oid});
            }
            BufferFrontedFileStoreCache.this.inodesInuse.clear(this.inode);
            if (!freedAll || indirectIndexBlock == -1) {
                return acquire ? dataBlockToAcquire : -2;
            }
            freedAll = this.freeIndirectBlock(indirectIndexBlock);
            if (!freedAll || doublyIndirectIndexBlock == -1) {
                return acquire ? dataBlockToAcquire : -2;
            }
            bb = this.blockByteBufferCopy.getByteBuffer(doublyIndirectIndexBlock).slice();
            this.freeBlock(0, bb, 2048, false);
            this.freeDataBlock(doublyIndirectIndexBlock);
            return acquire ? dataBlockToAcquire : -2;
        }

        private boolean freeIndirectBlock(int indirectIndexBlock) {
            ByteBuffer bb = this.blockByteBufferCopy.getByteBuffer(indirectIndexBlock);
            boolean freedAll = this.freeBlock(bb.position(), bb, 2048, true);
            this.freeDataBlock(indirectIndexBlock);
            return freedAll;
        }

        private boolean freeBlock(int startPosition, ByteBuffer ib, int numPointers, boolean primary) {
            ib.position(startPosition);
            for (int i = 0; i < numPointers; ++i) {
                int dataBlock = ib.getInt();
                if (dataBlock == -1) {
                    return false;
                }
                if (primary) {
                    this.freeDataBlock(dataBlock);
                    continue;
                }
                this.freeIndirectBlock(dataBlock);
            }
            return true;
        }

        @Override
        public ByteBuffer allocateBlock(int blockNum) {
            int dataBlock = this.getOrUpdateDataBlockIndex(blockNum, -1, Mode.ALLOCATE);
            return this.blockByteBufferCopy.getByteBuffer(dataBlock);
        }
    }

    private static enum Mode {
        GET,
        UPDATE,
        ALLOCATE;

    }
}

