/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.net;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.teiid.core.util.StringUtil;
import org.teiid.jdbc.JDBCPlugin;
import org.teiid.net.HostInfo;

public class TeiidURL {
    public static final String DOT_DELIMITER = ".";
    public static final String DOUBLE_SLASH_DELIMITER = "//";
    public static final String COMMA_DELIMITER = ",";
    public static final String COLON_DELIMITER = ":";
    public static final String BACKSLASH_DELIMITER = "\\";
    public static final String DEFAULT_PROTOCOL = "mm://";
    public static final String SECURE_PROTOCOL = "mms://";
    public static final String INVALID_FORMAT_SERVER = JDBCPlugin.Util.getString("MMURL.INVALID_FORMAT");
    private String appServerURL;
    private List<HostInfo> hosts = new ArrayList<HostInfo>();
    private boolean usingSSL = false;

    public TeiidURL(String serverURL) throws MalformedURLException {
        if (serverURL == null) {
            throw new MalformedURLException(INVALID_FORMAT_SERVER);
        }
        if (StringUtil.startsWithIgnoreCase((String)serverURL, (String)SECURE_PROTOCOL)) {
            this.usingSSL = true;
        } else if (!StringUtil.startsWithIgnoreCase((String)serverURL, (String)DEFAULT_PROTOCOL)) {
            throw new MalformedURLException(INVALID_FORMAT_SERVER);
        }
        this.appServerURL = serverURL;
        this.parseServerURL(serverURL.substring(this.usingSSL ? SECURE_PROTOCOL.length() : DEFAULT_PROTOCOL.length()), INVALID_FORMAT_SERVER);
    }

    public TeiidURL(String host, int port, boolean secure) {
        this.usingSSL = secure;
        if (host.startsWith("[")) {
            host = host.substring(1, host.indexOf(93));
        }
        this.hosts.add(new HostInfo(host, port));
    }

    public static boolean isValidServerURL(String serverURL) {
        boolean valid = true;
        try {
            new TeiidURL(serverURL);
        }
        catch (Exception e) {
            valid = false;
        }
        return valid;
    }

    public List<HostInfo> getHostInfo() {
        return this.hosts;
    }

    public String getHosts() {
        StringBuffer hostList = new StringBuffer("");
        if (this.hosts != null) {
            Iterator<HostInfo> iterator = this.hosts.iterator();
            while (iterator.hasNext()) {
                HostInfo element = iterator.next();
                hostList.append(element.getHostName());
                if (!iterator.hasNext()) continue;
                hostList.append(COMMA_DELIMITER);
            }
        }
        return hostList.toString();
    }

    public String getPorts() {
        StringBuffer portList = new StringBuffer("");
        if (this.hosts != null) {
            Iterator<HostInfo> iterator = this.hosts.iterator();
            while (iterator.hasNext()) {
                HostInfo element = iterator.next();
                portList.append(element.getPortNumber());
                if (!iterator.hasNext()) continue;
                portList.append(COMMA_DELIMITER);
            }
        }
        return portList.toString();
    }

    private void parseServerURL(String serverURL, String exceptionMessage) throws MalformedURLException {
        StringTokenizer st = new StringTokenizer(serverURL, COMMA_DELIMITER);
        if (!st.hasMoreTokens()) {
            throw new MalformedURLException(exceptionMessage);
        }
        while (st.hasMoreTokens()) {
            int hostEnd;
            String nextToken = st.nextToken();
            nextToken = nextToken.trim();
            String host = "";
            String port = "";
            if (nextToken.startsWith("[")) {
                hostEnd = nextToken.indexOf("]:");
                if (hostEnd == -1) {
                    throw new MalformedURLException(JDBCPlugin.Util.getString("TeiidURL.invalid_ipv6_hostport", new Object[]{nextToken, exceptionMessage}));
                }
                host = nextToken.substring(1, hostEnd);
                port = nextToken.substring(hostEnd + 2);
            } else {
                hostEnd = nextToken.indexOf(COLON_DELIMITER);
                if (hostEnd == -1) {
                    throw new MalformedURLException(JDBCPlugin.Util.getString("TeiidURL.invalid_hostport", new Object[]{nextToken, exceptionMessage}));
                }
                host = nextToken.substring(0, hostEnd);
                port = nextToken.substring(hostEnd + 1);
            }
            host = host.trim();
            port = port.trim();
            if (host.equals("") || port.equals("")) {
                throw new MalformedURLException(JDBCPlugin.Util.getString("TeiidURL.invalid_hostport", new Object[]{nextToken, exceptionMessage}));
            }
            int portNumber = TeiidURL.validatePort(port);
            HostInfo hostInfo = new HostInfo(host, portNumber);
            this.hosts.add(hostInfo);
        }
    }

    public static int validatePort(String port) throws MalformedURLException {
        int portNumber;
        try {
            portNumber = Integer.parseInt(port);
        }
        catch (NumberFormatException nfe) {
            throw new MalformedURLException(JDBCPlugin.Util.getString("TeiidURL.non_numeric_port", new Object[]{port}));
        }
        String msg = TeiidURL.validatePort(portNumber);
        if (msg != null) {
            throw new MalformedURLException(msg);
        }
        return portNumber;
    }

    public static String validatePort(int portNumber) {
        if (portNumber < 0 || portNumber > 65535) {
            return JDBCPlugin.Util.getString("TeiidURL.port_out_of_range", new Object[]{portNumber});
        }
        return null;
    }

    public String getAppServerURL() {
        if (this.appServerURL == null) {
            StringBuffer sb = new StringBuffer();
            if (this.usingSSL) {
                sb.append(SECURE_PROTOCOL);
            } else {
                sb.append(DEFAULT_PROTOCOL);
            }
            Iterator<HostInfo> iter = this.hosts.iterator();
            while (iter.hasNext()) {
                boolean ipv6HostName;
                HostInfo host = iter.next();
                boolean bl = ipv6HostName = host.getHostName().indexOf(58) != -1;
                if (ipv6HostName) {
                    sb.append('[');
                }
                sb.append(host.getHostName());
                if (ipv6HostName) {
                    sb.append(']');
                }
                sb.append(COLON_DELIMITER);
                sb.append(host.getPortNumber());
                if (!iter.hasNext()) continue;
                sb.append(COMMA_DELIMITER);
            }
            this.appServerURL = sb.toString();
        }
        return this.appServerURL;
    }

    public String toString() {
        return this.getAppServerURL();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof TeiidURL)) {
            return false;
        }
        TeiidURL url = (TeiidURL)obj;
        return this.appServerURL.equals(url.getAppServerURL());
    }

    public int hashCode() {
        return this.appServerURL.hashCode();
    }

    public boolean isUsingSSL() {
        return this.usingSSL;
    }

    public static interface CONNECTION {
        public static final String CLIENT_IP_ADDRESS = "clientIpAddress";
        public static final String CLIENT_HOSTNAME = "clientHostName";
        public static final String CLIENT_MAC = "clientMAC";
        public static final String AUTO_FAILOVER = "autoFailover";
        public static final String SERVER_URL = "serverURL";
        public static final String NON_SECURE_PROTOCOL = "mm";
        public static final String SECURE_PROTOCOL = "mms";
        public static final String APP_NAME = "ApplicationName";
        public static final String USER_NAME = "user";
        public static final String PASSWORD = "password";
        public static final String PASSTHROUGH_AUTHENTICATION = "PassthroughAuthentication";
        public static final String JAAS_NAME = "jaasName";
        public static final String KERBEROS_SERVICE_PRINCIPLE_NAME = "kerberosServicePrincipleName";
        public static final String ENCRYPT_REQUESTS = "encryptRequests";
        public static final String LOGIN_TIMEOUT = "loginTimeout";
    }

    public static interface JDBC {
        public static final String VDB_NAME = "VirtualDatabaseName";
        public static final String VDB_VERSION = "VirtualDatabaseVersion";
        public static final String VERSION = "version";
    }
}

