/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.teiid.connector.DataPlugin;
import org.teiid.core.BundleUtil;
import org.teiid.metadata.Datatype;
import org.teiid.metadata.DuplicateRecordException;
import org.teiid.metadata.Role;
import org.teiid.metadata.Schema;

public class MetadataStore
implements Serializable {
    private static final long serialVersionUID = -3130247626435324312L;
    protected NavigableMap<String, Schema> schemas = new TreeMap<String, Schema>(String.CASE_INSENSITIVE_ORDER);
    protected List<Schema> schemaList = new ArrayList<Schema>();
    protected NavigableMap<String, Datatype> datatypes = new TreeMap<String, Datatype>(String.CASE_INSENSITIVE_ORDER);
    protected NavigableMap<String, Datatype> unmondifiableDatatypes = Collections.unmodifiableNavigableMap(this.datatypes);
    protected LinkedHashMap<String, Role> roles = new LinkedHashMap();

    public NavigableMap<String, Schema> getSchemas() {
        return this.schemas;
    }

    public Schema getSchema(String name) {
        return (Schema)this.schemas.get(name);
    }

    public void addSchema(Schema schema) {
        if (this.schemas.put(schema.getName(), schema) != null) {
            throw new DuplicateRecordException((BundleUtil.Event)DataPlugin.Event.TEIID60012, DataPlugin.Util.gs((BundleUtil.Event)DataPlugin.Event.TEIID60012, new Object[]{schema.getName()}));
        }
        this.schemaList.add(schema);
    }

    public List<Schema> getSchemaList() {
        return this.schemaList;
    }

    public Schema removeSchema(String schemaName) {
        Schema s = (Schema)this.schemas.remove(schemaName);
        if (s != null) {
            this.schemaList.remove(s);
        }
        return s;
    }

    public void addDataTypes(Map<String, Datatype> typeMap) {
        if (typeMap != null) {
            for (Map.Entry<String, Datatype> entry : typeMap.entrySet()) {
                this.addDatatype(entry.getKey(), entry.getValue());
            }
        }
    }

    public void addDatatype(String name, Datatype datatype) {
        if (!this.datatypes.containsKey(name)) {
            this.datatypes.put(name, datatype);
        }
    }

    public NavigableMap<String, Datatype> getDatatypes() {
        return this.unmondifiableDatatypes;
    }

    public NavigableMap<String, Datatype> getDatatypesExcludingAliases() {
        TreeMap<String, Datatype> result = new TreeMap<String, Datatype>();
        for (Map.Entry entry : this.datatypes.entrySet()) {
            if (!((String)entry.getKey()).equals(((Datatype)entry.getValue()).getName())) continue;
            result.put((String)entry.getKey(), (Datatype)entry.getValue());
        }
        return result;
    }

    public void merge(MetadataStore store) {
        if (store != null) {
            for (Schema s : store.getSchemaList()) {
                this.addSchema(s);
            }
            this.addDataTypes(store.getDatatypes());
            this.mergeRoles(store.getRoles());
        }
    }

    public void mergeRoles(Collection<Role> toMerge) {
        for (Role r : toMerge) {
            Role existing = this.getRole(r.getName());
            if (existing != null) {
                r.mergeInto(existing);
                continue;
            }
            this.addRole(r);
        }
    }

    void addRole(Role role) {
        this.roles.put(role.getName(), role);
    }

    Role getRole(String roleName) {
        return this.roles.get(roleName);
    }

    public Collection<Role> getRoles() {
        return this.roles.values();
    }

    Role removeRole(String roleName) {
        return (Role)this.roles.remove(roleName);
    }
}

