/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.language.visitor;

import org.teiid.connector.DataPlugin;
import org.teiid.language.LanguageObject;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.language.visitor.LanguageObjectVisitor;

public class DelegatingHierarchyVisitor
extends HierarchyVisitor {
    private LanguageObjectVisitor postVisitor = null;
    private LanguageObjectVisitor preVisitor = null;

    public DelegatingHierarchyVisitor(LanguageObjectVisitor preProcessingDelegate, LanguageObjectVisitor postProcessingDelegate) {
        if (preProcessingDelegate == null && postProcessingDelegate == null) {
            throw new IllegalArgumentException(DataPlugin.Util.getString("DelegatingHierarchyVisitor.The_pre-_and_post-processing_visitors_cannot_both_be_null._1"));
        }
        this.preVisitor = preProcessingDelegate;
        this.postVisitor = postProcessingDelegate;
    }

    protected LanguageObjectVisitor getPostVisitor() {
        return this.postVisitor;
    }

    protected LanguageObjectVisitor getPreVisitor() {
        return this.preVisitor;
    }

    @Override
    public void visitNode(LanguageObject obj) {
        if (obj == null) {
            return;
        }
        if (this.preVisitor != null) {
            obj.acceptVisitor(this.preVisitor);
        }
        super.visitNode(obj);
        if (this.postVisitor != null) {
            obj.acceptVisitor(this.postVisitor);
        }
    }

    public static void preOrderVisit(LanguageObjectVisitor behaviorVisitor, LanguageObject object) {
        DelegatingHierarchyVisitor hierarchyVisitor = new DelegatingHierarchyVisitor(behaviorVisitor, null);
        object.acceptVisitor(hierarchyVisitor);
    }

    public static void postOrderVisit(LanguageObjectVisitor behaviorVisitor, LanguageObject object) {
        DelegatingHierarchyVisitor hierarchyVisitor = new DelegatingHierarchyVisitor(null, behaviorVisitor);
        object.acceptVisitor(hierarchyVisitor);
    }
}

