/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.HashSet;
import java.util.List;
import org.teavm.common.MutableGraphNode;
import org.teavm.model.BasicBlock;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.Variable;
import org.teavm.model.util.DefinitionExtractor;
import org.teavm.model.util.InstructionTransitionExtractor;
import org.teavm.model.util.LivenessAnalyzer;
import org.teavm.model.util.ProgramUtils;
import org.teavm.model.util.UsageExtractor;

class InterferenceGraphBuilder {
    InterferenceGraphBuilder() {
    }

    public List<MutableGraphNode> build(Program program, int paramCount, LivenessAnalyzer liveness) {
        ArrayList<MutableGraphNode> nodes = new ArrayList<MutableGraphNode>();
        for (int i = 0; i < program.variableCount(); ++i) {
            nodes.add(new MutableGraphNode(i));
        }
        UsageExtractor useExtractor = new UsageExtractor();
        DefinitionExtractor defExtractor = new DefinitionExtractor();
        InstructionTransitionExtractor succExtractor = new InstructionTransitionExtractor();
        List<List<Incoming>> outgoings = ProgramUtils.getPhiOutputs(program);
        HashSet<MutableGraphNode> live = new HashSet<MutableGraphNode>(128);
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            block.getLastInstruction().acceptVisitor(succExtractor);
            BitSet liveOut = new BitSet(program.variableCount());
            for (BasicBlock succ : succExtractor.getTargets()) {
                liveOut.or(liveness.liveIn(succ.getIndex()));
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                liveOut.or(liveness.liveIn(tryCatch.getHandler().getIndex()));
            }
            live.clear();
            for (int j = 0; j < liveOut.length(); ++j) {
                if (!liveOut.get(j)) continue;
                live.add((MutableGraphNode)nodes.get(j));
            }
            for (Incoming outgoing : outgoings.get(i)) {
                live.add((MutableGraphNode)nodes.get(outgoing.getValue().getIndex()));
            }
            for (Instruction insn = block.getLastInstruction(); insn != null; insn = insn.getPrevious()) {
                insn.acceptVisitor(useExtractor);
                insn.acceptVisitor(defExtractor);
                for (Variable var : defExtractor.getDefinedVariables()) {
                    ((MutableGraphNode)nodes.get(var.getIndex())).connectAll(live);
                }
                for (Variable var : defExtractor.getDefinedVariables()) {
                    live.remove(nodes.get(var.getIndex()));
                }
                for (Variable var : useExtractor.getUsedVariables()) {
                    live.add((MutableGraphNode)nodes.get(var.getIndex()));
                }
            }
            if (block.getExceptionVariable() != null) {
                ((MutableGraphNode)nodes.get(block.getExceptionVariable().getIndex())).connectAll(live);
                live.remove(nodes.get(block.getExceptionVariable().getIndex()));
            }
            if (block.getIndex() == 0) {
                for (int j = 0; j <= paramCount; ++j) {
                    ((MutableGraphNode)nodes.get(j)).connectAll(live);
                }
            }
            BitSet liveIn = liveness.liveIn(i);
            live.clear();
            for (int j = 0; j < liveOut.length(); ++j) {
                if (!liveIn.get(j)) continue;
                live.add((MutableGraphNode)nodes.get(j));
            }
            for (Phi phi : block.getPhis()) {
                live.add((MutableGraphNode)nodes.get(phi.getReceiver().getIndex()));
            }
            for (Phi phi : block.getPhis()) {
                ((MutableGraphNode)nodes.get(phi.getReceiver().getIndex())).connectAll(live);
            }
        }
        return nodes;
    }
}

