/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.backend.javascript.spi.InjectedBy;
import org.teavm.callgraph.CallGraph;
import org.teavm.callgraph.CallGraphNode;
import org.teavm.callgraph.CallSite;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.interop.Async;
import org.teavm.interop.SuppressSyncErrors;
import org.teavm.interop.Sync;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ProgramReader;
import org.teavm.model.VariableReader;
import org.teavm.model.instructions.AbstractInstructionReader;

public class AsyncMethodFinder {
    private Set<MethodReference> asyncMethods = new HashSet<MethodReference>();
    private Map<MethodReference, Boolean> asyncFamilyMethods = new HashMap<MethodReference, Boolean>();
    private Set<MethodReference> readonlyAsyncMethods = Collections.unmodifiableSet(this.asyncMethods);
    private Set<MethodReference> readonlyAsyncFamilyMethods = Collections.unmodifiableSet(this.asyncFamilyMethods.keySet());
    private CallGraph callGraph;
    private Diagnostics diagnostics;
    private ListableClassReaderSource classSource;

    public AsyncMethodFinder(CallGraph callGraph, Diagnostics diagnostics) {
        this.callGraph = callGraph;
        this.diagnostics = diagnostics;
    }

    public Set<MethodReference> getAsyncMethods() {
        return this.readonlyAsyncMethods;
    }

    public Set<MethodReference> getAsyncFamilyMethods() {
        return this.readonlyAsyncFamilyMethods;
    }

    public void find(ListableClassReaderSource classSource) {
        ClassReader cls;
        this.classSource = classSource;
        for (String string : classSource.getClassNames()) {
            cls = classSource.get(string);
            for (MethodReader methodReader : cls.getMethods()) {
                if (this.asyncMethods.contains(methodReader.getReference()) || methodReader.getAnnotations().get(Async.class.getName()) == null) continue;
                this.add(methodReader.getReference(), new CallStack(methodReader.getReference(), null));
            }
        }
        if (this.hasAsyncMethods()) {
            for (String string : classSource.getClassNames()) {
                cls = classSource.get(string);
                for (MethodReader methodReader : cls.getMethods()) {
                    if (this.asyncMethods.contains(methodReader.getReference()) || methodReader.getProgram() == null || !this.hasMonitor(methodReader)) continue;
                    this.add(methodReader.getReference(), new CallStack(methodReader.getReference(), null));
                }
            }
        }
        for (MethodReference methodReference : this.asyncMethods) {
            this.addOverridenToFamily(methodReference);
        }
        for (String string : classSource.getClassNames()) {
            cls = classSource.get(string);
            for (MethodReader methodReader : cls.getMethods()) {
                this.addToFamily(methodReader.getReference());
            }
        }
        for (Map.Entry entry : new ArrayList<Map.Entry<MethodReference, Boolean>>(this.asyncFamilyMethods.entrySet())) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            this.asyncFamilyMethods.remove(entry.getKey());
        }
    }

    private boolean hasAsyncMethods() {
        ClassReader cls;
        boolean result = false;
        block0: for (String clsName : this.classSource.getClassNames()) {
            ClassReader cls2 = this.classSource.get(clsName);
            for (MethodReader methodReader : cls2.getMethods()) {
                if (!this.asyncMethods.contains(methodReader.getReference()) || methodReader.getProgram() == null || !this.hasMonitor(methodReader)) continue;
                result = true;
                break block0;
            }
        }
        MethodReader method = (cls = this.classSource.get("java.lang.Thread")) != null ? cls.getMethod(new MethodDescriptor("start", Void.TYPE)) : null;
        return result && method != null;
    }

    private boolean hasMonitor(MethodReader method) {
        if (method.hasModifier(ElementModifier.SYNCHRONIZED)) {
            return true;
        }
        ProgramReader program = method.getProgram();
        AsyncInstructionReader insnReader = new AsyncInstructionReader();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            program.basicBlockAt(i).readAllInstructions(insnReader);
            if (!insnReader.async) continue;
            return true;
        }
        return false;
    }

    private void add(MethodReference methodRef, CallStack stack) {
        if (!this.asyncMethods.add(methodRef)) {
            return;
        }
        CallGraphNode node = this.callGraph.getNode(methodRef);
        if (node == null) {
            return;
        }
        ClassReader cls = this.classSource.get(methodRef.getClassName());
        if (cls == null) {
            return;
        }
        MethodReader method = cls.getMethod(methodRef.getDescriptor());
        if (method == null) {
            return;
        }
        if (method.getAnnotations().get(Sync.class.getName()) != null || method.getAnnotations().get(InjectedBy.class.getName()) != null) {
            if (method.getAnnotations().get(SuppressSyncErrors.class.getName()) == null) {
                this.diagnostics.error(new CallLocation(methodRef), "Method {{m0}} is claimed to be synchronous, but it is has invocations of asynchronous methods:" + stack.toString(), methodRef);
                return;
            }
            this.diagnostics.warning(new CallLocation(methodRef), "Error as Warning because  Method {{m0}} has @SuppressSyncErrors annoation. Method {{m0}} is claimed to be synchronous, but it is has invocations of asynchronous methods:" + stack.toString(), methodRef);
        }
        for (CallSite callSite : node.getCallerCallSites()) {
            MethodReference nextMethod = callSite.getCaller().getMethod();
            this.add(nextMethod, new CallStack(nextMethod, stack));
        }
    }

    private void addOverridenToFamily(MethodReference methodRef) {
        this.asyncFamilyMethods.put(methodRef, true);
        ClassReader cls = this.classSource.get(methodRef.getClassName());
        if (cls == null) {
            return;
        }
        for (MethodReference overridenMethod : this.findOverriddenMethods(cls, methodRef)) {
            this.addOverridenToFamily(overridenMethod);
        }
    }

    private boolean addToFamily(MethodReference methodRef) {
        Boolean cachedResult = this.asyncFamilyMethods.get(methodRef);
        if (cachedResult != null) {
            return cachedResult;
        }
        boolean result = this.addToFamilyCacheMiss(methodRef);
        this.asyncFamilyMethods.put(methodRef, result);
        return result;
    }

    private boolean addToFamilyCacheMiss(MethodReference methodRef) {
        if (this.asyncMethods.contains(methodRef)) {
            return true;
        }
        ClassReader cls = this.classSource.get(methodRef.getClassName());
        if (cls == null) {
            return false;
        }
        for (MethodReference overridenMethod : this.findOverriddenMethods(cls, methodRef)) {
            if (!this.addToFamily(overridenMethod)) continue;
            return true;
        }
        return false;
    }

    private Set<MethodReference> findOverriddenMethods(ClassReader cls, MethodReference methodRef) {
        ArrayList<String> parents = new ArrayList<String>();
        if (cls.getParent() != null && !cls.getParent().equals(cls.getName())) {
            parents.add(cls.getParent());
        }
        parents.addAll(cls.getInterfaces());
        HashSet<MethodReference> visited = new HashSet<MethodReference>();
        HashSet<MethodReference> overriden = new HashSet<MethodReference>();
        for (String parent : parents) {
            this.findOverriddenMethods(new MethodReference(parent, methodRef.getDescriptor()), overriden, visited);
        }
        return overriden;
    }

    private void findOverriddenMethods(MethodReference methodRef, Set<MethodReference> result, Set<MethodReference> visited) {
        if (!visited.add(methodRef)) {
            return;
        }
        if (methodRef.getName().equals("<init>") || methodRef.getName().equals("<clinit>")) {
            return;
        }
        ClassReader cls = this.classSource.get(methodRef.getClassName());
        if (cls == null) {
            return;
        }
        MethodReader method = cls.getMethod(methodRef.getDescriptor());
        if (method != null) {
            if (!method.hasModifier(ElementModifier.STATIC) && !method.hasModifier(ElementModifier.FINAL)) {
                result.add(methodRef);
            }
        } else {
            if (cls.getParent() != null && !cls.getParent().equals(cls.getName())) {
                this.findOverriddenMethods(new MethodReference(cls.getParent(), methodRef.getDescriptor()), result, visited);
            }
            for (String iface : cls.getInterfaces()) {
                this.findOverriddenMethods(new MethodReference(iface, methodRef.getDescriptor()), result, visited);
            }
        }
    }

    class AsyncInstructionReader
    extends AbstractInstructionReader {
        boolean async;

        AsyncInstructionReader() {
        }

        @Override
        public void monitorEnter(VariableReader objectRef) {
            this.async = true;
        }
    }

    private class CallStack {
        MethodReference method;
        CallStack next;

        public CallStack(MethodReference method, CallStack next) {
            this.method = method;
            this.next = next;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            CallStack stack = this;
            while (stack != null) {
                sb.append("\n    calling " + stack.method);
                stack = stack.next;
            }
            return sb.toString();
        }
    }
}

