/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.transformation;

import org.teavm.model.BasicBlock;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.Program;
import org.teavm.model.instructions.InitClassInstruction;

public class ClassInitializerInsertionTransformer {
    private static final MethodDescriptor clinitDescriptor = new MethodDescriptor("<clinit>", Void.TYPE);
    private ClassReaderSource classes;

    public ClassInitializerInsertionTransformer(ClassReaderSource classes) {
        this.classes = classes;
    }

    public void apply(MethodReader method, Program program) {
        boolean hasClinit;
        ClassReader cls = this.classes.get(method.getOwnerName());
        boolean bl = hasClinit = cls.getMethod(clinitDescriptor) != null;
        if (ClassInitializerInsertionTransformer.needsClinitCall(method) && hasClinit) {
            BasicBlock entryBlock = program.basicBlockAt(0);
            InitClassInstruction initInsn = new InitClassInstruction();
            initInsn.setClassName(method.getOwnerName());
            entryBlock.addFirst(initInsn);
        }
    }

    private static boolean needsClinitCall(MethodReader method) {
        if (method.getName().equals("<clinit>")) {
            return false;
        }
        if (method.getName().equals("<init>")) {
            return true;
        }
        return method.hasModifier(ElementModifier.STATIC);
    }
}

