/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import java.util.HashMap;
import java.util.Map;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class ReferenceCache {
    private Map<MethodReference, MethodReference> referenceCache = new HashMap<MethodReference, MethodReference>();
    private Map<FieldReference, FieldReference> fieldRefenceCache = new HashMap<FieldReference, FieldReference>();
    private Map<MethodDescriptor, MethodDescriptor> descriptorCache = new HashMap<MethodDescriptor, MethodDescriptor>();
    private Map<ValueType, ValueType> valueTypeCache = new HashMap<ValueType, ValueType>();
    private Map<String, String> classCache = new HashMap<String, String>();
    private Map<String, MethodReference> referenceParseCache = new HashMap<String, MethodReference>();
    private Map<String, MethodDescriptor> descriptorParseCache = new HashMap<String, MethodDescriptor>();
    private Map<String, ValueType> valueTypeParseCache = new HashMap<String, ValueType>();

    public MethodReference getCached(MethodReference reference) {
        MethodReference result = this.referenceCache.get(reference);
        if (result == null) {
            MethodDescriptor descriptor = this.getCached(reference.getDescriptor());
            String className = this.getCached(reference.getClassName());
            result = descriptor != reference.getDescriptor() || className != reference.getClassName() ? new MethodReference(className, descriptor) : reference;
            this.referenceCache.put(result, result);
        }
        return result;
    }

    public MethodDescriptor getCached(MethodDescriptor descriptor) {
        MethodDescriptor result = this.descriptorCache.get(descriptor);
        if (result == null) {
            result = descriptor;
            ValueType[] signature = descriptor.getSignature();
            boolean signatureChanged = false;
            for (int i = 0; i < signature.length; ++i) {
                ValueType cachedType;
                ValueType type = signature[i];
                if (type == null || type == (cachedType = this.getCached(type))) continue;
                signatureChanged = true;
                signature[i] = cachedType;
            }
            if (signatureChanged) {
                result = new MethodDescriptor(descriptor.getName(), signature);
            }
            this.descriptorCache.put(result, result);
        }
        return result;
    }

    public FieldReference getCached(FieldReference reference) {
        FieldReference result = this.fieldRefenceCache.get(reference);
        if (result == null) {
            result = reference;
            String classNameCached = this.getCached(reference.getClassName());
            String fieldNameCached = this.getCached(reference.getFieldName());
            if (classNameCached != reference.getClassName() || fieldNameCached != reference.getFieldName()) {
                result = new FieldReference(classNameCached, fieldNameCached);
            }
            this.fieldRefenceCache.put(result, result);
        }
        return result;
    }

    public ValueType getCached(ValueType valueType) {
        if (valueType instanceof ValueType.Primitive) {
            return valueType;
        }
        ValueType result = this.valueTypeCache.get(valueType);
        if (result == null) {
            ValueType cachedItem;
            ValueType item;
            result = valueType;
            if (result instanceof ValueType.Object) {
                String className = ((ValueType.Object)result).getClassName();
                String cachedClassName = this.getCached(className);
                if (cachedClassName != className) {
                    result = ValueType.object(cachedClassName);
                }
            } else if (result instanceof ValueType.Array && (item = ((ValueType.Array)result).getItemType()) != (cachedItem = this.getCached(item))) {
                result = ValueType.arrayOf(cachedItem);
            }
            this.valueTypeCache.put(result, result);
        }
        return result;
    }

    public String getCached(String className) {
        String result = this.classCache.get(className);
        if (result == null) {
            result = className;
            this.classCache.put(result, result);
        }
        return result;
    }

    public MethodReference parseReferenceCached(String value) {
        MethodReference result = this.referenceParseCache.get(value);
        if (result == null) {
            result = this.getCached(MethodReference.parse(value));
            this.referenceParseCache.put(value, result);
        }
        return result;
    }

    public MethodDescriptor parseDescriptorCached(String value) {
        MethodDescriptor result = this.descriptorParseCache.get(value);
        if (result == null) {
            result = this.getCached(MethodDescriptor.parse(value));
            this.descriptorParseCache.put(value, result);
        }
        return result;
    }

    public ValueType parseValueTypeCached(String value) {
        ValueType result = this.valueTypeParseCache.get(value);
        if (result == null) {
            result = this.getCached(ValueType.parse(value));
            this.valueTypeParseCache.put(value, result);
        }
        return result;
    }
}

