/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import org.teavm.model.AnnotationContainer;
import org.teavm.model.AnnotationValue;
import org.teavm.model.ClassHolder;
import org.teavm.model.MemberHolder;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Program;
import org.teavm.model.ValueType;

public class MethodHolder
extends MemberHolder
implements MethodReader {
    private MethodDescriptor descriptor;
    private ClassHolder owner;
    private Program program;
    private AnnotationValue annotationDefault;
    private AnnotationContainer[] parameterAnnotations;

    public MethodHolder(MethodDescriptor descriptor) {
        super(descriptor.getName());
        this.descriptor = descriptor;
        this.parameterAnnotations = new AnnotationContainer[descriptor.parameterCount()];
        for (int i = 0; i < this.parameterAnnotations.length; ++i) {
            this.parameterAnnotations[i] = new AnnotationContainer();
        }
    }

    public MethodHolder(String name, ValueType ... signature) {
        this(new MethodDescriptor(name, signature));
    }

    @Override
    public ValueType getResultType() {
        return this.descriptor.getResultType();
    }

    @Override
    public int parameterCount() {
        return this.descriptor.parameterCount();
    }

    @Override
    public ValueType[] getSignature() {
        return this.descriptor.getSignature();
    }

    @Override
    public ValueType parameterType(int index) {
        return this.descriptor.parameterType(index);
    }

    @Override
    public ValueType[] getParameterTypes() {
        return this.descriptor.getParameterTypes();
    }

    @Override
    public AnnotationContainer parameterAnnotation(int index) {
        return this.parameterAnnotations[index];
    }

    public AnnotationContainer[] getParameterAnnotations() {
        return (AnnotationContainer[])this.parameterAnnotations.clone();
    }

    @Override
    public String getOwnerName() {
        return this.owner != null ? this.owner.getName() : null;
    }

    ClassHolder getOwner() {
        return this.owner;
    }

    void setOwner(ClassHolder owner) {
        this.owner = owner;
    }

    @Override
    public MethodDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public MethodReference getReference() {
        return this.owner != null ? new MethodReference(this.owner.getName(), this.descriptor) : null;
    }

    @Override
    public Program getProgram() {
        return this.program;
    }

    public void setProgram(Program program) {
        if (this.program != null) {
            this.program.setMethod(null);
        }
        this.program = program;
        if (this.program != null) {
            this.program.setMethod(this);
        }
    }

    @Override
    public AnnotationValue getAnnotationDefault() {
        return this.annotationDefault;
    }

    public void setAnnotationDefault(AnnotationValue annotationDefault) {
        this.annotationDefault = annotationDefault;
    }
}

