/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.teavm.model.ClassReader;
import org.teavm.model.FieldReader;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public interface ClassReaderSource {
    public ClassReader get(String var1);

    default public Stream<ClassReader> getAncestorClasses(final String name) {
        return StreamSupport.stream(((Iterable)() -> new Iterator<ClassReader>(){
            ClassReader currentClass;
            {
                this.currentClass = ClassReaderSource.this.get(name);
            }

            @Override
            public ClassReader next() {
                ClassReader result = this.currentClass;
                this.currentClass = this.currentClass.getParent() != null && !this.currentClass.getName().equals(this.currentClass.getParent()) ? ClassReaderSource.this.get(this.currentClass.getParent()) : null;
                return result;
            }

            @Override
            public boolean hasNext() {
                return this.currentClass != null;
            }
        }).spliterator(), false);
    }

    default public Stream<ClassReader> getAncestors(final String name) {
        return StreamSupport.stream(((Iterable)() -> new Iterator<ClassReader>(){
            Deque state = new ArrayDeque();
            private Set visited = new HashSet();
            {
                this.state.push(new ArrayDeque());
                this.add(name);
            }

            @Override
            public ClassReader next() {
                while (!this.state.isEmpty()) {
                    Deque level = (Deque)this.state.peek();
                    if (!level.isEmpty()) {
                        ClassReader result = (ClassReader)level.removeFirst();
                        this.follow(result);
                        return result;
                    }
                    this.state.pop();
                }
                return null;
            }

            @Override
            public boolean hasNext() {
                return !this.state.stream().allMatch(e -> e.isEmpty());
            }

            private void follow(ClassReader cls) {
                this.state.push(new ArrayDeque());
                if (cls.getParent() != null) {
                    this.add(cls.getParent());
                }
                for (String iface : cls.getInterfaces()) {
                    this.add(iface);
                }
            }

            private void add(String name2) {
                ClassReader cls = ClassReaderSource.this.get(name2);
                if (cls != null && this.visited.add(cls)) {
                    ((Deque)this.state.peek()).addLast(cls);
                }
            }
        }).spliterator(), false);
    }

    default public MethodReader resolve(MethodReference method) {
        return this.getAncestors(method.getClassName()).map(cls -> cls.getMethod(method.getDescriptor())).filter(candidate -> candidate != null).findFirst().orElse(null);
    }

    default public FieldReader resolve(FieldReference field) {
        return this.getAncestors(field.getClassName()).map(cls -> cls.getField(field.getFieldName())).filter(candidate -> candidate != null).findFirst().orElse(null);
    }

    default public Stream<MethodReader> overriddenMethods(MethodReference method) {
        return this.getAncestorClasses(method.getClassName()).map(cls -> cls.getMethod(method.getDescriptor())).filter(candidate -> candidate != null);
    }

    default public Optional<Boolean> isSuperType(String superType, String subType) {
        if (superType.equals(subType)) {
            return Optional.of(true);
        }
        ClassReader cls = this.get(subType);
        if (cls == null) {
            return Optional.empty();
        }
        if (cls.getParent() != null && !cls.getParent().equals(cls.getName()) && this.isSuperType(superType, cls.getParent()).orElse(false).booleanValue()) {
            return Optional.of(true);
        }
        for (String iface : cls.getInterfaces()) {
            if (!this.isSuperType(superType, iface).orElse(false).booleanValue()) continue;
            return Optional.of(true);
        }
        return Optional.of(false);
    }

    default public Optional<Boolean> isSuperType(ValueType superType, ValueType subType) {
        if (superType.equals(subType)) {
            return Optional.of(true);
        }
        if (superType instanceof ValueType.Primitive || subType instanceof ValueType.Primitive) {
            return Optional.of(false);
        }
        if (superType.isObject("java.lang.Object")) {
            return Optional.of(true);
        }
        if (superType instanceof ValueType.Object && subType instanceof ValueType.Object) {
            return this.isSuperType(((ValueType.Object)superType).getClassName(), ((ValueType.Object)subType).getClassName());
        }
        if (superType instanceof ValueType.Array & subType instanceof ValueType.Array) {
            return this.isSuperType(((ValueType.Array)superType).getItemType(), ((ValueType.Array)subType).getItemType());
        }
        return Optional.of(false);
    }
}

