/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.dependency;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.List;
import org.teavm.dependency.DependencyChecker;
import org.teavm.dependency.DependencyConsumer;
import org.teavm.dependency.DependencyNodeToNodeTransition;
import org.teavm.dependency.DependencyType;
import org.teavm.dependency.DependencyTypeFilter;
import org.teavm.dependency.ValueDependencyInfo;
import org.teavm.model.MethodReference;

public class DependencyNode
implements ValueDependencyInfo {
    private DependencyChecker dependencyChecker;
    private List<DependencyConsumer> followers;
    private int[] smallTypes;
    private BitSet types;
    private List<DependencyNodeToNodeTransition> transitions;
    private volatile String tag;
    private DependencyNode arrayItemNode;
    private DependencyNode classValueNode;
    private int degree;
    boolean locked;
    MethodReference method;

    DependencyNode(DependencyChecker dependencyChecker) {
        this(dependencyChecker, 0);
    }

    private DependencyNode(DependencyChecker dependencyChecker, int degree) {
        this.dependencyChecker = dependencyChecker;
        this.degree = degree;
    }

    private boolean addType(DependencyType type) {
        if (this.types == null && this.smallTypes == null) {
            if (this.locked) {
                throw new IllegalStateException("Error propagating type " + type.getName() + " to node in " + this.method);
            }
            this.smallTypes = new int[]{type.index};
            return true;
        }
        if (this.smallTypes != null) {
            for (int i = 0; i < this.smallTypes.length; ++i) {
                if (this.smallTypes[i] != type.index) continue;
                return false;
            }
            if (this.smallTypes.length == 5) {
                this.types = new BitSet();
                for (int existingType : this.smallTypes) {
                    this.types.set(existingType);
                }
                this.smallTypes = null;
            } else {
                if (this.locked) {
                    throw new IllegalStateException("Error propagating type " + type.getName() + " to node in method " + this.method);
                }
                this.smallTypes = Arrays.copyOf(this.smallTypes, this.smallTypes.length + 1);
                this.smallTypes[this.smallTypes.length - 1] = type.index;
                return true;
            }
        }
        if (!this.types.get(type.index)) {
            if (this.locked) {
                throw new IllegalStateException("Error propagating type " + type.getName() + " to node " + this.tag);
            }
            this.types.set(type.index);
            return true;
        }
        return false;
    }

    public void propagate(DependencyType type) {
        if (type.getDependencyChecker() != this.dependencyChecker) {
            throw new IllegalArgumentException("The given type does not belong to the same dependency checker");
        }
        if (this.degree > 2) {
            return;
        }
        if (this.addType(type)) {
            if (DependencyChecker.shouldLog) {
                System.out.println(this.tag + " -> " + type.getName());
            }
            if (this.followers != null) {
                for (DependencyConsumer consumer : this.followers.toArray(new DependencyConsumer[this.followers.size()])) {
                    this.dependencyChecker.schedulePropagation(consumer, type);
                }
            }
            if (this.transitions != null) {
                for (DependencyConsumer consumer : this.transitions.toArray(new DependencyConsumer[this.transitions.size()])) {
                    this.dependencyChecker.schedulePropagation(consumer, type);
                }
            }
        }
    }

    public void propagate(DependencyType[] newTypes) {
        int i;
        DependencyType[] types = new DependencyType[newTypes.length];
        int j = 0;
        for (i = 0; i < newTypes.length; ++i) {
            DependencyType type = newTypes[i];
            if (type.getDependencyChecker() != this.dependencyChecker) {
                throw new IllegalArgumentException("The given type does not belong to the same dependency checker");
            }
            if (!this.addType(type)) continue;
            types[j++] = type;
        }
        if (j == 0) {
            return;
        }
        if (DependencyChecker.shouldLog) {
            for (i = 0; i < j; ++i) {
                System.out.println(this.tag + " -> " + types[i].getName());
            }
        }
        if (j < types.length && (this.followers != null || this.transitions != null)) {
            types = Arrays.copyOf(types, j);
        }
        if (this.followers != null) {
            DependencyConsumer[] dependencyConsumerArray = this.followers.toArray(new DependencyConsumer[this.followers.size()]);
            int n = dependencyConsumerArray.length;
            for (int k = 0; k < n; ++k) {
                DependencyConsumer dependencyConsumer = dependencyConsumerArray[k];
                this.dependencyChecker.schedulePropagation(dependencyConsumer, types);
            }
        }
        if (this.transitions != null) {
            for (DependencyNodeToNodeTransition dependencyNodeToNodeTransition : this.transitions.toArray(new DependencyNodeToNodeTransition[this.transitions.size()])) {
                this.dependencyChecker.schedulePropagation((DependencyConsumer)dependencyNodeToNodeTransition, types);
            }
        }
    }

    public void addConsumer(DependencyConsumer consumer) {
        if (this.followers == null) {
            this.followers = new ArrayList<DependencyConsumer>(1);
        }
        if (this.followers.contains(consumer)) {
            return;
        }
        this.followers.add(consumer);
        if (this.types != null) {
            ArrayList<DependencyType> types = new ArrayList<DependencyType>();
            int index = this.types.nextSetBit(0);
            while (index >= 0) {
                types.add(this.dependencyChecker.types.get(index));
                index = this.types.nextSetBit(index + 1);
            }
            this.dependencyChecker.schedulePropagation(consumer, types.toArray(new DependencyType[types.size()]));
        } else if (this.smallTypes != null) {
            DependencyType[] types = new DependencyType[this.smallTypes.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = this.dependencyChecker.types.get(this.smallTypes[i]);
            }
            this.dependencyChecker.schedulePropagation(consumer, types);
        }
    }

    public void connect(DependencyNode node, DependencyTypeFilter filter) {
        DependencyType[] types;
        if (this == node) {
            return;
        }
        if (node == null) {
            throw new IllegalArgumentException("Node must not be null");
        }
        if (this.transitions != null) {
            for (DependencyNodeToNodeTransition transition : this.transitions) {
                if (transition.destination != node) continue;
                return;
            }
        }
        DependencyNodeToNodeTransition transition = new DependencyNodeToNodeTransition(this, node, filter);
        if (this.transitions == null) {
            this.transitions = new ArrayList<DependencyNodeToNodeTransition>(1);
        }
        this.transitions.add(transition);
        if (DependencyChecker.shouldLog) {
            System.out.println("Connecting " + this.tag + " to " + node.tag);
        }
        if (this.types != null) {
            types = new ArrayList();
            int index = this.types.nextSetBit(0);
            while (index >= 0) {
                types.add(this.dependencyChecker.types.get(index));
                index = this.types.nextSetBit(index + 1);
            }
            this.dependencyChecker.schedulePropagation((DependencyConsumer)transition, types.toArray(new DependencyType[types.size()]));
        } else if (this.smallTypes != null) {
            types = new DependencyType[this.smallTypes.length];
            for (int i = 0; i < types.length; ++i) {
                types[i] = this.dependencyChecker.types.get(this.smallTypes[i]);
            }
            this.dependencyChecker.schedulePropagation((DependencyConsumer)transition, types);
        }
    }

    public void connect(DependencyNode node) {
        this.connect(node, null);
    }

    @Override
    public DependencyNode getArrayItem() {
        if (this.arrayItemNode == null) {
            this.arrayItemNode = new DependencyNode(this.dependencyChecker, this.degree + 1);
            if (DependencyChecker.shouldLog) {
                this.arrayItemNode.tag = this.tag + "[";
            }
        }
        return this.arrayItemNode;
    }

    @Override
    public DependencyNode getClassValueNode() {
        if (this.classValueNode == null) {
            this.classValueNode.classValueNode = this.classValueNode = new DependencyNode(this.dependencyChecker, this.degree);
            if (DependencyChecker.shouldLog) {
                this.classValueNode.tag = this.tag + "@";
            }
        }
        return this.classValueNode;
    }

    @Override
    public boolean hasArrayType() {
        return this.arrayItemNode != null && (this.arrayItemNode.types != null || this.arrayItemNode.smallTypes != null);
    }

    public boolean hasType(DependencyType type) {
        if (this.smallTypes != null) {
            for (int i = 0; i < this.smallTypes.length; ++i) {
                if (this.smallTypes[i] != type.index) continue;
                return true;
            }
            return false;
        }
        return this.types != null && type.getDependencyChecker() == this.dependencyChecker && this.types.get(type.index);
    }

    @Override
    public boolean hasType(String type) {
        return this.hasType(this.dependencyChecker.getType(type));
    }

    @Override
    public String[] getTypes() {
        if (this.smallTypes != null) {
            String[] result = new String[this.smallTypes.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.dependencyChecker.types.get(this.smallTypes[i]).getName();
            }
            return result;
        }
        if (this.types == null) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        int index = this.types.nextSetBit(0);
        while (index >= 0) {
            result.add(this.dependencyChecker.types.get(index).getName());
            index = this.types.nextSetBit(index + 1);
        }
        return result.toArray(new String[result.size()]);
    }

    public String getTag() {
        return this.tag;
    }

    public void setTag(String tag) {
        this.tag = tag;
    }
}

