/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cache;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Objects;
import org.teavm.cache.SymbolTable;
import org.teavm.model.BasicBlock;
import org.teavm.model.FieldReference;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.InvokeDynamicInstruction;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHandle;
import org.teavm.model.MethodReference;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.RuntimeConstant;
import org.teavm.model.TextLocation;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.ValueType;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ArrayElementType;
import org.teavm.model.instructions.ArrayLengthInstruction;
import org.teavm.model.instructions.AssignInstruction;
import org.teavm.model.instructions.BinaryBranchingCondition;
import org.teavm.model.instructions.BinaryBranchingInstruction;
import org.teavm.model.instructions.BinaryInstruction;
import org.teavm.model.instructions.BinaryOperation;
import org.teavm.model.instructions.BranchingCondition;
import org.teavm.model.instructions.BranchingInstruction;
import org.teavm.model.instructions.CastInstruction;
import org.teavm.model.instructions.CastIntegerDirection;
import org.teavm.model.instructions.CastIntegerInstruction;
import org.teavm.model.instructions.CastNumberInstruction;
import org.teavm.model.instructions.ClassConstantInstruction;
import org.teavm.model.instructions.CloneArrayInstruction;
import org.teavm.model.instructions.ConstructArrayInstruction;
import org.teavm.model.instructions.ConstructInstruction;
import org.teavm.model.instructions.ConstructMultiArrayInstruction;
import org.teavm.model.instructions.DoubleConstantInstruction;
import org.teavm.model.instructions.EmptyInstruction;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.FloatConstantInstruction;
import org.teavm.model.instructions.GetElementInstruction;
import org.teavm.model.instructions.GetFieldInstruction;
import org.teavm.model.instructions.InitClassInstruction;
import org.teavm.model.instructions.InstructionVisitor;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.IntegerSubtype;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.IsInstanceInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.instructions.LongConstantInstruction;
import org.teavm.model.instructions.MonitorEnterInstruction;
import org.teavm.model.instructions.MonitorExitInstruction;
import org.teavm.model.instructions.NegateInstruction;
import org.teavm.model.instructions.NullCheckInstruction;
import org.teavm.model.instructions.NullConstantInstruction;
import org.teavm.model.instructions.NumericOperandType;
import org.teavm.model.instructions.PutElementInstruction;
import org.teavm.model.instructions.PutFieldInstruction;
import org.teavm.model.instructions.RaiseInstruction;
import org.teavm.model.instructions.StringConstantInstruction;
import org.teavm.model.instructions.SwitchInstruction;
import org.teavm.model.instructions.SwitchTableEntry;
import org.teavm.model.instructions.UnwrapArrayInstruction;

public class ProgramIO {
    private SymbolTable symbolTable;
    private SymbolTable fileTable;
    private static BinaryOperation[] binaryOperations = BinaryOperation.values();
    private static NumericOperandType[] numericOperandTypes = NumericOperandType.values();
    private static IntegerSubtype[] integerSubtypes = IntegerSubtype.values();
    private static CastIntegerDirection[] castIntegerDirections = CastIntegerDirection.values();
    private static BranchingCondition[] branchingConditions = BranchingCondition.values();
    private static BinaryBranchingCondition[] binaryBranchingConditions = BinaryBranchingCondition.values();
    private static ArrayElementType[] arrayElementTypes = ArrayElementType.values();

    public ProgramIO(SymbolTable symbolTable, SymbolTable fileTable) {
        this.symbolTable = symbolTable;
        this.fileTable = fileTable;
    }

    public void write(Program program, OutputStream output) throws IOException {
        int i;
        DataOutputStream data = new DataOutputStream(output);
        data.writeShort(program.variableCount());
        data.writeShort(program.basicBlockCount());
        for (i = 0; i < program.variableCount(); ++i) {
            Variable var = program.variableAt(i);
            data.writeShort(var.getRegister());
            data.writeUTF(var.getDebugName() != null ? var.getDebugName() : "");
        }
        for (i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock basicBlock = program.basicBlockAt(i);
            data.writeShort(basicBlock.getExceptionVariable() != null ? basicBlock.getExceptionVariable().getIndex() : -1);
            data.writeShort(basicBlock.getPhis().size());
            data.writeShort(basicBlock.getTryCatchBlocks().size());
            for (Phi phi : basicBlock.getPhis()) {
                data.writeShort(phi.getReceiver().getIndex());
                data.writeShort(phi.getIncomings().size());
                for (Incoming incoming : phi.getIncomings()) {
                    data.writeShort(incoming.getSource().getIndex());
                    data.writeShort(incoming.getValue().getIndex());
                }
            }
            for (TryCatchBlock tryCatch : basicBlock.getTryCatchBlocks()) {
                data.writeInt(tryCatch.getExceptionType() != null ? this.symbolTable.lookup(tryCatch.getExceptionType()) : -1);
                data.writeShort(tryCatch.getHandler().getIndex());
            }
            TextLocation location = null;
            InstructionWriter insnWriter = new InstructionWriter(data);
            for (Instruction insn : basicBlock) {
                try {
                    if (!Objects.equals(location, insn.getLocation())) {
                        location = insn.getLocation();
                        if (location == null || location.getFileName() == null || location.getLine() < 0) {
                            data.writeByte(-2);
                        } else {
                            data.writeByte(-3);
                            data.writeShort(this.fileTable.lookup(location.getFileName()));
                            data.writeShort(location.getLine());
                        }
                    }
                    insn.acceptVisitor(insnWriter);
                }
                catch (IOExceptionWrapper e) {
                    throw (IOException)e.getCause();
                }
            }
            data.writeByte(-1);
        }
    }

    public Program read(InputStream input) throws IOException {
        int i;
        DataInputStream data = new DataInputStream(input);
        Program program = new Program();
        int varCount = data.readShort();
        int basicBlockCount = data.readShort();
        for (i = 0; i < varCount; ++i) {
            Variable var = program.createVariable();
            var.setRegister(data.readShort());
            var.setDebugName(data.readUTF());
            if (!var.getDebugName().isEmpty()) continue;
            var.setDebugName(null);
        }
        for (i = 0; i < basicBlockCount; ++i) {
            program.createBasicBlock();
        }
        block7: for (i = 0; i < basicBlockCount; ++i) {
            int j;
            BasicBlock block = program.basicBlockAt(i);
            short varIndex = data.readShort();
            if (varIndex >= 0) {
                block.setExceptionVariable(program.variableAt(varIndex));
            }
            int phiCount = data.readShort();
            int tryCatchCount = data.readShort();
            for (j = 0; j < phiCount; ++j) {
                Phi phi = new Phi();
                phi.setReceiver(program.variableAt(data.readShort()));
                int incomingCount = data.readShort();
                for (int k = 0; k < incomingCount; ++k) {
                    Incoming incoming = new Incoming();
                    incoming.setSource(program.basicBlockAt(data.readShort()));
                    incoming.setValue(program.variableAt(data.readShort()));
                    phi.getIncomings().add(incoming);
                }
                block.getPhis().add(phi);
            }
            for (j = 0; j < tryCatchCount; ++j) {
                TryCatchBlock tryCatch = new TryCatchBlock();
                int typeIndex = data.readInt();
                if (typeIndex >= 0) {
                    tryCatch.setExceptionType(this.symbolTable.at(typeIndex));
                }
                tryCatch.setHandler(program.basicBlockAt(data.readShort()));
                block.getTryCatchBlocks().add(tryCatch);
            }
            TextLocation location = null;
            block11: while (true) {
                byte insnType = data.readByte();
                switch (insnType) {
                    case -1: {
                        continue block7;
                    }
                    case -2: {
                        location = null;
                        continue block11;
                    }
                    case -3: {
                        String file = this.fileTable.at(data.readShort());
                        short line = data.readShort();
                        location = new TextLocation(file, line);
                        continue block11;
                    }
                    default: {
                        Instruction insn = this.readInstruction(insnType, program, data);
                        insn.setLocation(location);
                        block.add(insn);
                        continue block11;
                    }
                }
                break;
            }
        }
        return program;
    }

    private Instruction readInstruction(byte insnType, Program program, DataInput input) throws IOException {
        switch (insnType) {
            case 0: {
                return new EmptyInstruction();
            }
            case 1: {
                ClassConstantInstruction insn = new ClassConstantInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                insn.setConstant(ValueType.parse(this.symbolTable.at(input.readInt())));
                return insn;
            }
            case 2: {
                NullConstantInstruction insn = new NullConstantInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                return insn;
            }
            case 3: {
                IntegerConstantInstruction insn = new IntegerConstantInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                insn.setConstant(input.readInt());
                return insn;
            }
            case 4: {
                LongConstantInstruction insn = new LongConstantInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                insn.setConstant(input.readLong());
                return insn;
            }
            case 5: {
                FloatConstantInstruction insn = new FloatConstantInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                insn.setConstant(input.readFloat());
                return insn;
            }
            case 6: {
                DoubleConstantInstruction insn = new DoubleConstantInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                insn.setConstant(input.readDouble());
                return insn;
            }
            case 7: {
                StringConstantInstruction insn = new StringConstantInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                insn.setConstant(input.readUTF());
                return insn;
            }
            case 8: {
                Variable receiver = program.variableAt(input.readShort());
                BinaryOperation operation = binaryOperations[input.readByte()];
                NumericOperandType operandType = numericOperandTypes[input.readByte()];
                BinaryInstruction insn = new BinaryInstruction(operation, operandType);
                insn.setReceiver(receiver);
                insn.setFirstOperand(program.variableAt(input.readShort()));
                insn.setSecondOperand(program.variableAt(input.readShort()));
                return insn;
            }
            case 9: {
                Variable receiver = program.variableAt(input.readShort());
                NumericOperandType operandType = numericOperandTypes[input.readByte()];
                NegateInstruction insn = new NegateInstruction(operandType);
                insn.setReceiver(receiver);
                insn.setOperand(program.variableAt(input.readShort()));
                return insn;
            }
            case 10: {
                AssignInstruction insn = new AssignInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                insn.setAssignee(program.variableAt(input.readShort()));
                return insn;
            }
            case 11: {
                CastInstruction insn = new CastInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                insn.setTargetType(ValueType.parse(this.symbolTable.at(input.readInt())));
                insn.setValue(program.variableAt(input.readShort()));
                return insn;
            }
            case 12: {
                Variable receiver = program.variableAt(input.readShort());
                NumericOperandType sourceType = numericOperandTypes[input.readByte()];
                NumericOperandType targetType = numericOperandTypes[input.readByte()];
                CastNumberInstruction insn = new CastNumberInstruction(sourceType, targetType);
                insn.setReceiver(receiver);
                insn.setValue(program.variableAt(input.readShort()));
                return insn;
            }
            case 13: {
                Variable receiver = program.variableAt(input.readShort());
                IntegerSubtype targetType = integerSubtypes[input.readByte()];
                CastIntegerDirection direction = castIntegerDirections[input.readByte()];
                CastIntegerInstruction insn = new CastIntegerInstruction(targetType, direction);
                insn.setReceiver(receiver);
                insn.setValue(program.variableAt(input.readShort()));
                return insn;
            }
            case 14: {
                BranchingInstruction insn = new BranchingInstruction(branchingConditions[input.readByte()]);
                insn.setOperand(program.variableAt(input.readShort()));
                insn.setConsequent(program.basicBlockAt(input.readShort()));
                insn.setAlternative(program.basicBlockAt(input.readShort()));
                return insn;
            }
            case 15: {
                BinaryBranchingCondition cond = binaryBranchingConditions[input.readByte()];
                BinaryBranchingInstruction insn = new BinaryBranchingInstruction(cond);
                insn.setFirstOperand(program.variableAt(input.readShort()));
                insn.setSecondOperand(program.variableAt(input.readShort()));
                insn.setConsequent(program.basicBlockAt(input.readShort()));
                insn.setAlternative(program.basicBlockAt(input.readShort()));
                return insn;
            }
            case 16: {
                JumpInstruction insn = new JumpInstruction();
                insn.setTarget(program.basicBlockAt(input.readShort()));
                return insn;
            }
            case 17: {
                SwitchInstruction insn = new SwitchInstruction();
                insn.setCondition(program.variableAt(input.readShort()));
                insn.setDefaultTarget(program.basicBlockAt(input.readShort()));
                int entryCount = input.readShort();
                for (int i = 0; i < entryCount; ++i) {
                    SwitchTableEntry entry = new SwitchTableEntry();
                    entry.setCondition(input.readInt());
                    entry.setTarget(program.basicBlockAt(input.readShort()));
                    insn.getEntries().add(entry);
                }
                return insn;
            }
            case 18: {
                ExitInstruction insn = new ExitInstruction();
                insn.setValueToReturn(program.variableAt(input.readShort()));
                return insn;
            }
            case 19: {
                return new ExitInstruction();
            }
            case 20: {
                RaiseInstruction insn = new RaiseInstruction();
                insn.setException(program.variableAt(input.readShort()));
                return insn;
            }
            case 21: {
                ConstructArrayInstruction insn = new ConstructArrayInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                insn.setItemType(ValueType.parse(this.symbolTable.at(input.readInt())));
                insn.setSize(program.variableAt(input.readShort()));
                return insn;
            }
            case 22: {
                ConstructInstruction insn = new ConstructInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                insn.setType(this.symbolTable.at(input.readInt()));
                return insn;
            }
            case 23: {
                ConstructMultiArrayInstruction insn = new ConstructMultiArrayInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                insn.setItemType(ValueType.parse(this.symbolTable.at(input.readInt())));
                int dimensionCount = input.readByte();
                for (int i = 0; i < dimensionCount; ++i) {
                    insn.getDimensions().add(program.variableAt(input.readShort()));
                }
                return insn;
            }
            case 24: {
                GetFieldInstruction insn = new GetFieldInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                insn.setInstance(program.variableAt(input.readShort()));
                String className = this.symbolTable.at(input.readInt());
                String fieldName = this.symbolTable.at(input.readInt());
                insn.setField(new FieldReference(className, fieldName));
                insn.setFieldType(ValueType.parse(this.symbolTable.at(input.readInt())));
                return insn;
            }
            case 25: {
                GetFieldInstruction insn = new GetFieldInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                String className = this.symbolTable.at(input.readInt());
                String fieldName = this.symbolTable.at(input.readInt());
                insn.setField(new FieldReference(className, fieldName));
                insn.setFieldType(ValueType.parse(this.symbolTable.at(input.readInt())));
                return insn;
            }
            case 26: {
                PutFieldInstruction insn = new PutFieldInstruction();
                insn.setInstance(program.variableAt(input.readShort()));
                String className = this.symbolTable.at(input.readInt());
                String fieldName = this.symbolTable.at(input.readInt());
                ValueType type = ValueType.parse(this.symbolTable.at(input.readInt()));
                insn.setField(new FieldReference(className, fieldName));
                insn.setValue(program.variableAt(input.readShort()));
                insn.setFieldType(type);
                return insn;
            }
            case 27: {
                PutFieldInstruction insn = new PutFieldInstruction();
                String className = this.symbolTable.at(input.readInt());
                String fieldName = this.symbolTable.at(input.readInt());
                ValueType type = ValueType.parse(this.symbolTable.at(input.readInt()));
                insn.setField(new FieldReference(className, fieldName));
                insn.setValue(program.variableAt(input.readShort()));
                insn.setFieldType(type);
                return insn;
            }
            case 28: {
                ArrayLengthInstruction insn = new ArrayLengthInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                insn.setArray(program.variableAt(input.readShort()));
                return insn;
            }
            case 29: {
                CloneArrayInstruction insn = new CloneArrayInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                insn.setArray(program.variableAt(input.readShort()));
                return insn;
            }
            case 30: {
                Variable receiver = program.variableAt(input.readShort());
                UnwrapArrayInstruction insn = new UnwrapArrayInstruction(arrayElementTypes[input.readByte()]);
                insn.setReceiver(receiver);
                insn.setArray(program.variableAt(input.readShort()));
                return insn;
            }
            case 31: {
                GetElementInstruction insn = new GetElementInstruction(arrayElementTypes[input.readByte()]);
                insn.setReceiver(program.variableAt(input.readShort()));
                insn.setArray(program.variableAt(input.readShort()));
                insn.setIndex(program.variableAt(input.readShort()));
                return insn;
            }
            case 32: {
                PutElementInstruction insn = new PutElementInstruction(arrayElementTypes[input.readByte()]);
                insn.setArray(program.variableAt(input.readShort()));
                insn.setIndex(program.variableAt(input.readShort()));
                insn.setValue(program.variableAt(input.readShort()));
                return insn;
            }
            case 33: {
                InvokeInstruction insn = new InvokeInstruction();
                insn.setType(InvocationType.SPECIAL);
                short receiverIndex = input.readShort();
                insn.setReceiver(receiverIndex >= 0 ? program.variableAt(receiverIndex) : null);
                String className = this.symbolTable.at(input.readInt());
                MethodDescriptor methodDesc = MethodDescriptor.parse(this.symbolTable.at(input.readInt()));
                insn.setMethod(new MethodReference(className, methodDesc));
                int paramCount = insn.getMethod().getDescriptor().parameterCount();
                for (int i = 0; i < paramCount; ++i) {
                    insn.getArguments().add(program.variableAt(input.readShort()));
                }
                return insn;
            }
            case 34: {
                InvokeInstruction insn = new InvokeInstruction();
                insn.setType(InvocationType.SPECIAL);
                short receiverIndex = input.readShort();
                insn.setReceiver(receiverIndex >= 0 ? program.variableAt(receiverIndex) : null);
                insn.setInstance(program.variableAt(input.readShort()));
                String className = this.symbolTable.at(input.readInt());
                MethodDescriptor methodDesc = MethodDescriptor.parse(this.symbolTable.at(input.readInt()));
                insn.setMethod(new MethodReference(className, methodDesc));
                int paramCount = insn.getMethod().getDescriptor().parameterCount();
                for (int i = 0; i < paramCount; ++i) {
                    insn.getArguments().add(program.variableAt(input.readShort()));
                }
                return insn;
            }
            case 35: {
                InvokeInstruction insn = new InvokeInstruction();
                insn.setType(InvocationType.VIRTUAL);
                short receiverIndex = input.readShort();
                insn.setReceiver(receiverIndex >= 0 ? program.variableAt(receiverIndex) : null);
                insn.setInstance(program.variableAt(input.readShort()));
                String className = this.symbolTable.at(input.readInt());
                MethodDescriptor methodDesc = MethodDescriptor.parse(this.symbolTable.at(input.readInt()));
                insn.setMethod(new MethodReference(className, methodDesc));
                int paramCount = insn.getMethod().getDescriptor().parameterCount();
                for (int i = 0; i < paramCount; ++i) {
                    insn.getArguments().add(program.variableAt(input.readShort()));
                }
                return insn;
            }
            case 36: {
                IsInstanceInstruction insn = new IsInstanceInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                insn.setType(ValueType.parse(this.symbolTable.at(input.readInt())));
                insn.setValue(program.variableAt(input.readShort()));
                return insn;
            }
            case 37: {
                InitClassInstruction insn = new InitClassInstruction();
                insn.setClassName(this.symbolTable.at(input.readInt()));
                return insn;
            }
            case 38: {
                NullCheckInstruction insn = new NullCheckInstruction();
                insn.setReceiver(program.variableAt(input.readShort()));
                insn.setValue(program.variableAt(input.readShort()));
                return insn;
            }
            case 39: {
                MonitorEnterInstruction insn = new MonitorEnterInstruction();
                insn.setObjectRef(program.variableAt(input.readShort()));
                return insn;
            }
            case 40: {
                MonitorExitInstruction insn = new MonitorExitInstruction();
                insn.setObjectRef(program.variableAt(input.readShort()));
                return insn;
            }
            case 41: {
                InvokeDynamicInstruction insn = new InvokeDynamicInstruction();
                short receiver = input.readShort();
                short instance = input.readShort();
                insn.setReceiver(receiver >= 0 ? program.variableAt(receiver) : null);
                insn.setInstance(instance >= 0 ? program.variableAt(instance) : null);
                insn.setMethod(MethodDescriptor.parse(this.symbolTable.at(input.readInt())));
                int argsCount = insn.getMethod().parameterCount();
                for (int i = 0; i < argsCount; ++i) {
                    insn.getArguments().add(program.variableAt(input.readShort()));
                }
                insn.setBootstrapMethod(this.readMethodHandle(input));
                int bootstrapArgsCount = input.readByte();
                for (int i = 0; i < bootstrapArgsCount; ++i) {
                    insn.getBootstrapArguments().add(this.readRuntimeConstant(input));
                }
                return insn;
            }
        }
        throw new RuntimeException("Unknown instruction type: " + insnType);
    }

    private MethodHandle readMethodHandle(DataInput input) throws IOException {
        byte kind = input.readByte();
        switch (kind) {
            case 0: {
                return MethodHandle.fieldGetter(this.symbolTable.at(input.readInt()), this.symbolTable.at(input.readInt()), ValueType.parse(this.symbolTable.at(input.readInt())));
            }
            case 1: {
                return MethodHandle.staticFieldGetter(this.symbolTable.at(input.readInt()), this.symbolTable.at(input.readInt()), ValueType.parse(this.symbolTable.at(input.readInt())));
            }
            case 2: {
                return MethodHandle.fieldSetter(this.symbolTable.at(input.readInt()), this.symbolTable.at(input.readInt()), ValueType.parse(this.symbolTable.at(input.readInt())));
            }
            case 3: {
                return MethodHandle.staticFieldSetter(this.symbolTable.at(input.readInt()), this.symbolTable.at(input.readInt()), ValueType.parse(this.symbolTable.at(input.readInt())));
            }
            case 4: {
                return MethodHandle.virtualCaller(this.symbolTable.at(input.readInt()), MethodDescriptor.parse(this.symbolTable.at(input.readInt())));
            }
            case 5: {
                return MethodHandle.staticCaller(this.symbolTable.at(input.readInt()), MethodDescriptor.parse(this.symbolTable.at(input.readInt())));
            }
            case 6: {
                return MethodHandle.specialCaller(this.symbolTable.at(input.readInt()), MethodDescriptor.parse(this.symbolTable.at(input.readInt())));
            }
            case 7: {
                return MethodHandle.constructorCaller(this.symbolTable.at(input.readInt()), MethodDescriptor.parse(this.symbolTable.at(input.readInt())));
            }
            case 8: {
                return MethodHandle.interfaceCaller(this.symbolTable.at(input.readInt()), MethodDescriptor.parse(this.symbolTable.at(input.readInt())));
            }
        }
        throw new IllegalArgumentException("Unexpected method handle type: " + kind);
    }

    private RuntimeConstant readRuntimeConstant(DataInput input) throws IOException {
        byte kind = input.readByte();
        switch (kind) {
            case 0: {
                return new RuntimeConstant(input.readInt());
            }
            case 1: {
                return new RuntimeConstant(input.readLong());
            }
            case 2: {
                return new RuntimeConstant(input.readFloat());
            }
            case 3: {
                return new RuntimeConstant(input.readDouble());
            }
            case 4: {
                return new RuntimeConstant(input.readUTF());
            }
            case 5: {
                return new RuntimeConstant(ValueType.parse(this.symbolTable.at(input.readInt())));
            }
            case 6: {
                return new RuntimeConstant(MethodDescriptor.parseSignature(this.symbolTable.at(input.readInt())));
            }
            case 7: {
                return new RuntimeConstant(this.readMethodHandle(input));
            }
        }
        throw new IllegalArgumentException("Unexpected runtime constant type: " + kind);
    }

    private static class IOExceptionWrapper
    extends RuntimeException {
        private static final long serialVersionUID = -1765050162629001951L;

        public IOExceptionWrapper(Throwable cause) {
            super(cause);
        }
    }

    private class InstructionWriter
    implements InstructionVisitor {
        private DataOutput output;

        public InstructionWriter(DataOutput output) {
            this.output = output;
        }

        @Override
        public void visit(EmptyInstruction insn) {
            try {
                this.output.writeByte(0);
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ClassConstantInstruction insn) {
            try {
                this.output.writeByte(1);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeInt(ProgramIO.this.symbolTable.lookup(insn.getConstant().toString()));
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(NullConstantInstruction insn) {
            try {
                this.output.writeByte(2);
                this.output.writeShort(insn.getReceiver().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(IntegerConstantInstruction insn) {
            try {
                this.output.writeByte(3);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeInt(insn.getConstant());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(LongConstantInstruction insn) {
            try {
                this.output.writeByte(4);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeLong(insn.getConstant());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(FloatConstantInstruction insn) {
            try {
                this.output.writeByte(5);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeFloat(insn.getConstant());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(DoubleConstantInstruction insn) {
            try {
                this.output.writeByte(6);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeDouble(insn.getConstant());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(StringConstantInstruction insn) {
            try {
                this.output.writeByte(7);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeUTF(insn.getConstant());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(BinaryInstruction insn) {
            try {
                this.output.writeByte(8);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeByte(insn.getOperation().ordinal());
                this.output.writeByte(insn.getOperandType().ordinal());
                this.output.writeShort(insn.getFirstOperand().getIndex());
                this.output.writeShort(insn.getSecondOperand().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(NegateInstruction insn) {
            try {
                this.output.writeByte(9);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeByte(insn.getOperandType().ordinal());
                this.output.writeShort(insn.getOperand().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(AssignInstruction insn) {
            try {
                this.output.writeByte(10);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeShort(insn.getAssignee().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(CastInstruction insn) {
            try {
                this.output.writeByte(11);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeInt(ProgramIO.this.symbolTable.lookup(insn.getTargetType().toString()));
                this.output.writeShort(insn.getValue().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(CastNumberInstruction insn) {
            try {
                this.output.writeByte(12);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeByte(insn.getSourceType().ordinal());
                this.output.writeByte(insn.getTargetType().ordinal());
                this.output.writeShort(insn.getValue().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(CastIntegerInstruction insn) {
            try {
                this.output.writeByte(13);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeByte(insn.getTargetType().ordinal());
                this.output.writeByte(insn.getDirection().ordinal());
                this.output.writeShort(insn.getValue().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(BranchingInstruction insn) {
            try {
                this.output.writeByte(14);
                this.output.writeByte(insn.getCondition().ordinal());
                this.output.writeShort(insn.getOperand().getIndex());
                this.output.writeShort(insn.getConsequent().getIndex());
                this.output.writeShort(insn.getAlternative().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(BinaryBranchingInstruction insn) {
            try {
                this.output.writeByte(15);
                this.output.writeByte(insn.getCondition().ordinal());
                this.output.writeShort(insn.getFirstOperand().getIndex());
                this.output.writeShort(insn.getSecondOperand().getIndex());
                this.output.writeShort(insn.getConsequent().getIndex());
                this.output.writeShort(insn.getAlternative().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(JumpInstruction insn) {
            try {
                this.output.writeByte(16);
                this.output.writeShort(insn.getTarget().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(SwitchInstruction insn) {
            try {
                this.output.writeByte(17);
                this.output.writeShort(insn.getCondition().getIndex());
                this.output.writeShort(insn.getDefaultTarget().getIndex());
                this.output.writeShort(insn.getEntries().size());
                for (SwitchTableEntry entry : insn.getEntries()) {
                    this.output.writeInt(entry.getCondition());
                    this.output.writeShort(entry.getTarget().getIndex());
                }
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ExitInstruction insn) {
            try {
                if (insn.getValueToReturn() != null) {
                    this.output.writeByte(18);
                    this.output.writeShort(insn.getValueToReturn() != null ? insn.getValueToReturn().getIndex() : -1);
                } else {
                    this.output.writeByte(19);
                }
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(RaiseInstruction insn) {
            try {
                this.output.writeByte(20);
                this.output.writeShort(insn.getException().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ConstructArrayInstruction insn) {
            try {
                this.output.writeByte(21);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeInt(ProgramIO.this.symbolTable.lookup(insn.getItemType().toString()));
                this.output.writeShort(insn.getSize().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ConstructInstruction insn) {
            try {
                this.output.writeByte(22);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeInt(ProgramIO.this.symbolTable.lookup(insn.getType()));
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ConstructMultiArrayInstruction insn) {
            try {
                this.output.writeByte(23);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeInt(ProgramIO.this.symbolTable.lookup(insn.getItemType().toString()));
                this.output.writeByte(insn.getDimensions().size());
                for (Variable dimension : insn.getDimensions()) {
                    this.output.writeShort(dimension.getIndex());
                }
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(GetFieldInstruction insn) {
            try {
                this.output.writeByte(insn.getInstance() != null ? 24 : 25);
                this.output.writeShort(insn.getReceiver().getIndex());
                if (insn.getInstance() != null) {
                    this.output.writeShort(insn.getInstance().getIndex());
                }
                this.output.writeInt(ProgramIO.this.symbolTable.lookup(insn.getField().getClassName()));
                this.output.writeInt(ProgramIO.this.symbolTable.lookup(insn.getField().getFieldName()));
                this.output.writeInt(ProgramIO.this.symbolTable.lookup(insn.getFieldType().toString()));
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(PutFieldInstruction insn) {
            try {
                this.output.writeByte(insn.getInstance() != null ? 26 : 27);
                if (insn.getInstance() != null) {
                    this.output.writeShort(insn.getInstance().getIndex());
                }
                this.output.writeInt(ProgramIO.this.symbolTable.lookup(insn.getField().getClassName()));
                this.output.writeInt(ProgramIO.this.symbolTable.lookup(insn.getField().getFieldName()));
                this.output.writeInt(ProgramIO.this.symbolTable.lookup(insn.getFieldType().toString()));
                this.output.writeShort(insn.getValue().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(ArrayLengthInstruction insn) {
            try {
                this.output.writeByte(28);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeShort(insn.getArray().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(CloneArrayInstruction insn) {
            try {
                this.output.writeByte(29);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeShort(insn.getArray().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(UnwrapArrayInstruction insn) {
            try {
                this.output.writeByte(30);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeByte(insn.getElementType().ordinal());
                this.output.writeShort(insn.getArray().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(GetElementInstruction insn) {
            try {
                this.output.writeByte(31);
                this.output.writeByte(insn.getType().ordinal());
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeShort(insn.getArray().getIndex());
                this.output.writeShort(insn.getIndex().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(PutElementInstruction insn) {
            try {
                this.output.writeByte(32);
                this.output.writeByte(insn.getType().ordinal());
                this.output.writeShort(insn.getArray().getIndex());
                this.output.writeShort(insn.getIndex().getIndex());
                this.output.writeShort(insn.getValue().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(InvokeInstruction insn) {
            try {
                switch (insn.getType()) {
                    case SPECIAL: {
                        this.output.write(insn.getInstance() == null ? 33 : 34);
                        break;
                    }
                    case VIRTUAL: {
                        this.output.write(35);
                    }
                }
                this.output.writeShort(insn.getReceiver() != null ? insn.getReceiver().getIndex() : -1);
                if (insn.getInstance() != null) {
                    this.output.writeShort(insn.getInstance().getIndex());
                }
                this.output.writeInt(ProgramIO.this.symbolTable.lookup(insn.getMethod().getClassName()));
                this.output.writeInt(ProgramIO.this.symbolTable.lookup(insn.getMethod().getDescriptor().toString()));
                for (int i = 0; i < insn.getArguments().size(); ++i) {
                    this.output.writeShort(insn.getArguments().get(i).getIndex());
                }
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(InvokeDynamicInstruction insn) {
            try {
                int i;
                this.output.writeByte(41);
                this.output.writeShort(insn.getReceiver() != null ? insn.getReceiver().getIndex() : -1);
                this.output.writeShort(insn.getInstance() != null ? insn.getInstance().getIndex() : -1);
                this.output.writeInt(ProgramIO.this.symbolTable.lookup(insn.getMethod().toString()));
                for (i = 0; i < insn.getArguments().size(); ++i) {
                    this.output.writeShort(insn.getArguments().get(i).getIndex());
                }
                this.write(insn.getBootstrapMethod());
                this.output.writeByte(insn.getBootstrapArguments().size());
                for (i = 0; i < insn.getBootstrapArguments().size(); ++i) {
                    this.write(insn.getBootstrapArguments().get(i));
                }
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(IsInstanceInstruction insn) {
            try {
                this.output.writeByte(36);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeInt(ProgramIO.this.symbolTable.lookup(insn.getType().toString()));
                this.output.writeShort(insn.getValue().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(InitClassInstruction insn) {
            try {
                this.output.writeByte(37);
                this.output.writeInt(ProgramIO.this.symbolTable.lookup(insn.getClassName()));
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(NullCheckInstruction insn) {
            try {
                this.output.writeByte(38);
                this.output.writeShort(insn.getReceiver().getIndex());
                this.output.writeShort(insn.getValue().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(MonitorEnterInstruction insn) {
            try {
                this.output.writeByte(39);
                this.output.writeShort(insn.getObjectRef().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        @Override
        public void visit(MonitorExitInstruction insn) {
            try {
                this.output.writeByte(40);
                this.output.writeShort(insn.getObjectRef().getIndex());
            }
            catch (IOException e) {
                throw new IOExceptionWrapper(e);
            }
        }

        private void write(MethodHandle handle) throws IOException {
            switch (handle.getKind()) {
                case GET_FIELD: {
                    this.output.writeByte(0);
                    break;
                }
                case GET_STATIC_FIELD: {
                    this.output.writeByte(1);
                    break;
                }
                case PUT_FIELD: {
                    this.output.writeByte(2);
                    break;
                }
                case PUT_STATIC_FIELD: {
                    this.output.writeByte(3);
                    break;
                }
                case INVOKE_VIRTUAL: {
                    this.output.writeByte(4);
                    break;
                }
                case INVOKE_STATIC: {
                    this.output.writeByte(5);
                    break;
                }
                case INVOKE_SPECIAL: {
                    this.output.writeByte(6);
                    break;
                }
                case INVOKE_CONSTRUCTOR: {
                    this.output.writeByte(7);
                    break;
                }
                case INVOKE_INTERFACE: {
                    this.output.writeByte(8);
                }
            }
            this.output.writeInt(ProgramIO.this.symbolTable.lookup(handle.getClassName()));
            switch (handle.getKind()) {
                case GET_FIELD: 
                case GET_STATIC_FIELD: 
                case PUT_FIELD: 
                case PUT_STATIC_FIELD: {
                    this.output.writeInt(ProgramIO.this.symbolTable.lookup(handle.getName()));
                    this.output.writeInt(ProgramIO.this.symbolTable.lookup(handle.getValueType().toString()));
                    break;
                }
                default: {
                    this.output.writeInt(ProgramIO.this.symbolTable.lookup(new MethodDescriptor(handle.getName(), handle.signature()).toString()));
                }
            }
        }

        private void write(RuntimeConstant cst) throws IOException {
            switch (cst.getKind()) {
                case 0: {
                    this.output.writeByte(0);
                    this.output.writeInt(cst.getInt());
                    break;
                }
                case 1: {
                    this.output.writeByte(1);
                    this.output.writeLong(cst.getLong());
                    break;
                }
                case 2: {
                    this.output.writeByte(2);
                    this.output.writeFloat(cst.getFloat());
                    break;
                }
                case 3: {
                    this.output.writeByte(3);
                    this.output.writeDouble(cst.getDouble());
                    break;
                }
                case 4: {
                    this.output.writeByte(4);
                    this.output.writeUTF(cst.getString());
                    break;
                }
                case 5: {
                    this.output.writeByte(5);
                    this.output.writeInt(ProgramIO.this.symbolTable.lookup(cst.getValueType().toString()));
                    break;
                }
                case 6: {
                    this.output.writeByte(6);
                    this.output.writeInt(ProgramIO.this.symbolTable.lookup(ValueType.methodTypeToString(cst.getMethodType())));
                    break;
                }
                case 7: {
                    this.output.writeByte(7);
                    this.write(cst.getMethodHandle());
                }
            }
        }
    }
}

