/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.teavm.ast.AsyncMethodNode;
import org.teavm.ast.AsyncMethodPart;
import org.teavm.ast.InvocationExpr;
import org.teavm.ast.MethodNode;
import org.teavm.ast.QualificationExpr;
import org.teavm.ast.RecursiveVisitor;
import org.teavm.ast.RegularMethodNode;
import org.teavm.ast.cache.MethodNodeCache;
import org.teavm.cache.AstIO;
import org.teavm.cache.FileNameEncoder;
import org.teavm.cache.SymbolTable;
import org.teavm.model.MethodReference;
import org.teavm.parsing.ClassDateProvider;

public class DiskRegularMethodNodeCache
implements MethodNodeCache {
    private final File directory;
    private final AstIO astIO;
    private final ClassDateProvider classDateProvider;
    private final Map<MethodReference, Item> cache = new HashMap<MethodReference, Item>();
    private final Map<MethodReference, AsyncItem> asyncCache = new HashMap<MethodReference, AsyncItem>();
    private final Set<MethodReference> newMethods = new HashSet<MethodReference>();
    private final Set<MethodReference> newAsyncMethods = new HashSet<MethodReference>();

    public DiskRegularMethodNodeCache(File directory, SymbolTable symbolTable, SymbolTable fileTable, ClassDateProvider classDateProvider) {
        this.directory = directory;
        this.astIO = new AstIO(symbolTable, fileTable);
        this.classDateProvider = classDateProvider;
    }

    @Override
    public RegularMethodNode get(MethodReference methodReference) {
        Item item = this.cache.get(methodReference);
        if (item == null) {
            item = new Item();
            this.cache.put(methodReference, item);
            File file = this.getMethodFile(methodReference, false);
            if (file.exists()) {
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                    DataInputStream input = new DataInputStream(stream);
                    if (!this.checkIfDependenciesChanged(input, file)) {
                        item.node = this.astIO.read(input, methodReference);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return item.node;
    }

    @Override
    public void store(MethodReference methodReference, RegularMethodNode node) {
        Item item = new Item();
        item.node = node;
        this.cache.put(methodReference, item);
        this.newMethods.add(methodReference);
    }

    @Override
    public AsyncMethodNode getAsync(MethodReference methodReference) {
        AsyncItem item = this.asyncCache.get(methodReference);
        if (item == null) {
            item = new AsyncItem();
            this.asyncCache.put(methodReference, item);
            File file = this.getMethodFile(methodReference, true);
            if (file.exists()) {
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                    DataInputStream input = new DataInputStream(stream);
                    if (!this.checkIfDependenciesChanged(input, file)) {
                        item.node = this.astIO.readAsync(input, methodReference);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return item.node;
    }

    private boolean checkIfDependenciesChanged(DataInput input, File file) throws IOException {
        int depCount = input.readShort();
        for (int i = 0; i < depCount; ++i) {
            String depClass = input.readUTF();
            Date depDate = this.classDateProvider.getModificationDate(depClass);
            if (depDate != null && !depDate.after(new Date(file.lastModified()))) continue;
            return true;
        }
        return false;
    }

    @Override
    public void storeAsync(MethodReference methodReference, AsyncMethodNode node) {
        AsyncItem item = new AsyncItem();
        item.node = node;
        this.asyncCache.put(methodReference, item);
        this.newAsyncMethods.add(methodReference);
    }

    public void flush() throws IOException {
        Throwable throwable;
        Object output;
        MethodNode node;
        AstDependencyAnalyzer analyzer;
        File file;
        for (MethodReference method : this.newMethods) {
            file = this.getMethodFile(method, true);
            analyzer = new AstDependencyAnalyzer();
            node = this.cache.get((Object)method).node;
            ((RegularMethodNode)node).getBody().acceptVisitor(analyzer);
            analyzer.dependencies.add(method.getClassName());
            output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            throwable = null;
            try {
                ((DataOutputStream)output).writeShort(analyzer.dependencies.size());
                for (String dependency : analyzer.dependencies) {
                    ((DataOutputStream)output).writeUTF(dependency);
                }
                this.astIO.write((DataOutput)output, (RegularMethodNode)node);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (output == null) continue;
                if (throwable != null) {
                    try {
                        ((FilterOutputStream)output).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((FilterOutputStream)output).close();
            }
        }
        for (MethodReference method : this.newAsyncMethods) {
            file = this.getMethodFile(method, true);
            analyzer = new AstDependencyAnalyzer();
            node = this.asyncCache.get((Object)method).node;
            for (AsyncMethodPart part : ((AsyncMethodNode)node).getBody()) {
                part.getStatement().acceptVisitor(analyzer);
            }
            analyzer.dependencies.add(method.getClassName());
            output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            throwable = null;
            try {
                ((DataOutputStream)output).writeShort(analyzer.dependencies.size());
                for (String dependency : analyzer.dependencies) {
                    ((DataOutputStream)output).writeUTF(dependency);
                }
                this.astIO.writeAsync((DataOutput)output, (AsyncMethodNode)node);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (output == null) continue;
                if (throwable != null) {
                    try {
                        ((FilterOutputStream)output).close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                ((FilterOutputStream)output).close();
            }
        }
    }

    private File getMethodFile(MethodReference method, boolean async) {
        File dir = new File(this.directory, method.getClassName().replace('.', '/'));
        return new File(dir, FileNameEncoder.encodeFileName(method.getDescriptor().toString()) + ".teavm-ast" + (async ? "-async" : ""));
    }

    private static class AsyncItem {
        AsyncMethodNode node;

        private AsyncItem() {
        }
    }

    private static class Item {
        RegularMethodNode node;

        private Item() {
        }
    }

    private static class AstDependencyAnalyzer
    extends RecursiveVisitor {
        final Set<String> dependencies = new HashSet<String>();

        private AstDependencyAnalyzer() {
        }

        @Override
        public void visit(InvocationExpr expr) {
            super.visit(expr);
            this.dependencies.add(expr.getMethod().getClassName());
        }

        @Override
        public void visit(QualificationExpr expr) {
            super.visit(expr);
            this.dependencies.add(expr.getField().getClassName());
        }
    }
}

