/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.generate;

import org.teavm.ast.RegularMethodNode;
import org.teavm.ast.VariableNode;
import org.teavm.ast.decompilation.Decompiler;
import org.teavm.backend.wasm.binary.BinaryWriter;
import org.teavm.backend.wasm.generate.WasmClassGenerator;
import org.teavm.backend.wasm.generate.WasmGenerationContext;
import org.teavm.backend.wasm.generate.WasmGenerationVisitor;
import org.teavm.backend.wasm.generate.WasmGeneratorUtil;
import org.teavm.backend.wasm.generate.WasmMangling;
import org.teavm.backend.wasm.model.WasmFunction;
import org.teavm.backend.wasm.model.WasmLocal;
import org.teavm.backend.wasm.model.WasmType;
import org.teavm.backend.wasm.model.expression.WasmBlock;
import org.teavm.interop.Export;
import org.teavm.model.AnnotationHolder;
import org.teavm.model.ClassHolder;
import org.teavm.model.ClassHolderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class WasmGenerator {
    private Decompiler decompiler;
    private ClassHolderSource classSource;
    private WasmGenerationContext context;
    private WasmClassGenerator classGenerator;
    private BinaryWriter binaryWriter;

    public WasmGenerator(Decompiler decompiler, ClassHolderSource classSource, WasmGenerationContext context, WasmClassGenerator classGenerator, BinaryWriter binaryWriter) {
        this.decompiler = decompiler;
        this.classSource = classSource;
        this.context = context;
        this.classGenerator = classGenerator;
        this.binaryWriter = binaryWriter;
    }

    public WasmFunction generateDefinition(MethodReference methodReference) {
        ClassHolder cls = this.classSource.get(methodReference.getClassName());
        MethodHolder method = cls.getMethod(methodReference.getDescriptor());
        WasmFunction function = new WasmFunction(WasmMangling.mangleMethod(method.getReference()));
        if (!method.hasModifier(ElementModifier.STATIC)) {
            function.getParameters().add(WasmType.INT32);
        }
        for (int i = 0; i < method.parameterCount(); ++i) {
            function.getParameters().add(WasmGeneratorUtil.mapType(method.parameterType(i)));
        }
        if (method.getResultType() != ValueType.VOID) {
            function.setResult(WasmGeneratorUtil.mapType(method.getResultType()));
        }
        return function;
    }

    public WasmFunction generate(MethodReference methodReference, MethodHolder bodyMethod) {
        int firstVariable;
        ClassHolder cls = this.classSource.get(methodReference.getClassName());
        MethodHolder method = cls.getMethod(methodReference.getDescriptor());
        RegularMethodNode methodAst = this.decompiler.decompileRegular(bodyMethod);
        WasmFunction function = this.context.getFunction(WasmMangling.mangleMethod(methodReference));
        for (int i = firstVariable = method.hasModifier(ElementModifier.STATIC) ? 1 : 0; i < methodAst.getVariables().size(); ++i) {
            VariableNode variable = methodAst.getVariables().get(i);
            WasmType type = variable.getType() != null ? WasmGeneratorUtil.mapType(variable.getType()) : WasmType.INT32;
            function.add(new WasmLocal(type, variable.getName()));
        }
        WasmGenerationVisitor visitor = new WasmGenerationVisitor(this.context, this.classGenerator, this.binaryWriter, function, firstVariable);
        methodAst.getBody().acceptVisitor(visitor);
        if (visitor.result instanceof WasmBlock) {
            ((WasmBlock)visitor.result).setType(function.getResult());
        }
        function.getBody().add(visitor.result);
        AnnotationHolder exportAnnot = method.getAnnotations().get(Export.class.getName());
        if (exportAnnot != null) {
            function.setExportName(exportAnnot.getValue("name").getString());
        }
        return function;
    }

    public WasmFunction generateNative(MethodReference methodReference) {
        WasmFunction function = this.context.getFunction(WasmMangling.mangleMethod(methodReference));
        WasmGenerationContext.ImportedMethod importedMethod = this.context.getImportedMethod(methodReference);
        if (importedMethod != null) {
            function.setImportName(importedMethod.name);
            function.setImportModule(importedMethod.module);
        } else {
            function.setImportName("<unknown>");
        }
        return function;
    }
}

