/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.lowlevel;

import java.util.ArrayList;
import java.util.List;
import org.teavm.model.BasicBlock;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.Incoming;
import org.teavm.model.Instruction;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.Phi;
import org.teavm.model.Program;
import org.teavm.model.Variable;
import org.teavm.model.instructions.ExitInstruction;
import org.teavm.model.instructions.IntegerConstantInstruction;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.InvokeInstruction;
import org.teavm.model.instructions.JumpInstruction;
import org.teavm.model.lowlevel.CallSiteDescriptor;
import org.teavm.model.lowlevel.ExceptionHandlingShadowStackContributor;
import org.teavm.model.lowlevel.GCShadowStackContributor;
import org.teavm.model.lowlevel.ManagedMethodRepository;
import org.teavm.runtime.ShadowStack;

public class ShadowStackTransformer {
    private ManagedMethodRepository managedMethodRepository;
    private GCShadowStackContributor gcContributor;
    private List<CallSiteDescriptor> callSites = new ArrayList<CallSiteDescriptor>();

    public ShadowStackTransformer(ClassReaderSource classSource) {
        this.managedMethodRepository = new ManagedMethodRepository(classSource);
        this.gcContributor = new GCShadowStackContributor(this.managedMethodRepository);
    }

    public List<CallSiteDescriptor> getCallSites() {
        return this.callSites;
    }

    public void apply(Program program, MethodReader method) {
        if (!this.managedMethodRepository.isManaged(method.getReference())) {
            return;
        }
        int shadowStackSize = this.gcContributor.contribute(program, method);
        boolean exceptions = new ExceptionHandlingShadowStackContributor(this.managedMethodRepository, this.callSites, method.getReference(), program).contribute();
        if (shadowStackSize > 0 || exceptions) {
            this.addStackAllocation(program, shadowStackSize);
            this.addStackRelease(program, shadowStackSize);
        }
    }

    private void addStackAllocation(Program program, int maxDepth) {
        BasicBlock block = program.basicBlockAt(0);
        ArrayList<Instruction> instructionsToAdd = new ArrayList<Instruction>();
        Variable sizeVariable = program.createVariable();
        IntegerConstantInstruction sizeConstant = new IntegerConstantInstruction();
        sizeConstant.setReceiver(sizeVariable);
        sizeConstant.setConstant(maxDepth);
        instructionsToAdd.add(sizeConstant);
        InvokeInstruction invocation = new InvokeInstruction();
        invocation.setType(InvocationType.SPECIAL);
        invocation.setMethod(new MethodReference(ShadowStack.class, "allocStack", Integer.TYPE, Void.TYPE));
        invocation.getArguments().add(sizeVariable);
        instructionsToAdd.add(invocation);
        block.addFirstAll(instructionsToAdd);
    }

    private void addStackRelease(Program program, int maxDepth) {
        BasicBlock exitBlock;
        ArrayList<BasicBlock> blocks = new ArrayList<BasicBlock>();
        boolean hasResult = false;
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            BasicBlock block = program.basicBlockAt(i);
            Instruction instruction = block.getLastInstruction();
            if (!(instruction instanceof ExitInstruction)) continue;
            blocks.add(block);
            if (((ExitInstruction)instruction).getValueToReturn() == null) continue;
            hasResult = true;
        }
        if (blocks.size() == 1) {
            exitBlock = (BasicBlock)blocks.get(0);
        } else {
            exitBlock = program.createBasicBlock();
            ExitInstruction exit = new ExitInstruction();
            exitBlock.add(exit);
            if (hasResult) {
                Phi phi = new Phi();
                phi.setReceiver(program.createVariable());
                exitBlock.getPhis().add(phi);
                exit.setValueToReturn(phi.getReceiver());
                for (BasicBlock block : blocks) {
                    ExitInstruction oldExit = (ExitInstruction)block.getLastInstruction();
                    Incoming incoming = new Incoming();
                    incoming.setSource(block);
                    incoming.setValue(oldExit.getValueToReturn());
                    phi.getIncomings().add(incoming);
                }
            }
            for (BasicBlock block : blocks) {
                ExitInstruction oldExit = (ExitInstruction)block.getLastInstruction();
                JumpInstruction jumpToExit = new JumpInstruction();
                jumpToExit.setTarget(exitBlock);
                jumpToExit.setLocation(oldExit.getLocation());
                jumpToExit.setLocation(oldExit.getLocation());
                block.getLastInstruction().replace(jumpToExit);
            }
        }
        ArrayList<Instruction> instructionsToAdd = new ArrayList<Instruction>();
        Variable sizeVariable = program.createVariable();
        IntegerConstantInstruction sizeConstant = new IntegerConstantInstruction();
        sizeConstant.setReceiver(sizeVariable);
        sizeConstant.setConstant(maxDepth);
        instructionsToAdd.add(sizeConstant);
        InvokeInstruction invocation = new InvokeInstruction();
        invocation.setType(InvocationType.SPECIAL);
        invocation.setMethod(new MethodReference(ShadowStack.class, "releaseStack", Integer.TYPE, Void.TYPE));
        invocation.getArguments().add(sizeVariable);
        instructionsToAdd.add(invocation);
        exitBlock.getLastInstruction().insertPreviousAll(instructionsToAdd);
    }
}

