/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.backend.wasm.intrinsics;

import org.teavm.ast.InvocationExpr;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsic;
import org.teavm.backend.wasm.intrinsics.WasmIntrinsicManager;
import org.teavm.backend.wasm.model.expression.WasmExpression;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;

public class ClassIntrinsic
implements WasmIntrinsic {
    @Override
    public boolean isApplicable(MethodReference methodReference) {
        return methodReference.getClassName().equals("java.lang.Class") && this.isApplicableToMethod(methodReference.getDescriptor());
    }

    private boolean isApplicableToMethod(MethodDescriptor method) {
        return method.getName().equals("getClass") && method.parameterCount() == 1;
    }

    @Override
    public WasmExpression apply(InvocationExpr invocation, WasmIntrinsicManager manager) {
        switch (invocation.getMethod().getName()) {
            case "getClass": {
                return manager.generate(invocation.getArguments().get(0));
            }
        }
        throw new IllegalArgumentException(invocation.getMethod().toString());
    }
}

