/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling.sources;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.teavm.model.ClassReader;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodReader;
import org.teavm.tooling.EmptyTeaVMToolLog;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.tooling.sources.ProgramSourceAggregator;
import org.teavm.tooling.sources.SourceFileProvider;

public class SourceFilesCopier {
    private TeaVMToolLog log = new EmptyTeaVMToolLog();
    private List<SourceFileProvider> sourceFileProviders;
    private Set<String> sourceFiles = new HashSet<String>();

    public SourceFilesCopier(List<SourceFileProvider> sourceFileProviders) {
        this.sourceFileProviders = sourceFileProviders;
    }

    public void setLog(TeaVMToolLog log) {
        this.log = log;
    }

    public void addClasses(ListableClassReaderSource classReader) {
        ProgramSourceAggregator sourceAggregator = new ProgramSourceAggregator(this.sourceFiles);
        for (String className : classReader.getClassNames()) {
            ClassReader cls = classReader.get(className);
            for (MethodReader methodReader : cls.getMethods()) {
                if (methodReader.getProgram() == null) continue;
                sourceAggregator.addLocationsOfProgram(methodReader.getProgram());
            }
        }
    }

    public void copy(File targetDirectory) {
        for (SourceFileProvider provider : this.sourceFileProviders) {
            try {
                provider.open();
            }
            catch (IOException e) {
                this.log.warning("Error opening source file provider", e);
            }
        }
        targetDirectory.mkdirs();
        for (String fileName : this.sourceFiles) {
            try {
                InputStream input = this.findSourceFile(fileName);
                Throwable throwable = null;
                try {
                    if (input != null) {
                        File outputFile = new File(targetDirectory, fileName);
                        outputFile.getParentFile().mkdirs();
                        FileOutputStream output = new FileOutputStream(outputFile);
                        Throwable throwable2 = null;
                        try {
                            IOUtils.copy((InputStream)input, (OutputStream)output);
                            continue;
                        }
                        catch (Throwable throwable3) {
                            throwable2 = throwable3;
                            throw throwable3;
                        }
                        finally {
                            if (output == null) continue;
                            if (throwable2 != null) {
                                try {
                                    ((OutputStream)output).close();
                                }
                                catch (Throwable throwable4) {
                                    throwable2.addSuppressed(throwable4);
                                }
                                continue;
                            }
                            ((OutputStream)output).close();
                            continue;
                        }
                    }
                    this.log.info("Missing source file: " + fileName);
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (input == null) continue;
                    if (throwable != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    input.close();
                }
            }
            catch (IOException e) {
                this.log.warning("Could not copy source file " + fileName, e);
            }
        }
        for (SourceFileProvider provider : this.sourceFileProviders) {
            try {
                provider.close();
            }
            catch (IOException e) {
                this.log.warning("Error closing source file provider", e);
            }
        }
    }

    private InputStream findSourceFile(String fileName) throws IOException {
        for (SourceFileProvider provider : this.sourceFileProviders) {
            InputStream input = provider.openSourceFile(fileName);
            if (input == null) continue;
            return input;
        }
        return null;
    }
}

