/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import com.carrotsearch.hppc.IntIntMap;
import com.carrotsearch.hppc.IntIntOpenHashMap;
import org.teavm.common.GraphSplittingBackend;
import org.teavm.model.BasicBlock;
import org.teavm.model.Program;
import org.teavm.model.util.BasicBlockMapper;
import org.teavm.model.util.ProgramUtils;

public class ProgramNodeSplittingBackend
implements GraphSplittingBackend {
    private Program program;

    public ProgramNodeSplittingBackend(Program program) {
        this.program = program;
    }

    @Override
    public int[] split(int[] domain, int[] nodes) {
        int i;
        int[] copies = new int[nodes.length];
        IntIntOpenHashMap map = new IntIntOpenHashMap();
        for (int i2 = 0; i2 < nodes.length; ++i2) {
            int node = nodes[i2];
            BasicBlock block = this.program.basicBlockAt(node);
            BasicBlock blockCopy = this.program.createBasicBlock();
            blockCopy.getInstructions().addAll(ProgramUtils.copyInstructions(block, 0, block.getInstructions().size(), this.program));
            copies[i2] = blockCopy.getIndex();
            map.put(nodes[i2], copies[i2] + 1);
        }
        CopyBlockMapper copyBlockMapper = new CopyBlockMapper((IntIntMap)map);
        for (i = 0; i < copies.length; ++i) {
            copyBlockMapper.transform(this.program.basicBlockAt(copies[i]));
        }
        for (i = 0; i < domain.length; ++i) {
            copyBlockMapper.transform(this.program.basicBlockAt(domain[i]));
        }
        return copies;
    }

    private static class CopyBlockMapper
    extends BasicBlockMapper {
        private IntIntMap map;

        public CopyBlockMapper(IntIntMap map) {
            this.map = map;
        }

        @Override
        protected BasicBlock map(BasicBlock block) {
            int mappedIndex = this.map.get(block.getIndex());
            if (mappedIndex == 0) {
                return block;
            }
            return block.getProgram().basicBlockAt(mappedIndex - 1);
        }
    }
}

