/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.callgraph.CallGraph;
import org.teavm.callgraph.CallGraphNode;
import org.teavm.callgraph.CallSite;
import org.teavm.diagnostics.Diagnostics;
import org.teavm.javascript.spi.Async;
import org.teavm.javascript.spi.InjectedBy;
import org.teavm.javascript.spi.Sync;
import org.teavm.model.BasicBlockReader;
import org.teavm.model.CallLocation;
import org.teavm.model.ClassReader;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReference;
import org.teavm.model.InstructionLocation;
import org.teavm.model.ListableClassReaderSource;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHandle;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ProgramReader;
import org.teavm.model.RuntimeConstant;
import org.teavm.model.ValueType;
import org.teavm.model.VariableReader;
import org.teavm.model.instructions.ArrayElementType;
import org.teavm.model.instructions.BinaryBranchingCondition;
import org.teavm.model.instructions.BinaryOperation;
import org.teavm.model.instructions.BranchingCondition;
import org.teavm.model.instructions.CastIntegerDirection;
import org.teavm.model.instructions.InstructionReader;
import org.teavm.model.instructions.IntegerSubtype;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.NumericOperandType;
import org.teavm.model.instructions.SwitchTableEntryReader;

public class AsyncMethodFinder {
    private Set<MethodReference> asyncMethods = new HashSet<MethodReference>();
    private Map<MethodReference, Boolean> asyncFamilyMethods = new HashMap<MethodReference, Boolean>();
    private Set<MethodReference> readonlyAsyncMethods = Collections.unmodifiableSet(this.asyncMethods);
    private Set<MethodReference> readonlyAsyncFamilyMethods = Collections.unmodifiableSet(this.asyncFamilyMethods.keySet());
    private CallGraph callGraph;
    private Diagnostics diagnostics;
    private ListableClassReaderSource classSource;

    public AsyncMethodFinder(CallGraph callGraph, Diagnostics diagnostics) {
        this.callGraph = callGraph;
        this.diagnostics = diagnostics;
    }

    public Set<MethodReference> getAsyncMethods() {
        return this.readonlyAsyncMethods;
    }

    public Set<MethodReference> getAsyncFamilyMethods() {
        return this.readonlyAsyncFamilyMethods;
    }

    public void find(ListableClassReaderSource classSource) {
        ClassReader cls;
        this.classSource = classSource;
        for (String string : classSource.getClassNames()) {
            cls = classSource.get(string);
            for (MethodReader methodReader : cls.getMethods()) {
                if (this.asyncMethods.contains(methodReader.getReference()) || methodReader.getAnnotations().get(Async.class.getName()) == null) continue;
                this.add(methodReader.getReference());
            }
        }
        if (this.hasAsyncMethods()) {
            for (String string : classSource.getClassNames()) {
                cls = classSource.get(string);
                for (MethodReader methodReader : cls.getMethods()) {
                    if (this.asyncMethods.contains(methodReader.getReference()) || methodReader.getProgram() == null || !this.hasMonitor(methodReader)) continue;
                    this.add(methodReader.getReference());
                }
            }
        }
        for (MethodReference methodReference : this.asyncMethods) {
            this.addOverridenToFamily(methodReference);
        }
        for (String string : classSource.getClassNames()) {
            cls = classSource.get(string);
            for (MethodReader methodReader : cls.getMethods()) {
                this.addToFamily(methodReader.getReference());
            }
        }
        for (Map.Entry entry : new ArrayList<Map.Entry<MethodReference, Boolean>>(this.asyncFamilyMethods.entrySet())) {
            if (((Boolean)entry.getValue()).booleanValue()) continue;
            this.asyncFamilyMethods.remove(entry.getKey());
        }
    }

    private boolean hasAsyncMethods() {
        ClassReader cls;
        boolean result = false;
        block0: for (String clsName : this.classSource.getClassNames()) {
            ClassReader cls2 = this.classSource.get(clsName);
            for (MethodReader methodReader : cls2.getMethods()) {
                if (!this.asyncMethods.contains(methodReader.getReference()) || methodReader.getProgram() == null || !this.hasMonitor(methodReader)) continue;
                break block0;
            }
        }
        MethodReader method = (cls = this.classSource.get("java.lang.Thread")) != null ? cls.getMethod(new MethodDescriptor("start", Void.TYPE)) : null;
        return result && method != null;
    }

    private boolean hasMonitor(MethodReader method) {
        if (method.hasModifier(ElementModifier.SYNCHRONIZED)) {
            return true;
        }
        ProgramReader program = method.getProgram();
        AsyncInstructionReader insnReader = new AsyncInstructionReader();
        for (int i = 0; i < program.basicBlockCount(); ++i) {
            program.basicBlockAt(i).readAllInstructions(insnReader);
            if (!insnReader.async) continue;
            return true;
        }
        return false;
    }

    private void add(MethodReference methodRef) {
        if (!this.asyncMethods.add(methodRef)) {
            return;
        }
        CallGraphNode node = this.callGraph.getNode(methodRef);
        if (node == null) {
            return;
        }
        ClassReader cls = this.classSource.get(methodRef.getClassName());
        if (cls == null) {
            return;
        }
        MethodReader method = cls.getMethod(methodRef.getDescriptor());
        if (method == null) {
            return;
        }
        if (method.getAnnotations().get(Sync.class.getName()) != null || method.getAnnotations().get(InjectedBy.class.getName()) != null) {
            this.diagnostics.error(new CallLocation(methodRef), "Method {{m0}} is claimed to be synchronous, but it is has invocations of asynchronous methods", methodRef);
            return;
        }
        for (CallSite callSite : node.getCallerCallSites()) {
            this.add(callSite.getCaller().getMethod());
        }
    }

    private void addOverridenToFamily(MethodReference methodRef) {
        this.asyncFamilyMethods.put(methodRef, true);
        ClassReader cls = this.classSource.get(methodRef.getClassName());
        if (cls == null) {
            return;
        }
        for (MethodReference overridenMethod : this.findOverridenMethods(cls, methodRef)) {
            this.addOverridenToFamily(overridenMethod);
        }
    }

    private boolean addToFamily(MethodReference methodRef) {
        Boolean cachedResult = this.asyncFamilyMethods.get(methodRef);
        if (cachedResult != null) {
            return cachedResult;
        }
        boolean result = this.addToFamilyCacheMiss(methodRef);
        this.asyncFamilyMethods.put(methodRef, result);
        return result;
    }

    private boolean addToFamilyCacheMiss(MethodReference methodRef) {
        if (this.asyncMethods.contains(methodRef)) {
            return true;
        }
        ClassReader cls = this.classSource.get(methodRef.getClassName());
        if (cls == null) {
            return false;
        }
        for (MethodReference overridenMethod : this.findOverridenMethods(cls, methodRef)) {
            if (!this.addToFamily(overridenMethod)) continue;
            return true;
        }
        return false;
    }

    private Set<MethodReference> findOverridenMethods(ClassReader cls, MethodReference methodRef) {
        ArrayList<String> parents = new ArrayList<String>();
        if (cls.getParent() != null && !cls.getParent().equals(cls.getName())) {
            parents.add(cls.getParent());
        }
        parents.addAll(cls.getInterfaces());
        HashSet<MethodReference> visited = new HashSet<MethodReference>();
        HashSet<MethodReference> overriden = new HashSet<MethodReference>();
        for (String parent : parents) {
            this.findOverridenMethods(new MethodReference(parent, methodRef.getDescriptor()), overriden, visited);
        }
        return overriden;
    }

    private void findOverridenMethods(MethodReference methodRef, Set<MethodReference> result, Set<MethodReference> visited) {
        if (!visited.add(methodRef)) {
            return;
        }
        if (methodRef.getName().equals("<init>") || methodRef.getName().equals("<clinit>")) {
            return;
        }
        ClassReader cls = this.classSource.get(methodRef.getClassName());
        if (cls == null) {
            return;
        }
        MethodReader method = cls.getMethod(methodRef.getDescriptor());
        if (method != null) {
            if (!method.hasModifier(ElementModifier.STATIC) && !method.hasModifier(ElementModifier.FINAL)) {
                result.add(methodRef);
            }
        } else {
            if (cls.getParent() != null && !cls.getParent().equals(cls.getName())) {
                this.findOverridenMethods(new MethodReference(cls.getParent(), methodRef.getDescriptor()), result, visited);
            }
            for (String iface : cls.getInterfaces()) {
                this.findOverridenMethods(new MethodReference(iface, methodRef.getDescriptor()), result, visited);
            }
        }
    }

    class AsyncInstructionReader
    implements InstructionReader {
        boolean async;

        AsyncInstructionReader() {
        }

        @Override
        public void location(InstructionLocation location) {
        }

        @Override
        public void nop() {
        }

        @Override
        public void classConstant(VariableReader receiver, ValueType cst) {
        }

        @Override
        public void nullConstant(VariableReader receiver) {
        }

        @Override
        public void integerConstant(VariableReader receiver, int cst) {
        }

        @Override
        public void longConstant(VariableReader receiver, long cst) {
        }

        @Override
        public void floatConstant(VariableReader receiver, float cst) {
        }

        @Override
        public void doubleConstant(VariableReader receiver, double cst) {
        }

        @Override
        public void stringConstant(VariableReader receiver, String cst) {
        }

        @Override
        public void binary(BinaryOperation op, VariableReader receiver, VariableReader first, VariableReader second, NumericOperandType type) {
        }

        @Override
        public void negate(VariableReader receiver, VariableReader operand, NumericOperandType type) {
        }

        @Override
        public void assign(VariableReader receiver, VariableReader assignee) {
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, ValueType targetType) {
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, NumericOperandType sourceType, NumericOperandType targetType) {
        }

        @Override
        public void cast(VariableReader receiver, VariableReader value, IntegerSubtype type, CastIntegerDirection targetType) {
        }

        @Override
        public void jumpIf(BranchingCondition cond, VariableReader operand, BasicBlockReader consequent, BasicBlockReader alternative) {
        }

        @Override
        public void jumpIf(BinaryBranchingCondition cond, VariableReader first, VariableReader second, BasicBlockReader consequent, BasicBlockReader alternative) {
        }

        @Override
        public void jump(BasicBlockReader target) {
        }

        @Override
        public void choose(VariableReader condition, List<? extends SwitchTableEntryReader> table, BasicBlockReader defaultTarget) {
        }

        @Override
        public void exit(VariableReader valueToReturn) {
        }

        @Override
        public void raise(VariableReader exception) {
        }

        @Override
        public void createArray(VariableReader receiver, ValueType itemType, VariableReader size) {
        }

        @Override
        public void createArray(VariableReader receiver, ValueType itemType, List<? extends VariableReader> dimensions) {
        }

        @Override
        public void create(VariableReader receiver, String type) {
        }

        @Override
        public void getField(VariableReader receiver, VariableReader instance, FieldReference field, ValueType fieldType) {
        }

        @Override
        public void putField(VariableReader instance, FieldReference field, VariableReader value, ValueType fieldType) {
        }

        @Override
        public void arrayLength(VariableReader receiver, VariableReader array) {
        }

        @Override
        public void cloneArray(VariableReader receiver, VariableReader array) {
        }

        @Override
        public void unwrapArray(VariableReader receiver, VariableReader array, ArrayElementType elementType) {
        }

        @Override
        public void getElement(VariableReader receiver, VariableReader array, VariableReader index) {
        }

        @Override
        public void putElement(VariableReader array, VariableReader index, VariableReader value) {
        }

        @Override
        public void invoke(VariableReader receiver, VariableReader instance, MethodReference method, List<? extends VariableReader> arguments, InvocationType type) {
        }

        @Override
        public void invokeDynamic(VariableReader receiver, VariableReader instance, MethodDescriptor method, List<? extends VariableReader> arguments, MethodHandle bootstrapMethod, List<RuntimeConstant> bootstrapArguments) {
        }

        @Override
        public void isInstance(VariableReader receiver, VariableReader value, ValueType type) {
        }

        @Override
        public void initClass(String className) {
        }

        @Override
        public void nullCheck(VariableReader receiver, VariableReader value) {
        }

        @Override
        public void monitorEnter(VariableReader objectRef) {
            this.async = true;
        }

        @Override
        public void monitorExit(VariableReader objectRef) {
        }
    }
}

