/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.optimization;

import org.teavm.common.IntegerStack;
import org.teavm.model.BasicBlock;
import org.teavm.model.Program;
import org.teavm.model.TryCatchBlock;
import org.teavm.model.util.InstructionTransitionExtractor;

public class UnreachableBasicBlockEliminator {
    public void optimize(Program program) {
        BasicBlock block;
        int i;
        if (program.basicBlockCount() == 0) {
            return;
        }
        InstructionTransitionExtractor transitionExtractor = new InstructionTransitionExtractor();
        boolean[] reachable = new boolean[program.basicBlockCount()];
        IntegerStack stack = new IntegerStack(program.basicBlockCount());
        stack.push(0);
        while (!stack.isEmpty()) {
            i = stack.pop();
            if (reachable[i]) continue;
            reachable[i] = true;
            block = program.basicBlockAt(i);
            block.getLastInstruction().acceptVisitor(transitionExtractor);
            for (BasicBlock successor : transitionExtractor.getTargets()) {
                if (reachable[successor.getIndex()]) continue;
                stack.push(successor.getIndex());
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                stack.push(tryCatch.getHandler().getIndex());
            }
        }
        for (i = 0; i < reachable.length; ++i) {
            if (reachable[i]) continue;
            block = program.basicBlockAt(i);
            if (block.getLastInstruction() != null) {
                block.getLastInstruction().acceptVisitor(transitionExtractor);
                for (BasicBlock successor : transitionExtractor.getTargets()) {
                    successor.removeIncomingsFrom(block);
                }
            }
            for (TryCatchBlock tryCatch : block.getTryCatchBlocks()) {
                tryCatch.getHandler().removeIncomingsFrom(block);
            }
            program.deleteBasicBlock(i);
        }
        program.pack();
    }
}

