/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.vm;

import org.teavm.dependency.MethodDependency;
import org.teavm.model.MethodReference;

public class TeaVMEntryPoint {
    private String publicName;
    MethodReference reference;
    private MethodDependency method;
    private boolean async;

    TeaVMEntryPoint(String publicName, MethodReference reference, MethodDependency method) {
        this.publicName = publicName;
        this.reference = reference;
        this.method = method;
        method.use();
    }

    String getPublicName() {
        return this.publicName;
    }

    boolean isAsync() {
        return this.async;
    }

    public TeaVMEntryPoint withValue(int argument, String type) {
        if (argument > this.reference.parameterCount()) {
            throw new IllegalArgumentException("Illegal argument #" + argument + " of " + this.reference.parameterCount());
        }
        this.method.getVariable(argument).propagate(this.method.getDependencyAgent().getType(type));
        return this;
    }

    public TeaVMEntryPoint withArrayValue(int argument, String type) {
        if (argument > this.reference.parameterCount()) {
            throw new IllegalArgumentException("Illegal argument #" + argument + " of " + this.reference.parameterCount());
        }
        this.method.getVariable(argument).getArrayItem().propagate(this.method.getDependencyAgent().getType(type));
        return this;
    }

    public TeaVMEntryPoint async() {
        this.async = true;
        return this;
    }
}

