/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.parsing;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import org.teavm.parsing.ResourceProvider;

public class JarFileResourceProvider
implements ResourceProvider {
    private File file;

    public JarFileResourceProvider(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        this.file = file;
    }

    public JarFileResourceProvider(String fileName) {
        this(new File(fileName));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean hasResource(String name) {
        try (JarFile jar = new JarFile(this.file);){
            boolean bl = jar.getEntry(name) != null;
            return bl;
        }
        catch (FileNotFoundException ex) {
            throw new IllegalStateException("The underlying file does not exist", ex);
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error reading jar file", ex);
        }
    }

    @Override
    public InputStream openResource(String name) {
        try {
            ZipEntry entry;
            JarInputStream input = new JarInputStream(new FileInputStream(this.file));
            do {
                if ((entry = input.getNextEntry()) == null) {
                    input.close();
                    throw new IllegalArgumentException("Resource not found: " + name);
                }
                if (!entry.getName().equals(name)) continue;
                return input;
            } while (!name.startsWith("/") || !entry.getName().equals(name.substring(1)));
            return input;
        }
        catch (FileNotFoundException e) {
            throw new IllegalStateException("The underlying file does not exist");
        }
        catch (IOException e) {
            throw new IllegalStateException("Error reading jar file");
        }
    }
}

