/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model.instructions;

import java.util.List;
import org.teavm.model.BasicBlockReader;
import org.teavm.model.FieldReference;
import org.teavm.model.InstructionLocation;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodHandle;
import org.teavm.model.MethodReference;
import org.teavm.model.RuntimeConstant;
import org.teavm.model.ValueType;
import org.teavm.model.VariableReader;
import org.teavm.model.instructions.ArrayElementType;
import org.teavm.model.instructions.BinaryBranchingCondition;
import org.teavm.model.instructions.BinaryOperation;
import org.teavm.model.instructions.BranchingCondition;
import org.teavm.model.instructions.CastIntegerDirection;
import org.teavm.model.instructions.IntegerSubtype;
import org.teavm.model.instructions.InvocationType;
import org.teavm.model.instructions.NumericOperandType;
import org.teavm.model.instructions.SwitchTableEntryReader;

public interface InstructionReader {
    public void location(InstructionLocation var1);

    public void nop();

    public void classConstant(VariableReader var1, ValueType var2);

    public void nullConstant(VariableReader var1);

    public void integerConstant(VariableReader var1, int var2);

    public void longConstant(VariableReader var1, long var2);

    public void floatConstant(VariableReader var1, float var2);

    public void doubleConstant(VariableReader var1, double var2);

    public void stringConstant(VariableReader var1, String var2);

    public void binary(BinaryOperation var1, VariableReader var2, VariableReader var3, VariableReader var4, NumericOperandType var5);

    public void negate(VariableReader var1, VariableReader var2, NumericOperandType var3);

    public void assign(VariableReader var1, VariableReader var2);

    public void cast(VariableReader var1, VariableReader var2, ValueType var3);

    public void cast(VariableReader var1, VariableReader var2, NumericOperandType var3, NumericOperandType var4);

    public void cast(VariableReader var1, VariableReader var2, IntegerSubtype var3, CastIntegerDirection var4);

    public void jumpIf(BranchingCondition var1, VariableReader var2, BasicBlockReader var3, BasicBlockReader var4);

    public void jumpIf(BinaryBranchingCondition var1, VariableReader var2, VariableReader var3, BasicBlockReader var4, BasicBlockReader var5);

    public void jump(BasicBlockReader var1);

    public void choose(VariableReader var1, List<? extends SwitchTableEntryReader> var2, BasicBlockReader var3);

    public void exit(VariableReader var1);

    public void raise(VariableReader var1);

    public void createArray(VariableReader var1, ValueType var2, VariableReader var3);

    public void createArray(VariableReader var1, ValueType var2, List<? extends VariableReader> var3);

    public void create(VariableReader var1, String var2);

    public void getField(VariableReader var1, VariableReader var2, FieldReference var3, ValueType var4);

    public void putField(VariableReader var1, FieldReference var2, VariableReader var3, ValueType var4);

    public void arrayLength(VariableReader var1, VariableReader var2);

    public void cloneArray(VariableReader var1, VariableReader var2);

    public void unwrapArray(VariableReader var1, VariableReader var2, ArrayElementType var3);

    public void getElement(VariableReader var1, VariableReader var2, VariableReader var3);

    public void putElement(VariableReader var1, VariableReader var2, VariableReader var3);

    public void invoke(VariableReader var1, VariableReader var2, MethodReference var3, List<? extends VariableReader> var4, InvocationType var5);

    public void invokeDynamic(VariableReader var1, VariableReader var2, MethodDescriptor var3, List<? extends VariableReader> var4, MethodHandle var5, List<RuntimeConstant> var6);

    public void isInstance(VariableReader var1, VariableReader var2, ValueType var3);

    public void initClass(String var1);

    public void nullCheck(VariableReader var1, VariableReader var2);

    public void monitorEnter(VariableReader var1);

    public void monitorExit(VariableReader var1);
}

