/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import org.teavm.javascript.ast.BinaryExpr;
import org.teavm.javascript.ast.BinaryOperation;
import org.teavm.javascript.ast.Expr;
import org.teavm.javascript.ast.UnaryExpr;
import org.teavm.javascript.ast.UnaryOperation;

final class ExprOptimizer {
    private ExprOptimizer() {
    }

    public static Expr invert(Expr expr) {
        if (expr instanceof UnaryExpr) {
            UnaryExpr unary = (UnaryExpr)expr;
            if (unary.getOperation() == UnaryOperation.NOT) {
                return unary.getOperand();
            }
        } else if (expr instanceof BinaryExpr) {
            BinaryExpr binary = (BinaryExpr)expr;
            Expr a = binary.getFirstOperand();
            Expr b = binary.getSecondOperand();
            switch (binary.getOperation()) {
                case EQUALS: {
                    return Expr.binary(BinaryOperation.NOT_EQUALS, a, b, expr.getLocation());
                }
                case NOT_EQUALS: {
                    return Expr.binary(BinaryOperation.EQUALS, a, b, expr.getLocation());
                }
                case LESS: {
                    return Expr.binary(BinaryOperation.GREATER_OR_EQUALS, a, b, expr.getLocation());
                }
                case LESS_OR_EQUALS: {
                    return Expr.binary(BinaryOperation.GREATER, a, b);
                }
                case GREATER: {
                    return Expr.binary(BinaryOperation.LESS_OR_EQUALS, a, b, expr.getLocation());
                }
                case GREATER_OR_EQUALS: {
                    return Expr.binary(BinaryOperation.LESS, a, b, expr.getLocation());
                }
                case STRICT_EQUALS: {
                    return Expr.binary(BinaryOperation.STRICT_NOT_EQUALS, a, b, expr.getLocation());
                }
                case STRICT_NOT_EQUALS: {
                    return Expr.binary(BinaryOperation.STRICT_EQUALS, a, b, expr.getLocation());
                }
            }
        }
        return Expr.invert(expr);
    }
}

