/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.debugging.information;

import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.GeneratedLocation;

public class ClassNameIterator {
    private DebugInformation debugInformation;
    private int index;

    ClassNameIterator(DebugInformation debugInformation) {
        this.debugInformation = debugInformation;
    }

    public boolean isEndReached() {
        return this.index < this.debugInformation.classMapping.size();
    }

    public GeneratedLocation getLocation() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        return DebugInformation.key(this.debugInformation.classMapping.get(this.index));
    }

    public int getClassNameId() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        return this.debugInformation.classMapping.get(this.index).get(2);
    }

    public String getClassName() {
        int classNameId = this.getClassNameId();
        return classNameId >= 0 ? this.debugInformation.getClassName(classNameId) : null;
    }

    public void next() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        ++this.index;
    }
}

