/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.tooling;

import java.util.Iterator;
import org.teavm.callgraph.CallGraph;
import org.teavm.callgraph.CallGraphNode;
import org.teavm.callgraph.CallSite;
import org.teavm.diagnostics.DefaultProblemTextConsumer;
import org.teavm.diagnostics.Problem;
import org.teavm.model.CallLocation;
import org.teavm.model.InstructionLocation;
import org.teavm.model.MethodReference;
import org.teavm.tooling.TeaVMToolLog;
import org.teavm.vm.TeaVM;

public final class TeaVMProblemRenderer {
    private TeaVMProblemRenderer() {
    }

    public static void describeProblems(TeaVM vm, TeaVMToolLog log) {
        CallGraph cg = vm.getDependencyInfo().getCallGraph();
        DefaultProblemTextConsumer consumer = new DefaultProblemTextConsumer();
        for (Problem problem : vm.getProblemProvider().getProblems()) {
            consumer.clear();
            problem.render(consumer);
            StringBuilder sb = new StringBuilder();
            sb.append(consumer.getText());
            TeaVMProblemRenderer.renderCallStack(cg, problem.getLocation(), sb);
            String problemText = sb.toString();
            switch (problem.getSeverity()) {
                case ERROR: {
                    log.error(problemText);
                    break;
                }
                case WARNING: {
                    log.warning(problemText);
                }
            }
        }
    }

    private static void renderCallStack(CallGraph cg, CallLocation location, StringBuilder sb) {
        if (location == null) {
            return;
        }
        sb.append("\n    at ");
        TeaVMProblemRenderer.renderCallLocation(location.getMethod(), location.getSourceLocation(), sb);
        if (location.getMethod() != null) {
            Iterator<? extends CallSite> callSites;
            CallGraphNode node = cg.getNode(location.getMethod());
            while ((callSites = node.getCallerCallSites().iterator()).hasNext()) {
                CallSite callSite = callSites.next();
                sb.append("\n    at ");
                TeaVMProblemRenderer.renderCallLocation(callSite.getCaller().getMethod(), callSite.getLocation(), sb);
                node = callSite.getCaller();
            }
        }
    }

    private static void renderCallLocation(MethodReference method, InstructionLocation location, StringBuilder sb) {
        if (method != null) {
            sb.append(method.getClassName() + "." + method.getName());
        } else {
            sb.append("unknown method");
        }
        if (location != null) {
            sb.append("(");
            String fileName = location.getFileName();
            if (fileName != null) {
                sb.append(fileName.substring(fileName.lastIndexOf(47) + 1));
                sb.append(':');
            }
            sb.append(location.getLine());
            sb.append(')');
        }
    }
}

