/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.model;

import java.util.ArrayList;
import java.util.List;
import org.teavm.model.BasicBlock;
import org.teavm.model.MethodHolder;
import org.teavm.model.MethodReference;
import org.teavm.model.ProgramReader;
import org.teavm.model.Variable;

public class Program
implements ProgramReader {
    private List<BasicBlock> basicBlocks = new ArrayList<BasicBlock>();
    private List<Variable> variables = new ArrayList<Variable>();
    private MethodHolder method;
    private boolean packed;
    private int lastUsedRegister;

    public BasicBlock createBasicBlock() {
        BasicBlock block = new BasicBlock(this, this.basicBlocks.size());
        this.basicBlocks.add(block);
        return block;
    }

    public Variable createVariable() {
        Variable variable = new Variable(this);
        variable.setIndex(this.variables.size());
        this.variables.add(variable);
        variable.setRegister(this.lastUsedRegister++);
        return variable;
    }

    public void deleteBasicBlock(int index) {
        BasicBlock basicBlock = this.basicBlocks.get(index);
        if (basicBlock == null) {
            return;
        }
        this.basicBlocks.set(index, null);
        basicBlock.setIndex(-1);
        basicBlock.setProgram(null);
        this.packed = false;
    }

    @Override
    public int basicBlockCount() {
        return this.basicBlocks.size();
    }

    @Override
    public BasicBlock basicBlockAt(int index) {
        return this.basicBlocks.get(index);
    }

    public void deleteVariable(int index) {
        Variable variable = this.variables.get(index);
        if (variable == null) {
            return;
        }
        this.variables.set(index, null);
        variable.setIndex(-1);
        variable.setProgram(null);
        this.packed = false;
    }

    public boolean isPacked() {
        return this.packed;
    }

    public void pack() {
        int i;
        if (this.packed) {
            return;
        }
        int sz = 0;
        for (i = 0; i < this.basicBlocks.size(); ++i) {
            BasicBlock block = this.basicBlocks.get(i);
            if (block == null) continue;
            block.setIndex(sz);
            this.basicBlocks.set(sz++, block);
        }
        while (this.basicBlocks.size() > sz) {
            this.basicBlocks.remove(this.basicBlocks.size() - 1);
        }
        sz = 0;
        for (i = 0; i < this.variables.size(); ++i) {
            Variable var = this.variables.get(i);
            if (var == null) continue;
            var.setIndex(sz);
            this.variables.set(sz++, var);
        }
        while (this.variables.size() > sz) {
            this.variables.remove(this.variables.size() - 1);
        }
        this.packed = true;
    }

    @Override
    public int variableCount() {
        return this.variables.size();
    }

    @Override
    public Variable variableAt(int index) {
        return this.variables.get(index);
    }

    @Override
    public MethodReference getMethodReference() {
        return this.method != null ? this.method.getReference() : null;
    }

    MethodHolder getMethod() {
        return this.method;
    }

    void setMethod(MethodHolder method) {
        this.method = method;
    }
}

