/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.javascript;

import java.util.List;
import java.util.Set;
import org.teavm.codegen.NameFrequencyConsumer;
import org.teavm.javascript.ast.AssignmentStatement;
import org.teavm.javascript.ast.AsyncMethodNode;
import org.teavm.javascript.ast.AsyncMethodPart;
import org.teavm.javascript.ast.BinaryExpr;
import org.teavm.javascript.ast.BlockStatement;
import org.teavm.javascript.ast.BreakStatement;
import org.teavm.javascript.ast.ClassNode;
import org.teavm.javascript.ast.ConditionalExpr;
import org.teavm.javascript.ast.ConditionalStatement;
import org.teavm.javascript.ast.ConstantExpr;
import org.teavm.javascript.ast.ContinueStatement;
import org.teavm.javascript.ast.Expr;
import org.teavm.javascript.ast.ExprVisitor;
import org.teavm.javascript.ast.FieldNode;
import org.teavm.javascript.ast.GotoPartStatement;
import org.teavm.javascript.ast.InitClassStatement;
import org.teavm.javascript.ast.InstanceOfExpr;
import org.teavm.javascript.ast.InvocationExpr;
import org.teavm.javascript.ast.MethodNode;
import org.teavm.javascript.ast.MethodNodeVisitor;
import org.teavm.javascript.ast.MonitorEnterStatement;
import org.teavm.javascript.ast.MonitorExitStatement;
import org.teavm.javascript.ast.NativeMethodNode;
import org.teavm.javascript.ast.NewArrayExpr;
import org.teavm.javascript.ast.NewExpr;
import org.teavm.javascript.ast.NewMultiArrayExpr;
import org.teavm.javascript.ast.NodeModifier;
import org.teavm.javascript.ast.QualificationExpr;
import org.teavm.javascript.ast.RegularMethodNode;
import org.teavm.javascript.ast.ReturnStatement;
import org.teavm.javascript.ast.SequentialStatement;
import org.teavm.javascript.ast.Statement;
import org.teavm.javascript.ast.StatementVisitor;
import org.teavm.javascript.ast.StaticClassExpr;
import org.teavm.javascript.ast.SubscriptExpr;
import org.teavm.javascript.ast.SwitchClause;
import org.teavm.javascript.ast.SwitchStatement;
import org.teavm.javascript.ast.ThrowStatement;
import org.teavm.javascript.ast.TryCatchStatement;
import org.teavm.javascript.ast.UnaryExpr;
import org.teavm.javascript.ast.UnwrapArrayExpr;
import org.teavm.javascript.ast.VariableExpr;
import org.teavm.javascript.ast.WhileStatement;
import org.teavm.model.ClassReader;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.ElementModifier;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;

public class NameFrequencyEstimator
implements StatementVisitor,
ExprVisitor,
MethodNodeVisitor {
    private NameFrequencyConsumer consumer;
    private ClassReaderSource classSource;
    private boolean async;
    private Set<MethodReference> injectedMethods;
    private Set<MethodReference> asyncFamilyMethods;

    public NameFrequencyEstimator(NameFrequencyConsumer consumer, ClassReaderSource classSource, Set<MethodReference> injectedMethods, Set<MethodReference> asyncFamilyMethods) {
        this.consumer = consumer;
        this.classSource = classSource;
        this.injectedMethods = injectedMethods;
        this.asyncFamilyMethods = asyncFamilyMethods;
    }

    private void visit(List<Statement> statements) {
        for (Statement part : statements) {
            part.acceptVisitor(this);
        }
    }

    public void estimate(ClassNode cls) {
        this.consumer.consume(cls.getName());
        if (cls.getParentName() != null) {
            this.consumer.consume(cls.getParentName());
        }
        for (FieldNode field : cls.getFields()) {
            this.consumer.consume(new FieldReference(cls.getName(), field.getName()));
            if (!field.getModifiers().contains((Object)NodeModifier.STATIC)) continue;
            this.consumer.consume(cls.getName());
        }
        MethodReader clinit = this.classSource.get(cls.getName()).getMethod(new MethodDescriptor("<clinit>", ValueType.VOID));
        for (MethodNode method : cls.getMethods()) {
            this.consumer.consume(method.getReference());
            if (this.asyncFamilyMethods.contains(method.getReference())) {
                this.consumer.consume(method.getReference());
            }
            if (clinit != null && (method.getModifiers().contains((Object)NodeModifier.STATIC) || method.getReference().getName().equals("<init>"))) {
                this.consumer.consume(method.getReference());
            }
            if (!method.getModifiers().contains((Object)NodeModifier.STATIC)) {
                this.consumer.consume(method.getReference().getDescriptor());
                this.consumer.consume(method.getReference());
            }
            if (!method.isAsync()) continue;
            this.consumer.consumeFunction("$rt_nativeThread");
            this.consumer.consumeFunction("$rt_nativeThread");
            this.consumer.consumeFunction("$rt_resuming");
            this.consumer.consumeFunction("$rt_invalidPointer");
        }
        this.consumer.consume(cls.getName());
        this.consumer.consume(cls.getName());
        if (cls.getParentName() != null) {
            this.consumer.consume(cls.getParentName());
        }
        for (String iface : cls.getInterfaces()) {
            this.consumer.consume(iface);
        }
    }

    @Override
    public void visit(RegularMethodNode methodNode) {
        this.async = false;
        methodNode.getBody().acceptVisitor(this);
    }

    @Override
    public void visit(AsyncMethodNode methodNode) {
        this.async = true;
        for (AsyncMethodPart part : methodNode.getBody()) {
            part.getStatement().acceptVisitor(this);
        }
    }

    @Override
    public void visit(NativeMethodNode methodNode) {
    }

    @Override
    public void visit(AssignmentStatement statement) {
        if (statement.getLeftValue() != null) {
            statement.getLeftValue().acceptVisitor(this);
        }
        statement.getRightValue().acceptVisitor(this);
        if (statement.isAsync()) {
            this.consumer.consumeFunction("$rt_suspending");
        }
    }

    @Override
    public void visit(SequentialStatement statement) {
        this.visit(statement.getSequence());
    }

    @Override
    public void visit(ConditionalStatement statement) {
        statement.getCondition().acceptVisitor(this);
        this.visit(statement.getConsequent());
        this.visit(statement.getAlternative());
    }

    @Override
    public void visit(SwitchStatement statement) {
        statement.getValue().acceptVisitor(this);
        for (SwitchClause clause : statement.getClauses()) {
            this.visit(clause.getBody());
        }
        this.visit(statement.getDefaultClause());
    }

    @Override
    public void visit(WhileStatement statement) {
        if (statement.getCondition() != null) {
            statement.getCondition().acceptVisitor(this);
        }
        this.visit(statement.getBody());
    }

    @Override
    public void visit(BlockStatement statement) {
        this.visit(statement.getBody());
    }

    @Override
    public void visit(BreakStatement statement) {
    }

    @Override
    public void visit(ContinueStatement statement) {
    }

    @Override
    public void visit(ReturnStatement statement) {
        if (statement.getResult() != null) {
            statement.getResult().acceptVisitor(this);
        }
    }

    @Override
    public void visit(ThrowStatement statement) {
        statement.getException().acceptVisitor(this);
        this.consumer.consumeFunction("$rt_throw");
    }

    @Override
    public void visit(InitClassStatement statement) {
        this.consumer.consume(statement.getClassName());
    }

    @Override
    public void visit(TryCatchStatement statement) {
        this.visit(statement.getProtectedBody());
        this.visit(statement.getHandler());
        if (statement.getExceptionType() != null) {
            this.consumer.consume(statement.getExceptionType());
        }
    }

    @Override
    public void visit(GotoPartStatement statement) {
    }

    @Override
    public void visit(MonitorEnterStatement statement) {
        if (this.async) {
            MethodReference monitorEnterRef = new MethodReference(Object.class, "monitorEnter", Object.class, Void.TYPE);
            this.consumer.consume(monitorEnterRef);
            this.consumer.consumeFunction("$rt_suspending");
        } else {
            MethodReference monitorEnterRef = new MethodReference(Object.class, "monitorEnterSync", Object.class, Void.TYPE);
            this.consumer.consume(monitorEnterRef);
        }
    }

    @Override
    public void visit(MonitorExitStatement statement) {
        if (this.async) {
            MethodReference monitorEnterRef = new MethodReference(Object.class, "monitorExit", Object.class, Void.TYPE);
            this.consumer.consume(monitorEnterRef);
        } else {
            MethodReference monitorEnterRef = new MethodReference(Object.class, "monitorExitSync", Object.class, Void.TYPE);
            this.consumer.consume(monitorEnterRef);
        }
    }

    @Override
    public void visit(BinaryExpr expr) {
        expr.getFirstOperand().acceptVisitor(this);
        expr.getSecondOperand().acceptVisitor(this);
        switch (expr.getOperation()) {
            case COMPARE: {
                this.consumer.consumeFunction("$rt_compare");
                break;
            }
        }
    }

    @Override
    public void visit(UnaryExpr expr) {
        expr.getOperand().acceptVisitor(this);
        switch (expr.getOperation()) {
            case NULL_CHECK: {
                this.consumer.consumeFunction("$rt_nullCheck");
                break;
            }
        }
    }

    @Override
    public void visit(ConditionalExpr expr) {
        expr.getCondition().acceptVisitor(this);
        expr.getConsequent().acceptVisitor(this);
        expr.getAlternative().acceptVisitor(this);
    }

    @Override
    public void visit(ConstantExpr expr) {
        if (expr.getValue() instanceof ValueType) {
            this.visitType((ValueType)expr.getValue());
        }
    }

    private void visitType(ValueType type) {
        while (type instanceof ValueType.Array) {
            type = ((ValueType.Array)type).getItemType();
        }
        if (type instanceof ValueType.Object) {
            String clsName = ((ValueType.Object)type).getClassName();
            this.consumer.consume(clsName);
            this.consumer.consumeFunction("$rt_cls");
        }
    }

    @Override
    public void visit(VariableExpr expr) {
    }

    @Override
    public void visit(SubscriptExpr expr) {
        expr.getArray().acceptVisitor(this);
        expr.getIndex().acceptVisitor(this);
    }

    @Override
    public void visit(UnwrapArrayExpr expr) {
        expr.getArray().acceptVisitor(this);
    }

    @Override
    public void visit(InvocationExpr expr) {
        if (this.injectedMethods.contains(expr.getMethod())) {
            return;
        }
        switch (expr.getType()) {
            case SPECIAL: 
            case STATIC: {
                this.consumer.consume(expr.getMethod());
                break;
            }
            case CONSTRUCTOR: {
                this.consumer.consumeInit(expr.getMethod());
                break;
            }
            case DYNAMIC: {
                this.consumer.consume(expr.getMethod().getDescriptor());
            }
        }
    }

    @Override
    public void visit(QualificationExpr expr) {
        expr.getQualified().acceptVisitor(this);
        this.consumer.consume(expr.getField());
    }

    @Override
    public void visit(NewExpr expr) {
        this.consumer.consume(expr.getConstructedClass());
    }

    @Override
    public void visit(NewArrayExpr expr) {
        this.visitType(expr.getType());
        expr.getLength().acceptVisitor(this);
        if (!(expr.getType() instanceof ValueType.Primitive)) {
            this.consumer.consumeFunction("$rt_createArray");
        }
    }

    @Override
    public void visit(NewMultiArrayExpr expr) {
        this.visitType(expr.getType());
        for (Expr dimension : expr.getDimensions()) {
            dimension.acceptVisitor(this);
        }
    }

    @Override
    public void visit(InstanceOfExpr expr) {
        expr.getExpr().acceptVisitor(this);
        this.visitType(expr.getType());
        if (expr.getType() instanceof ValueType.Object) {
            String clsName = ((ValueType.Object)expr.getType()).getClassName();
            ClassReader cls = this.classSource.get(clsName);
            if (cls == null || cls.hasModifier(ElementModifier.INTERFACE)) {
                this.consumer.consumeFunction("$rt_isInstance");
            }
        } else {
            this.consumer.consumeFunction("$rt_isInstance");
        }
    }

    @Override
    public void visit(StaticClassExpr expr) {
        this.visitType(expr.getType());
    }
}

