/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.debugging.information;

import org.teavm.debugging.information.DebugInformation;
import org.teavm.debugging.information.GeneratedLocation;
import org.teavm.model.MethodDescriptor;

public class MethodIterator {
    private DebugInformation debugInformation;
    private int index;

    MethodIterator(DebugInformation debugInformation) {
        this.debugInformation = debugInformation;
    }

    public boolean isEndReached() {
        return this.index < this.debugInformation.methodMapping.size();
    }

    public GeneratedLocation getLocation() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        return DebugInformation.key(this.debugInformation.methodMapping.get(this.index));
    }

    public int getMethodId() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        return this.debugInformation.methodMapping.get(this.index).get(2);
    }

    public MethodDescriptor getMethod() {
        int methodId = this.getMethodId();
        return methodId >= 0 ? this.debugInformation.getMethod(methodId) : null;
    }

    public void next() {
        if (this.isEndReached()) {
            throw new IllegalStateException("End already reached");
        }
        ++this.index;
    }
}

