/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.common;

import com.carrotsearch.hppc.IntOpenHashSet;
import com.carrotsearch.hppc.cursors.IntCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import org.teavm.common.DominatorTree;
import org.teavm.common.Graph;
import org.teavm.common.GraphBuilder;
import org.teavm.common.GraphUtils;
import org.teavm.common.IntegerArray;
import org.teavm.common.IntegerStack;

public class GraphIndexer {
    static final byte NONE = 0;
    static final byte VISITING = 1;
    static final byte VISITED = 2;
    private int[] indexToNode;
    private int[] nodeToIndex;
    private Graph graph;
    private DominatorTree domTree;
    private int lastIndex;
    private int[] weights;
    private int[] priorities;

    public GraphIndexer(Graph graph, int[] weights, int[] priorities) {
        int sz = graph.size();
        this.weights = (int[])weights.clone();
        this.propagateWeights(graph, this.weights);
        this.priorities = (int[])priorities.clone();
        this.propagatePriorities(graph, this.priorities);
        this.indexToNode = new int[sz + 1];
        this.nodeToIndex = new int[sz + 1];
        Arrays.fill(this.nodeToIndex, -1);
        Arrays.fill(this.indexToNode, -1);
        this.graph = graph;
        this.domTree = GraphUtils.buildDominatorTree(graph);
        this.sort(graph);
        --this.lastIndex;
        for (int node = 0; node < sz; ++node) {
            int index = this.nodeToIndex[node];
            if (index < 0) continue;
            this.nodeToIndex[node] = index = this.lastIndex - index;
            this.indexToNode[index] = node;
        }
        this.indexToNode[sz] = sz;
        this.nodeToIndex[sz] = sz;
        GraphBuilder sorted = new GraphBuilder(this.lastIndex + 2);
        for (int i = 0; i <= this.lastIndex; ++i) {
            for (int next : graph.outgoingEdges(this.indexToNode[i])) {
                sorted.addEdge(i, this.nodeToIndex[next]);
            }
        }
        this.graph = sorted.build();
    }

    private void propagateWeights(Graph graph, int[] weights) {
        int sz = graph.size();
        byte[] state = new byte[sz];
        IntegerStack stack = new IntegerStack(sz * 2);
        stack.push(0);
        block4: while (!stack.isEmpty()) {
            int node = stack.pop();
            switch (state[node]) {
                case 1: {
                    state[node] = 2;
                    for (int succ : graph.outgoingEdges(node)) {
                        if (state[node] != 2) continue;
                        int n = node;
                        weights[n] = weights[n] + weights[succ];
                    }
                    continue block4;
                }
                case 0: {
                    state[node] = 1;
                    stack.push(node);
                    for (int succ : graph.outgoingEdges(node)) {
                        if (state[succ] != 0) continue;
                        stack.push(succ);
                    }
                    break;
                }
            }
        }
    }

    private void propagatePriorities(Graph graph, int[] priorities) {
        boolean allZero = true;
        for (int i = 0; i < priorities.length; ++i) {
            if (priorities[i] == 0) continue;
            allZero = false;
            break;
        }
        if (allZero) {
            return;
        }
        DominatorTree domTree = GraphUtils.buildDominatorTree(graph);
        Graph domGraph = GraphUtils.buildDominatorGraph(domTree, graph.size());
        IntegerStack stack = new IntegerStack(graph.size() * 2);
        for (int i = 0; i < domGraph.size(); ++i) {
            if (domGraph.outgoingEdgesCount(i) != 0) continue;
            stack.push(i);
        }
        while (!stack.isEmpty()) {
            int node = stack.pop();
            int parent = domTree.immediateDominatorOf(node);
            if (parent < 0 || priorities[parent] >= priorities[node]) continue;
            priorities[parent] = priorities[node];
            stack.push(parent);
        }
    }

    private void sort(Graph graph) {
        int sz = graph.size();
        byte[] state = new byte[sz];
        IntegerStack stack = new IntegerStack(sz * 2);
        stack.push(0);
        block4: while (!stack.isEmpty()) {
            int node = stack.pop();
            switch (state[node]) {
                case 1: {
                    state[node] = 2;
                    ++this.lastIndex;
                    break;
                }
                case 0: {
                    int succ;
                    int n;
                    state[node] = 1;
                    stack.push(node);
                    IntegerArray terminalNodes = new IntegerArray(1);
                    for (int n2 : graph.incomingEdges(node)) {
                        if (!this.domTree.dominates(node, n2)) continue;
                        terminalNodes.add(n2);
                    }
                    int[] successors = graph.outgoingEdges(node);
                    ArrayList<WeightedNode> succList = new ArrayList<WeightedNode>(successors.length);
                    IntegerArray orderedSuccessors = new IntegerArray(successors.length);
                    if (terminalNodes.size() > 0) {
                        IntOpenHashSet intOpenHashSet = IntOpenHashSet.from((int[])this.findNaturalLoop(node, terminalNodes.getAll()));
                        for (int succ2 : successors) {
                            if (!intOpenHashSet.contains(succ2)) continue;
                            succList.add(new WeightedNode(succ2, this.priorities[succ2], this.weights[succ2]));
                        }
                        Collections.sort(succList);
                        Object object = succList.iterator();
                        while (object.hasNext()) {
                            WeightedNode wnode = (WeightedNode)object.next();
                            orderedSuccessors.add(wnode.index);
                        }
                        IntOpenHashSet outerSuccessors = new IntOpenHashSet(successors.length);
                        succList.clear();
                        for (IntCursor loopNode : intOpenHashSet) {
                            for (int succ3 : graph.outgoingEdges(loopNode.value)) {
                                if (intOpenHashSet.contains(succ3) || !outerSuccessors.add(succ3)) continue;
                                succList.add(new WeightedNode(succ3, this.priorities[succ3], this.weights[succ3]));
                            }
                        }
                        Collections.sort(succList);
                        for (WeightedNode wnode : succList) {
                            orderedSuccessors.add(wnode.index);
                        }
                    } else {
                        int[] nArray = successors;
                        int outerSuccessors = nArray.length;
                        for (n = 0; n < outerSuccessors; ++n) {
                            succ = nArray[n];
                            succList.add(new WeightedNode(succ, this.priorities[succ], this.weights[succ]));
                        }
                        Collections.sort(succList);
                        for (WeightedNode wnode : succList) {
                            orderedSuccessors.add(wnode.index);
                        }
                    }
                    int[] object = successors = orderedSuccessors.getAll();
                    int n3 = object.length;
                    for (n = 0; n < n3; ++n) {
                        succ = object[n];
                        if (state[succ] != 0) continue;
                        stack.push(succ);
                    }
                    continue block4;
                }
            }
        }
    }

    private int[] findNaturalLoop(int head, int[] terminals) {
        IntOpenHashSet loop = new IntOpenHashSet();
        loop.add(head);
        IntegerStack stack = new IntegerStack(1);
        for (int pred : terminals) {
            stack.push(pred);
        }
        while (!stack.isEmpty()) {
            int node = stack.pop();
            if (!loop.add(node)) continue;
            for (int pred : this.graph.incomingEdges(node)) {
                stack.push(pred);
            }
        }
        return loop.toArray();
    }

    public int nodeAt(int index) {
        return this.indexToNode[index];
    }

    public int indexOf(int node) {
        return this.nodeToIndex[node];
    }

    public int size() {
        return this.indexToNode.length - 1;
    }

    public Graph getGraph() {
        return this.graph;
    }

    static class WeightedNode
    implements Comparable<WeightedNode> {
        int index;
        int priority;
        int weight;

        public WeightedNode(int index, int priority, int weight) {
            this.index = index;
            this.priority = priority;
            this.weight = weight;
        }

        @Override
        public int compareTo(WeightedNode o) {
            int r = Integer.compare(this.priority, o.priority);
            if (r != 0) {
                return r;
            }
            return Integer.compare(this.weight, o.weight);
        }
    }
}

