/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.codegen;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.teavm.codegen.AliasProvider;
import org.teavm.model.FieldReference;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReference;

public class MinifyingAliasProvider
implements AliasProvider {
    private static Set<String> keywords = new HashSet<String>(Arrays.asList("do", "if", "else", "for", "case", "goto", "in", "let", "new", "this", "try", "var", "void", "with"));
    private static String startLetters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private static String letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
    private static String startVirtualLetters = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    private int lastSuffix;
    private int lastVirtual;
    private Set<String> usedAliases = new HashSet<String>();

    @Override
    public String getAlias(FieldReference field) {
        String result;
        while (!this.usedAliases.add(result = this.getNewAlias(this.lastVirtual++, startVirtualLetters)) || keywords.contains(result)) {
        }
        return result;
    }

    @Override
    public String getAlias(MethodReference method) {
        return this.getNewAlias(this.lastSuffix++, startLetters);
    }

    @Override
    public String getAlias(MethodDescriptor method) {
        String result;
        while (!this.usedAliases.add(result = this.getNewAlias(this.lastVirtual++, startVirtualLetters)) || keywords.contains(result)) {
        }
        return result;
    }

    @Override
    public String getAlias(String className) {
        return this.getNewAlias(this.lastSuffix++, startLetters);
    }

    @Override
    public String getFunctionAlias(String className) {
        return this.getNewAlias(this.lastSuffix++, startLetters);
    }

    private String getNewAlias(int index, String startLetters) {
        StringBuilder sb = new StringBuilder();
        sb.append(startLetters.charAt(index % startLetters.length()));
        index /= startLetters.length();
        while (index > 0) {
            sb.append(letters.charAt(index % letters.length()));
            index /= letters.length();
        }
        return sb.toString();
    }
}

