/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.teavm.cache.AstIO;
import org.teavm.cache.FileNameEncoder;
import org.teavm.cache.SymbolTable;
import org.teavm.javascript.MethodNodeCache;
import org.teavm.javascript.ast.AssignmentStatement;
import org.teavm.javascript.ast.AsyncMethodNode;
import org.teavm.javascript.ast.AsyncMethodPart;
import org.teavm.javascript.ast.BinaryExpr;
import org.teavm.javascript.ast.BlockStatement;
import org.teavm.javascript.ast.BreakStatement;
import org.teavm.javascript.ast.ConditionalExpr;
import org.teavm.javascript.ast.ConditionalStatement;
import org.teavm.javascript.ast.ConstantExpr;
import org.teavm.javascript.ast.ContinueStatement;
import org.teavm.javascript.ast.Expr;
import org.teavm.javascript.ast.ExprVisitor;
import org.teavm.javascript.ast.GotoPartStatement;
import org.teavm.javascript.ast.InitClassStatement;
import org.teavm.javascript.ast.InstanceOfExpr;
import org.teavm.javascript.ast.InvocationExpr;
import org.teavm.javascript.ast.MethodNode;
import org.teavm.javascript.ast.MonitorEnterStatement;
import org.teavm.javascript.ast.MonitorExitStatement;
import org.teavm.javascript.ast.NewArrayExpr;
import org.teavm.javascript.ast.NewExpr;
import org.teavm.javascript.ast.NewMultiArrayExpr;
import org.teavm.javascript.ast.QualificationExpr;
import org.teavm.javascript.ast.RegularMethodNode;
import org.teavm.javascript.ast.ReturnStatement;
import org.teavm.javascript.ast.SequentialStatement;
import org.teavm.javascript.ast.Statement;
import org.teavm.javascript.ast.StatementVisitor;
import org.teavm.javascript.ast.StaticClassExpr;
import org.teavm.javascript.ast.SubscriptExpr;
import org.teavm.javascript.ast.SwitchClause;
import org.teavm.javascript.ast.SwitchStatement;
import org.teavm.javascript.ast.ThrowStatement;
import org.teavm.javascript.ast.TryCatchStatement;
import org.teavm.javascript.ast.UnaryExpr;
import org.teavm.javascript.ast.UnwrapArrayExpr;
import org.teavm.javascript.ast.VariableExpr;
import org.teavm.javascript.ast.WhileStatement;
import org.teavm.model.MethodReference;
import org.teavm.parsing.ClassDateProvider;

public class DiskRegularMethodNodeCache
implements MethodNodeCache {
    private File directory;
    private AstIO astIO;
    private ClassDateProvider classDateProvider;
    private Map<MethodReference, Item> cache = new HashMap<MethodReference, Item>();
    private Map<MethodReference, AsyncItem> asyncCache = new HashMap<MethodReference, AsyncItem>();
    private Set<MethodReference> newMethods = new HashSet<MethodReference>();
    private Set<MethodReference> newAsyncMethods = new HashSet<MethodReference>();

    public DiskRegularMethodNodeCache(File directory, SymbolTable symbolTable, SymbolTable fileTable, ClassDateProvider classDateProvider) {
        this.directory = directory;
        this.astIO = new AstIO(symbolTable, fileTable);
        this.classDateProvider = classDateProvider;
    }

    @Override
    public RegularMethodNode get(MethodReference methodReference) {
        Item item = this.cache.get(methodReference);
        if (item == null) {
            item = new Item();
            this.cache.put(methodReference, item);
            File file = this.getMethodFile(methodReference, false);
            if (file.exists()) {
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                    DataInputStream input = new DataInputStream(stream);
                    int depCount = input.readShort();
                    boolean dependenciesChanged = false;
                    for (int i = 0; i < depCount; ++i) {
                        String depClass = input.readUTF();
                        Date depDate = this.classDateProvider.getModificationDate(depClass);
                        if (depDate != null && !depDate.after(new Date(file.lastModified()))) continue;
                        dependenciesChanged = true;
                        break;
                    }
                    if (!dependenciesChanged) {
                        item.node = this.astIO.read(input, methodReference);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return item.node;
    }

    @Override
    public void store(MethodReference methodReference, RegularMethodNode node) {
        Item item = new Item();
        item.node = node;
        this.cache.put(methodReference, item);
        this.newMethods.add(methodReference);
    }

    @Override
    public AsyncMethodNode getAsync(MethodReference methodReference) {
        AsyncItem item = this.asyncCache.get(methodReference);
        if (item == null) {
            item = new AsyncItem();
            this.asyncCache.put(methodReference, item);
            File file = this.getMethodFile(methodReference, true);
            if (file.exists()) {
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                    DataInputStream input = new DataInputStream(stream);
                    int depCount = input.readShort();
                    boolean dependenciesChanged = false;
                    for (int i = 0; i < depCount; ++i) {
                        String depClass = input.readUTF();
                        Date depDate = this.classDateProvider.getModificationDate(depClass);
                        if (depDate != null && !depDate.after(new Date(file.lastModified()))) continue;
                        dependenciesChanged = true;
                        break;
                    }
                    if (!dependenciesChanged) {
                        item.node = this.astIO.readAsync(input, methodReference);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return item.node;
    }

    @Override
    public void storeAsync(MethodReference methodReference, AsyncMethodNode node) {
        AsyncItem item = new AsyncItem();
        item.node = node;
        this.asyncCache.put(methodReference, item);
        this.newAsyncMethods.add(methodReference);
    }

    public void flush() throws IOException {
        Throwable throwable;
        Object output;
        MethodNode node;
        AstDependencyAnalyzer analyzer;
        File file;
        for (MethodReference method : this.newMethods) {
            file = this.getMethodFile(method, true);
            analyzer = new AstDependencyAnalyzer();
            node = this.cache.get((Object)method).node;
            ((RegularMethodNode)node).getBody().acceptVisitor(analyzer);
            analyzer.dependencies.add(method.getClassName());
            output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            throwable = null;
            try {
                ((DataOutputStream)output).writeShort(analyzer.dependencies.size());
                for (String dependency : analyzer.dependencies) {
                    ((DataOutputStream)output).writeUTF(dependency);
                }
                this.astIO.write((DataOutput)output, (RegularMethodNode)node);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (output == null) continue;
                if (throwable != null) {
                    try {
                        ((FilterOutputStream)output).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((FilterOutputStream)output).close();
            }
        }
        for (MethodReference method : this.newAsyncMethods) {
            file = this.getMethodFile(method, true);
            analyzer = new AstDependencyAnalyzer();
            node = this.asyncCache.get((Object)method).node;
            for (AsyncMethodPart part : ((AsyncMethodNode)node).getBody()) {
                part.getStatement().acceptVisitor(analyzer);
            }
            analyzer.dependencies.add(method.getClassName());
            output = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(file)));
            throwable = null;
            try {
                ((DataOutputStream)output).writeShort(analyzer.dependencies.size());
                for (String dependency : analyzer.dependencies) {
                    ((DataOutputStream)output).writeUTF(dependency);
                }
                this.astIO.writeAsync((DataOutput)output, (AsyncMethodNode)node);
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                if (output == null) continue;
                if (throwable != null) {
                    try {
                        ((FilterOutputStream)output).close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    continue;
                }
                ((FilterOutputStream)output).close();
            }
        }
    }

    private File getMethodFile(MethodReference method, boolean async) {
        File dir = new File(this.directory, method.getClassName().replace('.', '/'));
        return new File(dir, FileNameEncoder.encodeFileName(method.getDescriptor().toString()) + ".teavm-ast" + (async ? "-async" : ""));
    }

    static class AsyncItem {
        AsyncMethodNode node;

        AsyncItem() {
        }
    }

    static class Item {
        RegularMethodNode node;

        Item() {
        }
    }

    static class AstDependencyAnalyzer
    implements StatementVisitor,
    ExprVisitor {
        Set<String> dependencies = new HashSet<String>();

        AstDependencyAnalyzer() {
        }

        private void visitSequence(List<Statement> statements) {
            for (Statement stmt : statements) {
                stmt.acceptVisitor(this);
            }
        }

        @Override
        public void visit(AssignmentStatement statement) {
            if (statement.getLeftValue() != null) {
                statement.getLeftValue().acceptVisitor(this);
            }
            statement.getRightValue().acceptVisitor(this);
        }

        @Override
        public void visit(SequentialStatement statement) {
            this.visitSequence(statement.getSequence());
        }

        @Override
        public void visit(ConditionalStatement statement) {
            statement.getCondition().acceptVisitor(this);
            this.visitSequence(statement.getConsequent());
            this.visitSequence(statement.getAlternative());
        }

        @Override
        public void visit(SwitchStatement statement) {
            statement.getValue().acceptVisitor(this);
            for (SwitchClause clause : statement.getClauses()) {
                this.visitSequence(clause.getBody());
            }
            this.visitSequence(statement.getDefaultClause());
        }

        @Override
        public void visit(WhileStatement statement) {
            if (statement.getCondition() != null) {
                statement.getCondition().acceptVisitor(this);
            }
            this.visitSequence(statement.getBody());
        }

        @Override
        public void visit(BlockStatement statement) {
            this.visitSequence(statement.getBody());
        }

        @Override
        public void visit(BreakStatement statement) {
        }

        @Override
        public void visit(ContinueStatement statement) {
        }

        @Override
        public void visit(ReturnStatement statement) {
            if (statement.getResult() != null) {
                statement.getResult().acceptVisitor(this);
            }
        }

        @Override
        public void visit(ThrowStatement statement) {
            statement.getException().acceptVisitor(this);
        }

        @Override
        public void visit(InitClassStatement statement) {
        }

        @Override
        public void visit(TryCatchStatement statement) {
            this.visitSequence(statement.getProtectedBody());
            this.visitSequence(statement.getHandler());
        }

        @Override
        public void visit(BinaryExpr expr) {
            expr.getFirstOperand().acceptVisitor(this);
            expr.getSecondOperand().acceptVisitor(this);
        }

        @Override
        public void visit(UnaryExpr expr) {
            expr.getOperand().acceptVisitor(this);
        }

        @Override
        public void visit(ConditionalExpr expr) {
            expr.getCondition().acceptVisitor(this);
            expr.getConsequent().acceptVisitor(this);
            expr.getAlternative().acceptVisitor(this);
        }

        @Override
        public void visit(ConstantExpr expr) {
        }

        @Override
        public void visit(VariableExpr expr) {
        }

        @Override
        public void visit(SubscriptExpr expr) {
            expr.getArray().acceptVisitor(this);
            expr.getIndex().acceptVisitor(this);
        }

        @Override
        public void visit(UnwrapArrayExpr expr) {
            expr.getArray().acceptVisitor(this);
        }

        @Override
        public void visit(InvocationExpr expr) {
            this.dependencies.add(expr.getMethod().getClassName());
            for (Expr argument : expr.getArguments()) {
                argument.acceptVisitor(this);
            }
        }

        @Override
        public void visit(QualificationExpr expr) {
            this.dependencies.add(expr.getField().getClassName());
            expr.getQualified().acceptVisitor(this);
        }

        @Override
        public void visit(NewExpr expr) {
        }

        @Override
        public void visit(NewArrayExpr expr) {
            expr.getLength().acceptVisitor(this);
        }

        @Override
        public void visit(NewMultiArrayExpr expr) {
            for (Expr dimension : expr.getDimensions()) {
                dimension.acceptVisitor(this);
            }
        }

        @Override
        public void visit(InstanceOfExpr expr) {
            expr.getExpr().acceptVisitor(this);
        }

        @Override
        public void visit(StaticClassExpr expr) {
        }

        @Override
        public void visit(GotoPartStatement statement) {
        }

        @Override
        public void visit(MonitorEnterStatement statement) {
        }

        @Override
        public void visit(MonitorExitStatement statement) {
        }
    }
}

