/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.io.IOException;
import java.lang.annotation.Annotation;
import org.teavm.backend.javascript.codegen.SourceWriter;
import org.teavm.backend.javascript.spi.Generator;
import org.teavm.backend.javascript.spi.GeneratorContext;
import org.teavm.backend.javascript.spi.Injector;
import org.teavm.backend.javascript.spi.InjectorContext;
import org.teavm.dependency.DependencyAgent;
import org.teavm.dependency.DependencyPlugin;
import org.teavm.dependency.MethodDependency;
import org.teavm.dependency.MethodDependencyInfo;
import org.teavm.model.ClassReader;
import org.teavm.model.MethodDescriptor;
import org.teavm.model.MethodReader;
import org.teavm.model.MethodReference;
import org.teavm.model.ValueType;
import org.teavm.platform.Platform;
import org.teavm.platform.PlatformClass;
import org.teavm.platform.PlatformRunnable;

public class PlatformGenerator
implements Generator,
Injector,
DependencyPlugin {
    public void methodReached(DependencyAgent agent, MethodDependency method) {
        switch (method.getReference().getName()) {
            case "asJavaClass": {
                method.getResult().propagate(agent.getType("java.lang.Class"));
                return;
            }
            case "clone": {
                method.getVariable(1).connect(method.getResult());
                break;
            }
            case "startThread": 
            case "schedule": {
                MethodDependency launchMethod = agent.linkMethod(new MethodReference(Platform.class, "launchThread", new Class[]{PlatformRunnable.class, Void.TYPE}));
                method.getVariable(1).connect(launchMethod.getVariable(1));
                launchMethod.use();
                break;
            }
            case "getCurrentThread": {
                method.getResult().propagate(agent.getType("java.lang.Thread"));
                break;
            }
            case "getEnumConstants": {
                method.getResult().propagate(agent.getType("[Ljava/lang/Enum;"));
                break;
            }
            case "getName": 
            case "getSimpleName": {
                method.getResult().propagate(agent.getType("java.lang.String"));
                break;
            }
            case "getEnclosingClass": 
            case "getDeclaringClass": {
                method.getResult().propagate(agent.getType("java.lang.Class"));
            }
        }
    }

    public void generate(InjectorContext context, MethodReference methodRef) throws IOException {
        switch (methodRef.getName()) {
            case "asJavaClass": 
            case "classFromResource": 
            case "objectFromResource": 
            case "marshall": 
            case "getPlatformObject": {
                context.writeExpr(context.getArgument(0));
                break;
            }
            case "initClass": {
                context.writeExpr(context.getArgument(0));
                context.getWriter().append(".$clinit()");
            }
        }
    }

    public void generate(GeneratorContext context, SourceWriter writer, MethodReference methodRef) throws IOException {
        switch (methodRef.getName()) {
            case "newInstanceImpl": {
                this.generateNewInstance(context, writer);
                break;
            }
            case "prepareNewInstance": {
                this.generatePrepareNewInstance(context, writer);
                break;
            }
            case "lookupClass": {
                this.generateLookup(context, writer);
                break;
            }
            case "clone": {
                this.generateClone(context, writer);
                break;
            }
            case "startThread": {
                this.generateSchedule(context, writer, false);
                break;
            }
            case "schedule": {
                this.generateSchedule(context, writer, true);
                break;
            }
            case "getEnumConstants": {
                this.generateEnumConstants(context, writer);
                break;
            }
            case "getAnnotations": {
                this.generateAnnotations(context, writer);
            }
        }
    }

    private void generatePrepareNewInstance(GeneratorContext context, SourceWriter writer) throws IOException {
        MethodDependencyInfo newInstanceMethod = context.getDependency().getMethod(new MethodReference(Platform.class, "newInstanceImpl", new Class[]{PlatformClass.class, Object.class}));
        writer.append("var c").ws().append("=").ws().append("'$$constructor$$';").softNewLine();
        if (newInstanceMethod != null) {
            for (String clsName : newInstanceMethod.getResult().getTypes()) {
                ClassReader cls = context.getClassSource().get(clsName);
                if (cls == null) continue;
                MethodReader method = cls.getMethod(new MethodDescriptor("<init>", new Class[]{Void.TYPE}));
                if (method == null) continue;
                writer.appendClass(clsName).append("[c]").ws().append("=").ws().appendMethodBody(method.getReference()).append(";").softNewLine();
            }
        }
    }

    private void generateNewInstance(GeneratorContext context, SourceWriter writer) throws IOException {
        String cls = context.getParameterName(1);
        writer.append("if").ws().append("($rt_resuming())").ws().append("{").indent().softNewLine();
        writer.append("var $r = $rt_nativeThread().pop();").softNewLine();
        writer.append(cls + ".$$constructor$$($r);").softNewLine();
        writer.append("if").ws().append("($rt_suspending())").ws().append("{").indent().softNewLine();
        writer.append("return $rt_nativeThread().push($r);").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("return $r;").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("if").ws().append("(!").append(cls).append(".hasOwnProperty('$$constructor$$'))").ws().append("{").indent().softNewLine();
        writer.append("return null;").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("var $r").ws().append('=').ws().append("new ").append(cls).append("();").softNewLine();
        writer.append(cls).append(".$$constructor$$($r);").softNewLine();
        writer.append("if").ws().append("($rt_suspending())").ws().append("{").indent().softNewLine();
        writer.append("return $rt_nativeThread().push($r);").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("return $r;").softNewLine();
    }

    private void generateLookup(GeneratorContext context, SourceWriter writer) throws IOException {
        String param = context.getParameterName(1);
        writer.append("switch ($rt_ustr(" + param + ")) {").softNewLine().indent();
        for (String name : context.getClassSource().getClassNames()) {
            writer.append("case \"" + name + "\": ").appendClass(name).append(".$clinit(); ").append("return ").appendClass(name).append(";").softNewLine();
        }
        writer.append("default: return null;").softNewLine();
        writer.outdent().append("}").softNewLine();
    }

    private void generateClone(GeneratorContext context, SourceWriter writer) throws IOException {
        String obj = context.getParameterName(1);
        writer.append("var copy").ws().append("=").ws().append("new ").append(obj).append(".constructor();").softNewLine();
        writer.append("for").ws().append("(var field in " + obj + ")").ws().append("{").softNewLine().indent();
        writer.append("if").ws().append("(!" + obj + ".hasOwnProperty(field))").ws().append("{").softNewLine().indent();
        writer.append("continue;").softNewLine().outdent().append("}").softNewLine();
        writer.append("copy[field]").ws().append("=").ws().append(obj).append("[field];").softNewLine().outdent().append("}").softNewLine();
        writer.append("return copy;").softNewLine();
    }

    private void generateSchedule(GeneratorContext context, SourceWriter writer, boolean timeout) throws IOException {
        MethodReference launchRef = new MethodReference(Platform.class, "launchThread", new Class[]{PlatformRunnable.class, Void.TYPE});
        String runnable = context.getParameterName(1);
        writer.append("return setTimeout(function()").ws().append("{").indent().softNewLine();
        if (timeout) {
            writer.appendMethodBody(launchRef);
        } else {
            writer.append("$rt_threadStarter(").appendMethodBody(launchRef).append(")");
        }
        writer.append("(").append(runnable).append(");").softNewLine();
        writer.outdent().append("},").ws().append(timeout ? context.getParameterName(2) : "0").append(");").softNewLine();
    }

    private void generateEnumConstants(GeneratorContext context, SourceWriter writer) throws IOException {
        writer.append("var c").ws().append("=").ws().append("'$$enumConstants$$';").softNewLine();
        for (String clsName : context.getClassSource().getClassNames()) {
            ClassReader cls = context.getClassSource().get(clsName);
            MethodReader method = cls.getMethod(new MethodDescriptor("values", new ValueType[]{ValueType.arrayOf((ValueType)ValueType.object((String)clsName))}));
            if (method == null) continue;
            writer.appendClass(clsName).append("[c]").ws().append("=").ws();
            writer.appendMethodBody(method.getReference());
            writer.append(";").softNewLine();
        }
        MethodReference selfRef = new MethodReference(Platform.class, "getEnumConstants", new Class[]{PlatformClass.class, Enum[].class});
        writer.appendMethodBody(selfRef).ws().append("=").ws().append("function(cls)").ws().append("{").softNewLine().indent();
        writer.append("if").ws().append("(!cls.hasOwnProperty(c))").ws().append("{").indent().softNewLine();
        writer.append("return null;").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("if").ws().append("(typeof cls[c]").ws().append("===").ws().append("\"function\")").ws().append("{").indent().softNewLine();
        writer.append("cls[c]").ws().append("=").ws().append("cls[c]();").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("return cls[c];").softNewLine();
        writer.outdent().append("};").softNewLine();
        writer.append("return ").appendMethodBody(selfRef).append("(").append(context.getParameterName(1)).append(");").softNewLine();
    }

    private void generateAnnotations(GeneratorContext context, SourceWriter writer) throws IOException {
        writer.append("var c").ws().append("=").ws().append("'$$annotations$$';").softNewLine();
        for (String clsName : context.getClassSource().getClassNames()) {
            ClassReader annotCls = context.getClassSource().get(clsName + "$$__annotations__$$");
            if (annotCls == null) continue;
            writer.appendClass(clsName).append("[c]").ws().append("=").ws();
            MethodReference ctor = new MethodReference(annotCls.getName(), "<init>", new ValueType[]{ValueType.VOID});
            writer.appendInit(ctor);
            writer.append("();").softNewLine();
        }
        MethodReference selfRef = new MethodReference(Platform.class, "getAnnotations", new Class[]{PlatformClass.class, Annotation[].class});
        writer.appendMethodBody(selfRef).ws().append("=").ws().append("function(cls)").ws().append("{").softNewLine().indent();
        writer.append("if").ws().append("(!cls.hasOwnProperty(c))").ws().append("{").indent().softNewLine();
        writer.append("return null;").softNewLine();
        writer.outdent().append("}").softNewLine();
        writer.append("return cls[c].").appendMethod("getAnnotations", new Class[]{Annotation[].class}).append("();").softNewLine();
        writer.outdent().append("};").softNewLine();
        writer.append("return ").appendMethodBody(selfRef).append("(").append(context.getParameterName(1)).append(");").softNewLine();
    }
}

