/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.teavm.backend.c.generate.FileGenerator;
import org.teavm.backend.c.generators.Generator;
import org.teavm.backend.c.generators.GeneratorContext;
import org.teavm.common.HashUtils;
import org.teavm.common.ServiceRepository;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.MetadataGenerator;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;
import org.teavm.platform.plugin.DefaultMetadataGeneratorContext;
import org.teavm.platform.plugin.ResourceTypeDescriptor;
import org.teavm.platform.plugin.ResourceTypeDescriptorProvider;

class MetadataCIntrinsic
implements Generator {
    private Set<String> writtenStructures = new HashSet<String>();
    private Set<MethodReference> writtenInitializers = new HashSet<MethodReference>();
    private DefaultMetadataGeneratorContext metadataContext;
    private Map<MethodReference, MethodGenerator> generatorMap = new HashMap<MethodReference, MethodGenerator>();

    MetadataCIntrinsic() {
    }

    void init(ClassReaderSource classSource, ClassLoader classLoader, ServiceRepository services, Properties properties) {
        this.metadataContext = new DefaultMetadataGeneratorContext(classSource, classLoader, properties, services);
    }

    public void addGenerator(MethodReference constructor, MethodReference method, MetadataGenerator generator) {
        this.generatorMap.put(constructor, new MethodGenerator(method, generator));
    }

    public boolean canHandle(MethodReference methodReference) {
        return this.generatorMap.containsKey(methodReference);
    }

    public void generate(GeneratorContext context, MethodReference method) {
        MethodGenerator generator = this.generatorMap.get(method);
        context.writer().print("return ");
        generator.apply(context, method);
        context.writer().println(";");
    }

    void writeValue(GeneratorContext context, Object value) {
        if (value == null) {
            context.writerBefore().print("NULL");
        } else if (value instanceof String) {
            int stringIndex = context.stringPool().getStringIndex((String)value);
            context.includes().includePath("strings.h");
            context.writerBefore().print("(TeaVM_Object**) TEAVM_GET_STRING_ADDRESS(" + stringIndex + ")");
        } else if (value instanceof Boolean) {
            context.writerBefore().print((Boolean)value != false ? "1" : "0");
        } else if (value instanceof Integer) {
            int n = (Integer)value;
            if (n < 0) {
                context.writerBefore().print("-");
                n = -n;
            }
            context.writerBefore().print("INT32_C(" + n + ")");
        } else if (value instanceof Long) {
            long n = (Long)value;
            if (n < 0L) {
                context.writerBefore().print("-");
                n = -n;
            }
            context.writerBefore().print("INT64_C(" + n + ")");
        } else if (value instanceof Byte || value instanceof Short || value instanceof Float || value instanceof Double) {
            context.writerBefore().print(value.toString());
        } else if (value instanceof ResourceTypeDescriptorProvider && value instanceof Resource) {
            this.writeResource(context, (ResourceTypeDescriptorProvider)value);
        } else if (value instanceof ResourceMap) {
            this.writeResourceMap(context, (ResourceMap)value);
        } else if (value instanceof ResourceArray) {
            this.writeResourceArray(context, (ResourceArray)value);
        } else {
            throw new IllegalArgumentException("Don't know how to write resource: " + value);
        }
    }

    private void writeResource(GeneratorContext context, ResourceTypeDescriptorProvider resourceType) {
        this.writeResourceStructure(context, resourceType.getDescriptor());
        String structureName = context.names().forClass(resourceType.getDescriptor().getRootInterface().getName());
        Object[] propertyValues = resourceType.getValues();
        context.writerBefore().print("&(" + structureName + ") {").indent();
        boolean first = true;
        for (String propertyName : resourceType.getDescriptor().getPropertyTypes().keySet()) {
            if (!first) {
                context.writerBefore().print(",");
            }
            first = false;
            context.writerBefore().println().print(".").print(propertyName).print(" = ");
            int index = resourceType.getPropertyIndex(propertyName);
            Object propertyValue = propertyValues[index];
            this.writeValue(context, propertyValue);
        }
        context.writerBefore().println().outdent().print("}");
    }

    private void writeResourceStructure(GeneratorContext context, ResourceTypeDescriptor structure) {
        String className = structure.getRootInterface().getName();
        String fileName = "resources/" + context.escapeFileName(className) + ".h";
        context.includes().includePath(fileName);
        if (!this.writtenStructures.add(className)) {
            return;
        }
        for (Class<?> propertyType : structure.getPropertyTypes().values()) {
            if (!Resource.class.isAssignableFrom(propertyType) || ResourceMap.class.isAssignableFrom(propertyType) || ResourceArray.class.isAssignableFrom(propertyType)) continue;
            ResourceTypeDescriptor propertyStructure = this.metadataContext.getTypeDescriptor(propertyType.asSubclass(Resource.class));
            this.writeResourceStructure(context, propertyStructure);
        }
        FileGenerator file = context.createHeaderFile(fileName);
        String structureName = context.names().forClass(className);
        file.writer().println("typedef struct " + structureName + " {").indent();
        file.includes().includePath("runtime.h");
        for (String propertyName : structure.getPropertyTypes().keySet()) {
            Class<?> propertyType = structure.getPropertyTypes().get(propertyName);
            file.writer().println(this.typeToString(propertyType) + " " + propertyName + ";");
        }
        file.writer().outdent().println("} " + structureName + ";");
    }

    private String typeToString(Class<?> cls) {
        if (cls == Boolean.TYPE || cls == Byte.TYPE) {
            return "int8_t";
        }
        if (cls == Short.TYPE || cls == Character.TYPE) {
            return "int16_t";
        }
        if (cls == Integer.TYPE) {
            return "int32_t";
        }
        if (cls == Float.TYPE) {
            return "float";
        }
        if (cls == Long.TYPE) {
            return "int64_t";
        }
        if (cls == Double.TYPE) {
            return "double";
        }
        if (Resource.class.isAssignableFrom(cls)) {
            return "void*";
        }
        if (cls == String.class) {
            return "TeaVM_Object**";
        }
        throw new IllegalArgumentException("Don't know how to write resource type " + cls);
    }

    private void writeResourceArray(GeneratorContext context, ResourceArray<?> resourceArray) {
        context.writerBefore().println("&(struct { int32_t size; void* data[" + resourceArray.size() + "]; }) {").indent();
        context.writerBefore().println(".size = " + resourceArray.size() + ",");
        context.writerBefore().print(".data = {").indent();
        boolean first = true;
        for (int i = 0; i < resourceArray.size(); ++i) {
            if (!first) {
                context.writerBefore().print(",");
            }
            context.writerBefore().println();
            first = false;
            this.writeValue(context, resourceArray.get(i));
        }
        context.writerBefore().println().outdent().println("}");
        context.writerBefore().outdent().print("}");
    }

    private void writeResourceMap(GeneratorContext context, ResourceMap<?> resourceMap) {
        String[] bestTable = HashUtils.createHashTable((String[])resourceMap.keys());
        context.includes().includePath("resource.h");
        context.writerBefore().println("&(struct { int32_t size; TeaVM_ResourceMapEntry entries[" + bestTable.length + "]; }) {").indent();
        context.writerBefore().println(".size = " + bestTable.length + ",");
        context.writerBefore().print(".entries = {").indent();
        boolean first = true;
        for (String key : bestTable) {
            if (!first) {
                context.writerBefore().print(",");
            }
            context.writerBefore().println();
            first = false;
            if (key == null) {
                context.writerBefore().print("{ NULL, NULL }");
                continue;
            }
            context.writerBefore().print("{ TEAVM_GET_STRING_ADDRESS(" + context.stringPool().getStringIndex(key) + "), ");
            this.writeValue(context, resourceMap.get(key));
            context.writerBefore().print("}");
        }
        context.writerBefore().println().outdent().println("}");
        context.writerBefore().outdent().print("}");
    }

    class MethodGenerator {
        private MethodReference targetMethod;
        private MetadataGenerator generator;

        MethodGenerator(MethodReference targetMethod, MetadataGenerator generator) {
            this.targetMethod = targetMethod;
            this.generator = generator;
        }

        public void apply(GeneratorContext context, MethodReference methodReference) {
            this.writeInitializer(context, methodReference);
            context.writer().print("resource_" + context.names().forMethod(methodReference));
        }

        private void writeInitializer(GeneratorContext context, MethodReference methodReference) {
            if (!MetadataCIntrinsic.this.writtenInitializers.add(methodReference)) {
                return;
            }
            String variableName = "resource_" + context.names().forMethod(methodReference);
            context.writerBefore().print("static ").printType(methodReference.getReturnType()).print(" ").print(variableName).print(" = ");
            if (this.generator == null) {
                context.writerBefore().print("NULL");
            } else {
                Resource resource = this.generator.generateMetadata(MetadataCIntrinsic.this.metadataContext, this.targetMethod);
                MetadataCIntrinsic.this.writeValue(context, resource);
            }
            context.writerBefore().println(";");
        }
    }
}

