/*
 * Decompiled with CFR 0.152.
 */
package org.teavm.platform.plugin;

import org.teavm.ast.Expr;
import org.teavm.ast.InvocationExpr;
import org.teavm.backend.c.intrinsic.Intrinsic;
import org.teavm.backend.c.intrinsic.IntrinsicContext;
import org.teavm.model.ClassReaderSource;
import org.teavm.model.MethodReference;
import org.teavm.platform.metadata.Resource;
import org.teavm.platform.metadata.ResourceArray;
import org.teavm.platform.metadata.ResourceMap;

public class ResourceReadCIntrinsic
implements Intrinsic {
    private ClassReaderSource classSource;

    public ResourceReadCIntrinsic(ClassReaderSource classSource) {
        this.classSource = classSource;
    }

    public boolean canHandle(MethodReference method) {
        return this.classSource.isSuperType(Resource.class.getTypeName(), method.getClassName()).orElse(false);
    }

    public void apply(IntrinsicContext context, InvocationExpr invocation) {
        if (invocation.getMethod().getClassName().equals(ResourceMap.class.getName())) {
            this.applyForResourceMap(context, invocation);
            return;
        }
        if (invocation.getMethod().getClassName().equals(ResourceArray.class.getName())) {
            this.applyForResourceArray(context, invocation);
            return;
        }
        String name = invocation.getMethod().getName();
        if (name.startsWith("get")) {
            name = name.substring(3);
        } else if (name.startsWith("is")) {
            name = name.substring(2);
        } else {
            throw new IllegalArgumentException();
        }
        name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        String resourceName = "resources/" + context.escapeFileName(invocation.getMethod().getClassName()) + ".h";
        context.includes().includePath(resourceName);
        boolean isString = invocation.getMethod().getReturnType().isObject("java.lang.String");
        if (isString) {
            context.writer().print("teavm_dereferenceNullable(");
        }
        context.writer().print("TEAVM_FIELD(");
        context.emit((Expr)invocation.getArguments().get(0));
        context.writer().print(", ").print(context.names().forClass(invocation.getMethod().getClassName()));
        context.writer().print(", ").print(name).print(")");
        if (isString) {
            context.writer().print(")");
        }
    }

    private void applyForResourceMap(IntrinsicContext context, InvocationExpr invocation) {
        context.includes().includePath("resource.h");
        switch (invocation.getMethod().getName()) {
            case "keys": {
                context.writer().print("teavm_resourceMapKeys((TeaVM_ResourceMap*) ");
                context.emit((Expr)invocation.getArguments().get(0));
                context.writer().print(")");
                break;
            }
            case "has": {
                context.writer().print("(teavm_lookupResource((TeaVM_ResourceMap*) ");
                context.emit((Expr)invocation.getArguments().get(0));
                context.writer().print(", (TeaVM_String*) ");
                context.emit((Expr)invocation.getArguments().get(1));
                context.writer().print(") != NULL)");
                break;
            }
            case "get": {
                context.writer().print("teavm_lookupResourceValue((TeaVM_ResourceMap*) ");
                context.emit((Expr)invocation.getArguments().get(0));
                context.writer().print(", (TeaVM_String*) ");
                context.emit((Expr)invocation.getArguments().get(1));
                context.writer().print(")");
            }
        }
    }

    private void applyForResourceArray(IntrinsicContext context, InvocationExpr invocation) {
        context.includes().includePath("resource.h");
        switch (invocation.getMethod().getName()) {
            case "size": {
                context.writer().print("((TeaVM_ResourceArray*) ");
                context.emit((Expr)invocation.getArguments().get(0));
                context.writer().print(")->size");
                break;
            }
            case "get": {
                context.writer().print("((TeaVM_ResourceArray*) ");
                context.emit((Expr)invocation.getArguments().get(0));
                context.writer().print(")->data[");
                context.emit((Expr)invocation.getArguments().get(1));
                context.writer().print("]");
            }
        }
    }
}

